@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <div class="welcome-text">
                    <h4>Edit Match League</h4>
                    <span class="ml-1">Layout</span>
                </div>
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.create_challenge') }}">Challenge
                            Category</a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Edit</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Form</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form
                                action="{{ route($modelName . '.edit_match_challenge', base64_encode(serialize($challenge->id))) }}"
                                method="POST" id="MatchAddForm">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Match Name:</label>
                                        <label class="form-check-label"> <b>{{ ucwords($findmatchnames->name) }}</b></label>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label>Challenge Type</label>
                                        <div class="col-sm-10">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="challenge_type"
                                                    value="money" <?php if($challenge->challenge_type=='money'){?> checked <?php } ?>>
                                                <label class="form-check-label">
                                                    Fixed Challenge
                                                </label>
                                            </div>
                                            <!-- <div class="form-check">
                                                  <input class="form-check-input" type="radio" name="challenge_type" value="percentage" <?php if($challenge->challenge_type=='percentage'){?> checked <?php } ?>>
                                                  <label class="form-check-label">
                                                      Percentage based
                                                  </label>
                                              </div> -->
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Entry fee</label>
                                        <input class="form-control" name="entryfee" id="entryfee" type="number"
                                            value="{{ $challenge->entryfee }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('entryfee'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>wining amount</label>
                                        <input type="number" id="win_amount" name="win_amount" class="form-control"
                                            value="{{ $challenge->win_amount }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('win_amount'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Minimum number of users</label>
                                        <input class="form-control" name="minimum_user" id="minimum_user" type="number"
                                            value="{{ $challenge->minimum_user }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('minimum_user'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Maximum number of users</label>
                                        <input type="number" id="maximum_user" name="maximum_user" class="form-control"
                                            value="{{ $challenge->maximum_user }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('maximum_user'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Challenge Category</label>
                                        <select class="form-control" name="challenge_category_id"
                                            id="challenge_category_id">
                                            <option value="">Select Category</option>
                                            @if (count($category) > 0)
                                                @foreach ($category as $value)
                                                    <option value="{{ $value->id }}" <?php if ($value->id == $challenge->challenge_category_id) {
                                                        echo 'selected';
                                                    } ?>>
                                                        {{ $value->name }} </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('challenge_category_id'); ?>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-6">
                                        <label>Discount Price</label>
                                        <input type="number" id="dis_price" name="dis_price" class="form-control" value="{{ $challenge->dis_price }}">
                                         <div class="error-message help-inline">
                                          <?php //echo $errors->first('dis_price');
                                          ?>
                                        </div>
                                    </div> -->

                                    <div class="form-group col-md-6">
                                        <label>Is Free</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_free" name="is_free"
                                                value="1" <?php if ($challenge->is_free == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Free</label>
                                        </div>
                                    </div>
                                    @if ($challenge->multi_entry == 1)
                                        <div class="form-group col-md-6">
                                            <label>Multi Entry</label>
                                            <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" id="multi_entry"
                                                    name="multi_entry" value="1" <?php if ($challenge->multi_entry == 1) {
                                                        echo 'checked';
                                                    } ?>
                                                    onclick="show4();">
                                                <label class="form-check-label">multi entry</label>
                                            </div>
                                        </div>
                                    @else
                                        <div class="form-group col-md-6">
                                            <label>Multi Entry</label>
                                            <div class="form-check mb-2">
                                                <input type="checkbox" class="form-check-input" id="multi_entry"
                                                    name="multi_entry" value="1" <?php if ($challenge->multi_entry == 1) {
                                                        echo 'checked';
                                                    } ?>
                                                    onclick="show4();">
                                                <label class="form-check-label">multi entry</label>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="form-group col-md-6" id="freeTeamOffer">
                                        <label>Is Offer Team </label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="freeTeamOfferCheck"
                                                name="is_offer_team" value="1" <?php if ($challenge->multi_entry == 1) {
                                                    echo 'checked';
                                                } ?>
                                                onclick="FreeTeamOfferInput();">
                                            <label class="form-check-label">Is Offer Team</label>
                                        </div>
                                    </div>
                                    <!-- <div class="form-group col-md-6" id="freeTeamOfferinp">
                                        <label>Free Team Number</label>
                                        <input type="number" id="freeTeamOfferinp" name="offer_team_no"
                                            class="form-control" value="{{ $challenge->offer_team_no }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('offer_team_no'); ?>
                                        </div>
                                    </div> -->




                                    <div class="form-group col-md-6">
                                        <label>Confirmed Challenge</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="confirmed_challenge"
                                                name="confirmed_challenge" value="1" <?php if ($challenge->confirmed_challenge == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">confirmed challenge</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">

                                    <!-- <div class="form-group col-md-6">
                                      <label>Can Use Bonus</label>
                                      <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input" id="bonus" name="bonus" value="1" <?php if ($challenge->bonus == 1) {
                                              echo 'checked';
                                          } ?> onclick="show3();" >
                                          <label class="form-check-label">can use bonus</label>
                                      </div>
                                    </div> -->
                                    <div class="form-group col-md-6">
                                        <label>Can Use Bonus</label>
                                        <div class="form-check mb-2">
                                            <!--<input type="checkbox" class="form-check-input" id="bonus" name="bonus" value="1" <?php if ($challenge->bonus == 1) {
                                                echo 'checked';
                                            } ?> onclick="show3();" >-->
                                            <input type="radio" class="form-check-input" id="bonus" name="bonus"
                                                value="1" <?php if ($challenge->bonus == 1) {
                                                    echo 'checked';
                                                } ?> onclick="show3();">
                                            <label class="form-check-label">can use bonus</label>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Can Use GST Bonus</label>
                                        <div class="form-check mb-2">
                                            <input type="radio" class="form-check-input" id="gst_bonus" name="bonus"
                                                value="2" <?php if ($challenge->gst_bonus == 1) {
                                                    echo 'checked';
                                                } ?> onclick="show5();">
                                            <label class="form-check-label">can use GST bonus</label>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6" id="bonus_precents">
                                        <label>Bonus precent</label>
                                        <input type="number" id="bonus_precent" name="bonus_precent"
                                            class="form-control" value="{{ $challenge->bonus_precent }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('bonus_precent'); ?>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-6">
                                      <label>Is Running</label>
                                      <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input" id="is_running" name="is_running" value="1" <?php if ($challenge->is_running == 1) {
                                              echo 'checked';
                                          } ?>>
                                          <label class="form-check-label">is running</label>
                                      </div>
                                    </div> -->
                                    <!-- <div class="form-group col-md-6">
                                        <label>Is Flexible</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_flexible"
                                                name="is_flexible" value="1" <?php if ($challenge->is_flexible == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">is flexible</label>
                                        </div>
                                    </div> -->
                                    @if (!empty($listmatches))
                                        @if ($listmatches->is_unlimited_credits == 1)
                                            <!-- <div class="form-group col-md-6">
                                                <label>Is Unlimited Credit Contest</label>
                                                <div class="form-check mb-2">
                                                    <input type="checkbox" class="form-check-input"
                                                        onchange="is_unlimited_credit_contest(event)"
                                                        id="is_unlimited_credit_contest"
                                                        name="is_unlimited_credit_contest" value="1"
                                                        <?php if ($challenge->is_unlimited_credit_contest == 1) {
                                                            echo 'checked';
                                                        } ?>>
                                                    <label class="form-check-label">Is Unlimited Credit Contest</label>
                                                </div>


                                            </div> -->
                                        @endif
                                    @endif

                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Loop stop</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="loops"
                                                name="loops" value="1" <?php if ($challenge->loops == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">loop stop</label>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-6">
                                      <label>Show On Top</label>
                                      <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input" id="show_on_top" name="show_on_top" value="1" <?php if ($challenge->show_on_top == 1) {
                                              echo 'checked';
                                          } ?>>
                                          <label class="form-check-label">Show On Top</label>
                                      </div>
                                    </div> -->

                                    <!-- <div class="form-group col-md-6">
                                        <label>Is Free For Referrer</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_free_for_referrer"
                                                name="is_free_for_referrer" value="1" <?php if ($challenge->is_free_for_referrer == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Free For Referrer</label>
                                        </div>
                                    </div> -->
                                    <!-- <div class="form-group col-md-6">
                                        <label>Join Similar Contest</label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_join_similar_contest"
                                                name="is_join_similar_contest" value="1" onclick="show33();"
                                                <?php if ($challenge->is_join_similar_contest == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Join Similar Contest</label>
                                        </div>
                                    </div> -->
                                    <!-- <div class="form-group col-md-4" id="join_contest_limit" style="display: none;">
                                      <label class="lbl_frm py-2">Join Similar Contest limit</label>
                                        <input type="number" min="0" id="join_C_limit" name="join_similar_contest_limit" class="form-control in_text" value="{{ $challenge->join_similar_contest_limit }}">
                                         <div class="error-message help-inline">
                                          <?php //echo $errors->first('join_similar_contest_limit');
                                          ?>
                                        </div>
                                    </div> -->
                                </div>

                                <!-- <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Enable Bots </label>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_manual_bot" name="is_manual_bot" value="1" <?php if ($challenge->is_manual_bot == 1) {
                                                echo 'checked';
                                            } ?>>
                                            <label class="form-check-label">Enable Bots </label>
                                        </div>
                                      </div>
                                      <div class="form-group col-md-6">
                                            <label>Number of Bots</label>
                                          <input type="number"   name="number_of_bots" class="form-control" value="{{ $challenge->number_of_bots }}">
                                           <div class="error-message help-inline">
                                            <?php echo $errors->first('number_of_bots'); ?>
                                          </div>
                                      </div>
                                    </div> -->

                                <!-- <div class="form-group col-md-6">
                                            <label>Bots after every minutes?</label>
                                            <div class="form-check mb-2">
                                                <input type="number"   name="bots_cron_minutes" class="form-control" value="{{ $challenge->bots_cron_minutes }}">

                                            </div>
                                          </div> -->
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
      Content body end
    ***********************************-->


    <script type="text/javascript">
        function is_unlimited_credit_contest(event) {
            if (event.target.checked) {
                $("#toggleSecondStartDate1").show();
            } else {
                $("#toggleSecondStartDate1").hide();
            }
        }

        function show3() {
            if (document.getElementById("bonus").checked == true) {
                document.getElementById('bonus_precents').style.display = 'block';
            } else {
                document.getElementById('bonus_precents').style.display = 'none';
            }
        }

        function show5() {
            if (document.getElementById("gst_bonus").checked == true) {
                document.getElementById('bonus_precents').style.display = 'block';
            } else {
                document.getElementById('bonus_precents').style.display = 'none';
            }
        }

        function show33() {
            if (document.getElementById("is_join_similar_contest").checked == true) {
                document.getElementById('join_contest_limit').style.display = 'block';
            } else {
                document.getElementById('join_contest_limit').style.display = 'none';
            }
        }

        $(document).ready(function() {
            let canUseBonus = <?php echo $challenge->bonus; ?>;
            console.log(canUseBonus);
            if (canUseBonus == 1)
                $("#bonus_precents").show();
            else
                $("#bonus_precents").hide();

            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

        });




        function show4() {
            if (document.getElementById("multi_entry").checked == true) {
                document.getElementById('freeTeamOffer').style.display = 'block';
                if (document.getElementById("freeTeamOfferCheck").checked == true) {
                    document.getElementById('freeTeamOfferinp').style.display = 'block';
                }
            } else {
                document.getElementById('freeTeamOffer').style.display = 'none';
                document.getElementById('freeTeamOfferinp').style.display = 'none';
            }
        }
        $(document).ready(function() {
            let freeTeamOffer = <?php echo $challenge->multi_entry; ?>;
            console.log(freeTeamOffer);
            if (freeTeamOffer == 1) {
                $("#freeTeamOffer").show();
            } else {
                $("#freeTeamOffer").hide();
                $("#freeTeamOfferinp").hide();
                $(document).on("click", "#cancel_btn", function() {
                    let href = $(".breadcrumb-item.active a").attr("href");
                    window.location = href;
                });
            }

        });





        function FreeTeamOfferInput() {

            if (document.getElementById("freeTeamOfferCheck").checked == true) {
                document.getElementById('freeTeamOfferinp').style.display = 'block';
            } else {
                document.getElementById('freeTeamOfferinp').style.display = 'none';
            }
        }
        $(document).ready(function() {
            let freeTeamOffer = <?php echo $challenge->is_offer_team; ?>;
            //alert(freeTeamOffer);
            if (freeTeamOffer == 1) {
                $("#freeTeamOfferinp").show();
            } else {
                $("#freeTeamOfferinp").hide();

                $(document).on("click", "#cancel_btn", function() {
                    let href = $(".breadcrumb-item.active a").attr("href");
                    window.location = href;
                });
            }

        });
    </script>
@endsection
