@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--- ckeditor js start  here -->
    <script src="{{ asset('assets/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/js/admin/ckeditor/ckeditor.js') }}"></script>
    <!--- ckeditor js end  here -->

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Terms & Conditions</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route($modelName . '.terms') }}">Terms & Conditions</a></li>
                </ol> -->
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Terms & Conditions</h4>
                    </div>
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="basic-form">
                            <form action="{{ route('Contrents.terms') }}" method="POST" enctype="multipart/form-data"
                                id="termsForm" @csrf <div class="form-group row">
                                <label class="col-sm-2 col-form-label">Title</label>
                                <div class="col-sm-10">
                                    <input type="text" placeholder="enter title here" class="form-control"
                                        value="{{ $content->page_name }}" readonly="readonly">
                                </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-2 col-form-label">Content</label>
                            <div class="col-sm-10">
                                <textarea class="form-control ckeditor" rows="4" id="content" name="content">{{ $content->content }}</textarea>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
                <div class="card-footer py-4">
                    <button type="submit" class="btn btn-primary mr-2" id="submit_form">Save Page</button>
                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!--**********************************
    Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                window.location = "{{ route('admin_dashboard') }}";
            });

            $("#submit_form").click(function() {
                let error = 0;
                let content = CKEDITOR.instances['content'].getData();
                if (content == '') {
                    error++;
                }

                if (error > 0) {
                    alert("please fill content.");
                    return false;
                } else {
                    $("#termsForm")[0].submit();
                }
            });

        });
    </script>

@endsection
