@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!--- ckeditor js start  here -->
    <script src="{{ asset('assets/js/admin/ckeditor/ckeditor.js') }}"></script>
    <!--- ckeditor js end  here -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <!-- row -->
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view_pages') }}">All Pages</a></li>
                <li class="breadcrumb-item">Update</li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Page Detail</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form
                                action="{{ route($modelName . '.update_pages', base64_encode(serialize($pagedata->id))) }}"
                                method="POST" id="pageupdate" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Page Name</label>
                                        <input class="form-control in_text" autocomplete="off" id="page_name"
                                            name="page_name" type="text"
                                            value="{{ html_entity_decode($pagedata->page_name) }}">
                                        {{ $errors->first('page_name') }}
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Page Title</label>
                                        <input class="form-control in_text" autocomplete="off" id="page_name" name="title"
                                            type="text" value="{{ html_entity_decode($pagedata->title) }}">
                                        {{ $errors->first('title') }}
                                    </div>
                                </div>

                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Header</label>
                                        <select name="is_header" id="is_header" class="form-control">
                                            <option value="" disabled>Select Header</option>
                                            <option value="0" <?php if ($pagedata->is_header == '0') {
                                                echo 'selected';
                                            } ?>>Hide</option>
                                            <option value="1" <?php if ($pagedata->is_header == '1') {
                                                echo 'selected';
                                            } ?>>Show</option>
                                        </select>
                                        {{ $errors->first('is_header') }}
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Footer</label>
                                        <select name="is_footer" id="is_footer" class="form-control">
                                            <option value="0" <?php if ($pagedata->is_footer == '0') {
                                                echo 'selected';
                                            } ?>>Hide</option>
                                            <option value="1" <?php if ($pagedata->is_footer == '1') {
                                                echo 'selected';
                                            } ?>>Show</option>
                                        </select>
                                        {{ $errors->first('is_footer') }}
                                    </div>

                                </div>

                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Page URL</label>
                                        <input class="form-control in_text" autocomplete="off" id="page_url"
                                            name="page_url" type="text"
                                            value="{{ html_entity_decode($pagedata->page_url) }}">
                                            <div class="error-message help-inline">
                                      {{ $errors->first('page_url') }}
                                    </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Web Title</label>
                                        <input class="form-control in_text" autocomplete="off" id="web_title"
                                            name="web_title" type="text"
                                            value="{{ html_entity_decode($pagedata->web_title) }}">
                                        {{ $errors->first('page_url') }}
                                    </div>

                                </div>

                                <div class="form-row">
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Page Content</label>
                                        <div class="col-sm-10">
                                            <textarea class="form-control ckeditor" rows="4" id="content" name="content">{{ html_entity_decode($pagedata->content) }}</textarea>
                                            {{ $errors->first('content') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Meta Content</label>
                                        <div class="col-sm-10">
                                            <textarea class="form-control ckeditor" rows="4" id="meta_content" name="meta_content">{{ html_entity_decode($pagedata->meta_content) }}</textarea>
                                            <!-- {{ $errors->first('content') }} -->
                                        </div>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#dob").datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
    <!--**********************************
        Content body end
        ***********************************-->
@endsection
