@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<script src="{{asset('assets/js/bootstrap.js')}}"></script>
<script src="{{asset('assets/js/admin/ckeditor/ckeditor.js')}}"></script>
<!--*************************** Content body start  *****************************-->
<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <div class="welcome-text">
                    <h4>Add Email</h4>
                    <span class="ml-1">Layout</span>
                </div>
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{route($modelName.'.index')}}">View all Email</a></li>
                    <li class="breadcrumb-item active"><a href="javascript:void(0)">Add</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{route($modelName.'.add')}}" method="POST" id="offersAddForm" enctype="" >
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <label>Name</label>
                                        <input type="text" placeholder="Enter Name" name="name" id="name"  class="form-control" value="">
                                         <div class="error-message help-inline">
                                          <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Subject</label>
                                        <input class="form-control" autocomplete="off" placeholder="Enter Subject" id="subject" name="subject" type="text" value="">
                                         <div class="error-message help-inline">
                                          <?php echo $errors->first('subject'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Action</label>
                                        <input class="form-control" placeholder="Enter action" id="action" name="action" type="text" value="">
                                         <div class="error-message help-inline">
                                          <?php echo $errors->first('action'); ?>
                                        </div>
                                    </div>
                                </div>

                                 <div class="form-row">
                                    <div class="form-group col-md-12">
                                       <label>Description</label>
                                       <div class="col-sm-10">
                                          <textarea class="form-control ckeditor" rows="4" id="description" name="description"></textarea>
                                            <div class="error-message help-inline">
                                              <?php echo $errors->first('description'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button class="btn btn-gray" type="button">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--*************************** Content body end ***********************************-->
@endsection
