@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!--********************************** Content body start  ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <div class="row page-titles mx-0" data-aos="fade-up">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Edit Offers</h4>
                            <span class="ml-1">Layout</span>
                        </div>
                    </div>

                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route($modelName.'.viewOffers')}}">View all offers</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Edit</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->
                <div class="row">
                    <div class="col-xl-12 col-xxl-12">
                        <div class="card" data-aos="fade-up">
                            <!-- <div class="card-header">
                                <h4 class="card-title">Edit Offers</h4>
                            </div> -->
                            <div class="card-body">
                                <div class="basic-form">
                                    <form action="{{route($modelName.'.addOffers')}}" method="post" id="offersAddForm" enctype="multipart/form-data" >
                                        @csrf
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Minimum Amount</label>
                                                <input id="minamount" type="text" placeholder="enter minimum amount here" name="minamount" class="form-control" value="">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('minamount'); ?>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Bonus</label>
                                                <input class="form-control" autocomplete="off" placeholder="enter bonus here" id="bonus" name="bonus" type="text" value="">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('bonus'); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                               <fieldset class="form-group">
                                                    <div class="row">
                                                        <label class="col-form-label col-sm-2 pt-0">Bonus Type</label>
                                                        <div class="col-sm-10">
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="bonus_type" id="bonus_type" value="per">
                                                                <label class="form-check-label">
                                                                    Percentage
                                                                </label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="bonus_type" id="bonus_type" value="rs">
                                                                <label class="form-check-label">
                                                                    Rupees
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </fieldset>
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('bonus_type'); ?>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Promo Code</label>
                                                <input class="form-control" autocomplete="off" placeholder="enter promo code here" id="code" name="code" type="text" value="">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('code'); ?>
                                                </div>
                                            </div>
                                        </div>
                                         <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Expire Date</label>
                                                <input class="form-control datetimepickerget" autocomplete="off" placeholder="enter expire date here" id="expire_date" name="expire_date" type="text" value="">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('expire_date'); ?>
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Description</label>
                                                <input class="form-control" autocomplete="off" placeholder="enter description here" id="description" name="description" type="text" value="">
                                                 <div class="error-message help-inline">
                                                  <?php echo $errors->first('description'); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        <button class="btn btn-gray" type="button">Cancel</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
@endsection
