@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <script src="{{ asset('assets/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/js/ckeditor/ckeditor.js') }}"></script>
    <!--************************** Content body start  *****************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Email</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.index') }}">Default Email Templates</a>
                    </li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4>Edit Email Templates</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.edit', base64_encode(serialize($emailtemplate_data->id))) }}"
                                method="post" id="EditEmailForm" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <label class="lbl_frm py-2">Name</label>
                                        <input type="text" placeholder="Enter Name" name="name" id="name"
                                            class="form-control in_text" value="{{ $emailtemplate_data->name }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label class="lbl_frm py-2">Subject</label>
                                        <input class="form-control in_text" autocomplete="off" placeholder="Enter Subject"
                                            id="subject" name="subject" type="text"
                                            value="{{ $emailtemplate_data->subject }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('subject'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label class="lbl_frm py-2">Action</label>
                                        <input class="form-control in_text" placeholder="Enter action" id="action"
                                            name="action" type="text" value="{{ $emailtemplate_data->action }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('action'); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label class="col-sm-1 lbl_frm py-2 px-0">Description</label>
                                        <div class="col-sm-11 overflow-hidden px-0 w-90">
                                            <textarea class="form-control ckeditor in_text " rows="4" id="description" name="description">{{ $emailtemplate_data->body }}</textarea>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('description'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="card-footer py-4">
                        <button type="submit" class="btn btn-primary mr-2" id="submit_form">Submit</button>
                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--*********************** Content body end ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });

            $("#submit_form").click(function() {
                let error = 0;
                let message = CKEDITOR.instances['description'].getData();
                $("#EditEmailForm").find("input").each(function(e) {
                    if ($(this).val() == '') {
                        error++;
                    }
                });

                if (message == '') {
                    error++;
                }

                if (error > 0) {
                    alert("please fill all fields.");
                    return false;
                } else {
                    $("#EditEmailForm")[0].submit();
                }
            });


        });
    </script>
@endsection
