@extends('admin.layouts.default')
@section('content')
    <!--**********************************
    Content body start
    ***********************************-->
    <!-- row -->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-xxl-12 pl-4 mx-2 pr-5">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="widget-quantity" data-aos="fade-up" data-aos-once="true">
                            <div class="card">
                                <div class="card-body">
                                    <div class="basic-form">
                                        <form action="{{ route($modelName . '.activeUsersdaywiseGraph') }}" method="GET">
                                            @csrf
                                            @php
                                                $matchkey = '';
                                                $start_date = '';
                                                $end_date = '';
                                                if (isset($_GET['start_date'])) {
                                                    $start_date = $_GET['start_date'];
                                                }
                                                if (isset($_GET['end_date'])) {
                                                    $end_date = $_GET['end_date'];
                                                }
                                            @endphp
                                            <div class="form-row">
                                                <div class="form-group col-md-3 mb-0">
                                                    <label>Start Date</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="text" required="" name="start_date"
                                                            id="start_date"
                                                            class="pull-left form-control datetimepickerget w-95"
                                                            value="{{ isset($start_date) && !empty($start_date) ? $start_date : '' }}"
                                                            autocomplete="off">
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>End Date</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="text" required="" name="end_date" id="end_date"
                                                            class="pull-left form-control datetimepickerget w-95"
                                                            value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}"
                                                            autocomplete="off">
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>&ensp;</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="submit" class="btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>

                                        </form>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="widget-content">
                                            <h4>All Active & Registered Users

                                                @if (isset($total_active_users) && !empty($total_active_users))
                                                    <form
                                                        action="{{ route($modelName . '.activeUsersdaywiseGraphdownload') }}"
                                                        method="GET">
                                                        @csrf
                                                        <input type="hidden" name="start_date"
                                                            value="{{ isset($start_date) && !empty($start_date) ? $start_date : '' }}">
                                                        <input type="hidden" name="end_date"
                                                            value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}">

                                                        <div class="form-group col-md-3 mb-0">
                                                            <label>&ensp;</label>
                                                            <div class="form-group col-md-6">
                                                                <input type="submit" class="btn btn-primary"
                                                                    value="Download Report">
                                                            </div>
                                                        </div>
                                                    </form>
                                                @endif
                                            </h4>
                                        </div>

                                    </div>
                                    <div class="chart mt-3">
                                        <canvas id="total_amount_add"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- $days[]  = date_format(date_create($total_active_users_val['date']) ,"d M Y");
          $amount[] = floatval($total_active_users_val['total_active_users']);
            $add_cash_color[] = "#25d5f2"; -->

    <!--****************** Content body end *************************-->
    <!-------------Show Total Amount Add Month Wise------------>
    @php
        $days = [];
        $amount = [];
        $withdraw_amount = [];
        $add_cash_color = [];
        $withdraw_cash_color = [];

    @endphp
    @if (isset($total_active_users) && !empty($total_active_users))
        @foreach ($total_active_users as $total_active_users_val)
            @php
                $days[] = date_format(date_create($total_active_users_val->date), 'd M Y');
                $amount[] = floatval($total_active_users_val->total_active_users);
                $add_cash_color[] = '#25d5f2';
            @endphp
        @endforeach
    @else
        $days=array();
        $amount=array();
    @endif

    @if (isset($total_registers) && !empty($total_registers))
        @foreach ($total_registers as $total_registers_val)
            @php
                $withdraw_amount[] = floatval($total_registers_val->total_registers);
                $withdraw_cash_color[] = '#ff407b';
            @endphp
        @endforeach
    @else
        $withdraw_amount=array();
    @endif


    <script src="//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>

    <script type="text/javascript">
        //datepicket without time
        $(document).ready(function() {
            $('#end_date,#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
        });

        var ctx = document.getElementById("total_amount_add").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?php echo json_encode($days); ?>,
                datasets: [{
                        label: "Active Users",
                        backgroundColor: <?php echo json_encode($add_cash_color); ?>,
                        data: <?php echo json_encode($amount); ?>,
                    },
                    {
                        label: "Register Users",
                        backgroundColor: <?php echo json_encode($withdraw_cash_color); ?>,
                        data: <?php echo json_encode($withdraw_amount); ?>,
                    }
                ]
            },
        });
    </script>


    <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

@endsection
