@extends('admin.layouts.default')
@section('content')
    <!--**********************************
    Content body start
    ***********************************-->
    <!-- row -->

    <?php $montharray = ['1' => 'January', '2' => 'February', '3' => 'Match', '4' => 'April', '5' => 'May', '6' => 'Jun', '7' => 'July', '8' => 'August', '9' => 'Sepetmber', '10' => 'Octomber', '11' => 'November', '12' => 'December']; ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-xxl-12 pl-4 mx-2 pr-5">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="widget-quantity" data-aos="fade-up" data-aos-once="true">
                            <div class="card">
                                <div class="card-body">
                                    <div class="basic-form">
                                        <form action="{{ route($modelName . '.perdayperformreport') }}" method="GET">
                                            @csrf
                                            @php
                                                $matchkey = '';
                                                $start_date = '';
                                                $end_date = '';
                                                if (isset($_GET['start_date'])) {
                                                    $start_date = $_GET['start_date'];
                                                }
                                                if (isset($_GET['end_date'])) {
                                                    $end_date = $_GET['end_date'];
                                                }
                                                if (isset($_GET['year'])) {
                                                    $year = $_GET['year'];
                                                }
                                                if (isset($_GET['month'])) {
                                                    $month = $_GET['month'];
                                                }
                                                if (isset($_GET['type'])) {
                                                    $type = $_GET['type'];
                                                }
                                                if (isset($_GET['week'])) {
                                                    $week = $_GET['week'];
                                                }
                                            @endphp
                                            <div class="form-row">
                                                <div class="form-group col-md-3 mb-0">
                                                    <label>Year</label>
                                                    <div class="form-group col-md-6">
                                                        <select name="year" class="pull-left form-control">
                                                            <option value="2024"
                                                                @if (isset($year) && !empty($year) && $year == '2024') selected @endif>2024
                                                            </option>
                                                            <option value="2023"
                                                                @if (isset($year) && !empty($year) && $year == '2023') selected @endif>2023
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>Month</label>
                                                    <div class="form-group col-md-6">
                                                        <select name="month" class="pull-left form-control">
                                                            <option value=""> Select Month</option>
                                                            @foreach ($montharray as $key => $value)
                                                                <option value="{{ $key }}"
                                                                    @if (isset($month) && !empty($month) && $month == $key) selected @endif>
                                                                    {{ $value }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group col-md-3 mb-0">
                                                    <label>Week</label>
                                                    <div class="form-group col-md-6">
                                                        <select name="week" class="pull-left form-control">
                                                            <option value=""> Select Week</option>
                                                            <option value="current"
                                                                @if (isset($week) && !empty($week) && $week == 'current') selected @endif>Current
                                                                Week</option>
                                                            <option value="last"
                                                                @if (isset($week) && !empty($week) && $week == 'last') selected @endif>Last Week
                                                            </option>
                                                            <!-- <option value="register" @if (isset($type) && !empty($type) && $type == 'register') selected @endif>Register User</option>
                                              <option value="withdraw" @if (isset($type) && !empty($type) && $type == 'withdraw') selected @endif>Withdraw</option>
                                              <option value="addcash" @if (isset($type) && !empty($type) && $type == 'addcash') selected @endif>Add Cash</option>
                                              <option value="active" @if (isset($type) && !empty($type) && $type == 'active') selected @endif>Active User</option> -->
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-3 mb-0">
                                                    <label>&ensp;</label>
                                                    <div class="form-group col-md-6">
                                                        <input type="submit" class="btn btn-primary">
                                                    </div>
                                                </div>

                                            </div>
                                            <!-- <div class="form-row">
                                              <div class="form-group col-md-3 mb-0">
                                                  <label>Start Date</label>
                                                  <div class="form-group col-md-6">
                                                  <input type="text" required="" name="start_date" id="start_date" class="pull-left form-control datetimepickerget w-95" value="{{ isset($start_date) && !empty($start_date) ? $start_date : '' }}" autocomplete="off">
                                              </div>
                                              </div>

                                              <div class="form-group col-md-3 mb-0">
                                                  <label>End Date</label>
                                                  <div class="form-group col-md-6">
                                                  <input type="text" required="" name="end_date" id="end_date" class="pull-left form-control datetimepickerget w-95" value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}" autocomplete="off">
                                              </div>
                                              </div>

                                              <div class="form-group col-md-3 mb-0">
                                                  <label>&ensp;</label>
                                                  <div class="form-group col-md-6">
                                               <input type="submit" class="btn btn-primary">
                                              </div>
                                              </div>

                                           </div> -->

                                        </form>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="widget-content">
                                            <h4>All Activity</h4>
                                        </div>

                                    </div>
                                    <div class="form-row">

                                        <div class="form-group col-md-6 mb-0">
                                            <div class="form-group col-md-6">
                                                <div class="chart mt-6">
                                                    <canvas id="total_register_user"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6 mb-0">
                                            <div class="form-group col-md-6">
                                                <div class="chart mt-6">
                                                    <canvas id="total_amount_add"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6 mb-0">
                                            <div class="form-group col-md-6">
                                                <div class="chart mt-6">
                                                    <canvas id="total_amount_add_cash"></canvas>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6 mb-0">
                                            <div class="form-group col-md-6">
                                                <div class="chart mt-6">
                                                    <canvas id="total_amount_withdraw"></canvas>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!--****************** Content body end *************************-->
        <!-------------Show Total Amount Add Month Wise------------>
        @php
            $days = [];
            $amount = [];
            $total_add_cash_amount = [];
            $withdraw_amount = [];
            $total_withdraw_amount = [];
            $add_cash_color = [];
            $withdraw_cash_color = [];
            $withdraw_cash_color2 = [];
            $total_add_cash_color = [];

        @endphp
        @if (isset($total_active_users) && !empty($total_active_users))
            @foreach ($total_active_users as $total_active_users_val)
                @php
                    $days[] = date_format(date_create($total_active_users_val->date), 'd M Y');
                    $amount[] = floatval($total_active_users_val->total_active_users);
                    $add_cash_color[] = '#25d5f2';
                @endphp
            @endforeach
        @else
            $days=array();
            $amount=array();
        @endif

        @if (isset($total_registers) && !empty($total_registers))
            @foreach ($total_registers as $total_registers_val)
                @php
                    $withdraw_amount[] = floatval($total_registers_val->total_registers);
                    $withdraw_cash_color[] = '#ff407b';
                    $daysregister[] = date_format(date_create($total_registers_val->date), 'd M Y');
                @endphp
            @endforeach
            @if (isset($_GET['month']))
                @php
                    $daysregister[] = '';
                @endphp
            @endif
        @else
            $withdraw_amount=array();
        @endif

        @if (isset($total_add_cash) && !empty($total_add_cash))
            @foreach ($total_add_cash as $total_total_add_cash_val)
                @php
                    $total_add_cash_amount[] = floatval($total_total_add_cash_val->total_add_amount);
                    $daysadd[] = date_format(date_create($total_total_add_cash_val->date), 'd M Y');
                    $total_add_cash_color[] = '#93C572';
                @endphp
            @endforeach
            @if (isset($_GET['month']))
                @php
                    $daysadd[] = '';
                @endphp
            @endif
        @else
            $total_add_cash_amount=array();
        @endif
        @if (isset($user_withdraw_amount) && !empty($user_withdraw_amount))
            @foreach ($user_withdraw_amount as $total_user_withdraw_amount)
                @php
                    $total_withdraw_amount[] = floatval($total_user_withdraw_amount->user_withdraw_amount);
                    $dayswithdraw[] = date_format(date_create($total_user_withdraw_amount->date), 'd M Y');
                    $withdraw_cash_color2[] = '#2052ec';
                @endphp
            @endforeach
            @if (isset($_GET['month']))
                @php
                    $dayswithdraw[] = '';
                @endphp
            @endif
        @else
            $total_withdraw_amount=array();
        @endif

        <script src="//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>

        <script type="text/javascript">
            //datepicket without time
            $(document).ready(function() {
                $('#end_date,#start_date').datetimepicker({
                    timepicker: false,
                    format: 'Y-m-d'
                });
            });

            var ctx = document.getElementById("total_amount_add").getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($days); ?>,
                    datasets: [{
                            label: "Active Users",
                            backgroundColor: <?php echo json_encode($add_cash_color); ?>,
                            data: <?php echo json_encode($amount); ?>,
                        },
                        // {
                        //     label: "Register Users",
                        //     backgroundColor: <?php echo json_encode($withdraw_cash_color); ?>,
                        //     data:<?php echo json_encode($withdraw_amount); ?>,
                        // },
                        // {
                        //     label: "withdraw",
                        //     backgroundColor: <?php echo json_encode($withdraw_cash_color2); ?>,
                        //     data:<?php echo json_encode($total_withdraw_amount); ?>,
                        // },
                        // {
                        //     label: "Add Cash",
                        //     backgroundColor: <?php echo json_encode($total_add_cash_color); ?>,
                        //     data:<?php echo json_encode($total_add_cash_amount); ?>,
                        // }

                    ]
                },
            });

            var ctx = document.getElementById("total_amount_withdraw").getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($dayswithdraw); ?>,
                    datasets: [{
                            label: "withdraw",
                            backgroundColor: <?php echo json_encode($withdraw_cash_color2); ?>,
                            data: <?php echo json_encode($total_withdraw_amount); ?>,
                        }

                    ]
                },
            });
            var ctx = document.getElementById("total_amount_add_cash").getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($daysadd); ?>,
                    datasets: [{
                            label: "Add Cash",
                            backgroundColor: <?php echo json_encode($total_add_cash_color); ?>,
                            data: <?php echo json_encode($total_add_cash_amount); ?>,
                        }

                    ]
                },
            });
            var ctx = document.getElementById("total_register_user").getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($daysregister); ?>,
                    datasets: [{
                            label: "Register Users",
                            backgroundColor: <?php echo json_encode($withdraw_cash_color); ?>,
                            data: <?php echo json_encode($withdraw_amount); ?>,
                        },

                    ]
                },
            });
        </script>


        <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>
        <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>

    @endsection
