@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Leauges Details</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin_dashboard') }}">Dashbaord</a></li>
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.seriesList') }}">Deposit Investments
                            List</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-lg-12">
                <div class="card" data-aos="fade-up">

                    <div class="card-header">
                        <h4 class="card-title"><b>Deposit Investments Name : </b> {{ $name }}</h4>
                    </div>

                    <div class="card-header">
                        <h4 class="card-title">Price cards Detail</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive mb-3 pb-3">

                            <table class="table table-bordered table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Min Position</th>
                                        <th>Max Position</th>
                                        <th>wining users</th>
                                        <th>Each winner amount</th>
                                        <th>Total amount</th>
                                        <th>GADGETS IMAGE</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (!empty($findallpricecards))
                                        <?php
                                        $snoo = 1;
                                        $countpricecards = count($findallpricecards);
                                        ?>
                                        @foreach ($findallpricecards as $pricecars)
                                            <tr>
                                                <th>{{ $snoo }}</th>
                                                <td>{{ $pricecars->min_position }}</td>
                                                <td>{{ $pricecars->max_position }}</td>
                                                <td>{{ $pricecars->winners }}</td>
                                                <td>{{ $pricecars->price }}</td>
                                                <td>{{ $pricecars->total }}</td>
                                                <td>
                                                    <?php if(!empty($pricecars->gadget_image)){?>
                                                    <img src="<?php echo DEFAULT_TEAM_IMAGE_URL_CDN_URL . 'uploads/banners/' . $pricecars->gadget_image; ?>"
                                                        style="width:50px;height:50px; border-radius:2px;">
                                                    <?php }else echo "" ?>
                                                </td>

                                                @if ($snoo == $countpricecards)
                                                    <td>
                                                        <a class="delbtn btn btn-danger"
                                                            href="{{ route($modelName . '.deleteDepositInvestmentLeaderboardPricecard', base64_encode(serialize($pricecars->id))) }}"
                                                            onclick="return confirm('Do you really want to delete?');">
                                                            Delete </a>
                                                    </td>
                                                @else
                                                    <td></td>
                                                @endif
                                            </tr>
                                            <?php $snoo++; ?>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>

                            <div class="col-md-12">
                                <div class="card-header">
                                    <h4 class="card-title">Add New Price Card</h4>
                                </div>
                                <div class="card-body">
                                    <div class="basic-form">
                                        <form
                                            action="{{ route($modelName . '.addDepositInvestmentLeaderboardLeaderboardPricecard') }}"
                                            method="post" enctype="multipart/form-data" id="price_cardAddForm">
                                            @csrf
                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm py-2">Start Position</label>
                                                    <input type="number" min="{{ $min_position }}" id="min_position"
                                                        name="min_position" class="form-control in_text"
                                                        value="{{ $min_position }}">
                                                    <div class="error-message help-inline">
                                                        <?php echo $errors->first('min_position'); ?>
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm">Number of winners</label>
                                                    <input type="number" min="1" id="winners" name="winners"
                                                        class="form-control in_text" value="{{ old('winners') }}"
                                                        placeholder="Enter number of winnners here">
                                                    <div class="error-message help-inline">
                                                        <?php echo $errors->first('winners'); ?>
                                                    </div>
                                                </div>

                                                <div class="form-group col-md-4">
                                                    <label class="lbl_frm py-2">Price Amount</label>
                                                    <input type="text" min="0" id="price" name="price"
                                                        class="form-control in_text" value="{{ old('price') }}"
                                                        placeholder="Enter wining amount">
                                                    <div class="error-message help-inline">
                                                        <?php echo $errors->first('price'); ?>
                                                    </div>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <!-- <label>Multi Entry</label> -->
                                                    <div class="form-check mb-2">
                                                        <input type="checkbox" class="form-check-input"
                                                            onchange="showHideGadgetFields(event)" id="is_gadgets"
                                                            name="is_gadgets" value="1">
                                                        <label class="form-check-label" for="is_gadgets">Is Gadgets
                                                            ?</label>
                                                    </div>
                                                </div>
                                                <div class="form-group col-md-8" style="display:none"
                                                    id="toggleGadgetFields">
                                                    <label class="lbl_frm">Gadgets Image </label>
                                                    <input class="form-control in_text" name="gadget_image"
                                                        id="gadget_image" type="file">

                                                </div>

                                            </div>
                                            <div class="py-2">
                                                <input type="hidden" name="series_id" value="{{ $depositid }}">
                                                <button type="submit" class="btn btn-primary mr-2">Add Price Card</button>
                                                <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- /# card -->
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {

            $("#gadget_image").validate({
                rules: {
                    Name: {
                        required: true,
                        minlength: 3
                    },
                    gadget_image_Image: {
                        required: true,
                        extension: "jpg|jpeg|png"

                    }
                },
                messages: {
                    gadget_image_Image: {
                        extension: "Please select only jpg , jpeg and png images"
                    }
                }

            });


            //validate file extension custom  method.
            jQuery.validator.addMethod("extension", function(value, element, param) {
                param = typeof param === "string" ? param.replace(/,/g, '|') : "pdf|doc";
                return this.optional(element) || value.match(new RegExp(".(" + param + ")$", "i"));
            }, jQuery.format("Please enter a value with a valid extension."));


        });

        function showHideGadgetFields(event) {
            if (event.target.checked) {
                $("#toggleGadgetFields").show();
            } else {
                $("#toggleGadgetFields").hide();
            }
        }
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>

@endsection
