@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All series list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin_dashboard')}}">Dashbaord</a></li>
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.InvestMentseriesList')}}">Investments Deposit List</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">

                <div class="card-header">
                    <h4 class="card-title"><b>Investments Deposit Name : </b> {{$name}}</h4>
                </div>

                <div class="card-header">
                  <!-- <h4>Investments Series Leaderboard</h4> -->
                  <!-- <a href="{{route('Series.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a>                         -->
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>User Name</th>
                                <th>Email</th>
                                <th>Mobile</th>
                                <th>Team Name</th>
                                <th>Total Investment</th>
                                <th>Amount</th>
                                <th>Rank</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    var series_id = "{{$series_id}}";
    $('#dataList').DataTable({
      // order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.depositInvestmentLeaderboard',$series_id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}","series_id":series_id}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'username', name: 'username'},
            {data: 'email', name: 'email'},
            {data: 'mobile', name: 'mobile'},
            {data: 'team', name: 'team'},
            {data: 'points', name: 'points'},
            {data: 'amount', name: 'amount'},
            {data: 'rank', name: 'rank'}
        ]
    });
});
</script>
@endsection
