@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--**********************************
    Content body start
***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Add Levels</h4>
                <span class="ml-1">Layout</span>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                 <li class="breadcrumb-item active"><a href="{{route($modelName.'.view_all')}}">Levels</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Add</a></li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Add Form</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.add')}}" method="POST" enctype="multipart/form-data" id="levelAddForm">
                        @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label>Level</label>
                                    <input type="number" class="form-control" name="level" id="level">
                                    <div class="error-message help-inline">
                                      <?php echo $errors->first('level'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Cash</label>
                                    <input class="form-control"  autocomplete="off"  id="cash" name="cash" aria-describedby="inputSuccess2Status2" type="text" required>

                                </div>
                                <div class="form-group col-md-6">
                                    <label>Contest</label>
                                   <input class="form-control "  autocomplete="off" name="contest" id="contest" aria-describedby="inputSuccess2Status2" type="text" required>
                                   <!-- <div class="error-message help-inline">

                                    </div> -->
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Type</label>
                                    <select class="form-control" id ="type" name="type" required>
                                        <option value="">Select Type</option>
                                        <option value="or">Or</option>
                                        <option value="and">And</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-6">
                                    <label>Reward Cash</label>
                                    <input class="form-control"  autocomplete="off"  name="reward_cash" type="number" min="0" >
                                </div>

                                <div class="form-group col-md-6">
                                    <label>Reward Cash Type</label>
                                    <select class="form-control" name="reward_cash_type">
                                      <option value="">Select Reward Cash Type</option>
                                      <option value="bonus">Bonus</option>
                                      <option value="winning">Winning</option>
                                      <!-- <option value="unutilize">Unutilize</option> -->
                                    </select>
                                </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $('#start_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
        $('#end_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });

        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });

    });
</script>

<!--**********************************
    Content body end
***********************************-->
@endsection
