@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<!--**********************************
    Content body start
***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Edit Series</h4>
                <span class="ml-1">Layout</span>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.view_all')}}">All Levels</a></li>
                <li class="breadcrumb-item">Edit</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Edit Level</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.update', base64_encode(serialize($level->id)))}}" id="levelsEditForm" method="post" enctype="multipart/form-data">
                        @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Level</label>
                                    <input type="text" class="form-control in_text" name="level" id="name" value="{{$level->level}}">
                                    <div class="error-message help-inline">
                                      <?php echo $errors->first('level'); ?>
                                    </div>
                                </div>


                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Cash</label>
                                    <input class="form-control in_text" id="cash"name="cash" aria-describedby="inputSuccess2Status2" type="text" value="{{$level->cash}}">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('cash'); ?>
                                    </div>

                            </div>

                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Contest</label>
                                   <input class="form-control in_text" id="contest" autocomplete="off" name="contest" aria-describedby="inputSuccess2Status2" type="text" value="{{$level->contest}}">
                                   <div class="error-message help-inline">
                                      <?php echo $errors->first('contest'); ?>
                                    </div>
                                </div>


                            <div class="form-group col-md-6">
                                <label class="lbl_frm py-2">Type</label>
                                <select class="form-control in_text" id ="type" name="type" required>
                                    <option class="form-control in_text" disabled value="">Select Type</option>
                                     <option value="or" <?php if($level->type == 'or'){ echo 'selected';} ?> >Or</option>
                                     <option  value="and" <?php if($level->type == 'and'){ echo 'selected';} ?> > And</option>

                                </select>
                            </div>
                            <div class="form-group col-md-6">
                            <label>Reward Cash</label>
                            <input class="form-control"  autocomplete="off"  name="reward_cash" type="number" min="0" value="{{$level->reward_cash}}">
                        </div>

                        <div class="form-group col-md-6">
                            <label>Reward Cash Type</label>
                            <select class="form-control" name="reward_cash_type">
                              <option value="">Select Reward Cash Type</option>
                              <option <?php if($level->reward_cash_type == 'bonus'){ echo 'selected';} ?> value="bonus">Bonus</option>
                              <option <?php if($level->reward_cash_type == 'winning'){ echo 'selected';} ?> value="winning">Winning</option>
                              <!-- <option <?php if($level->reward_cash_type == 'unutilize'){ echo 'selected';} ?> value="unutilize">Unutilize</option> -->
                            </select>
                        </div>
                          </div>

                            <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function(){
        $('#start_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
        $('#end_date').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
    });
</script>

<!--**********************************
    Content body end
***********************************-->
@endsection
