@extends('admin.elements.common.login_layout')
@section('title', 'Login')
@section('content')
    <?php
        $email_cookie = Cookie::get('email') ?? "";
        $remember_cookie = Cookie::get('remember') ?? "";
    ?>
    <!-- BEGIN LOGIN FORM -->
            <form action="{{route('Admin.login')}}" method="POST" role="form" id="adminLoginForm">
            	@csrf
                <div class="form-group">
                    <label><strong>Username</strong></label>
                     <input type="email" name="email" placeholder="Email" class="form-control form-control-solid placeholder-no-fix" value="{{$email_cookie}}"  />
                </div>
                <div class="form-group">
                    <label><strong>Password</strong></label>
                    <input type="password" name="password" class="form-control form-control-solid placeholder-no-fix" placeholder="Password" />
                </div>
                <div class="form-row d-flex justify-content-between mt-4 mb-2">
                    <div class="form-group">
                        <div class="form-check remember_check">
                             <input type="checkbox" name="remember" id="rememberme" class="filled-in chk-col-pink" {{ old('remember', $remember_cookie) === 'on' ? 'checked' : '' }} > Remember me
                        </div>
                    </div>
                    <div class="form-group">
                    	<a href="{{route('admin.forgotPassword')}}" id="forget-password">Forgot Password?</a>
                    </div>
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary btn-block">Login</button>
                </div>
            </form>
@endsection
