@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <div class="welcome-text">
                    <h4><?php echo $findmatchdetails->title; ?></h4>
                    <!-- <span class="ml-1">Layout</span> -->
                </div>
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.matchmapping') }}">All Matches</a>
                    </li>
                    <li class="breadcrumb-item">Edit Match</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Match Detail</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.editmatch', ['id' => $findmatchdetails->matchkey, 'sport_type' => $sports_key]) }}"
                                id="EditUserForm" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Match Name</label>
                                        <input id="name" type="text" placeholder="enter name here" name="name"
                                            class="form-control in_text" value="{{ ucwords($findmatchdetails->name) }}"
                                            autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    @if ($findmatchdetails->sport_type == 1)
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Match Format</label>
                                            <select class="form-control in_text" id="format" name="format"
                                                autocomplete="off" required>
                                                <option value=""> Select match Format </option>
                                                @if (isset($matchformat) && !empty($matchformat))
                                                    @foreach ($matchformat as $matchf => $matchvalue)
                                                        <option value="<?php echo $matchf; ?>" <?php if ($findmatchdetails->format == $matchf) {
                                                            echo 'selected';
                                                        } ?>>
                                                            {{ ucwords($matchvalue) }} </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('format'); ?>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team1</label>
                                        <input class="form-control in_text" id="first-name" type="text"
                                            value="{{ ucwords($findmatchdetails->team1name) }}" readonly=""
                                            disabled="">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team2</label>
                                        <input class="form-control in_text" id="first-name" type="text"
                                            value="{{ ucwords($findmatchdetails->team2name) }}" readonly=""
                                            disabled="">
                                    </div>


                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Match Start Date</label>
                                        <input class="form-control in_text" id="start_date" name="start_date" type="text"
                                            value="{{ $findmatchdetails->start_date }}">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Series</label>
                                        <select class="form-control in_text" id="series" name="series"
                                            autocomplete="off" required>
                                            <option value=""> Select match Series </option>
                                            @if (isset($findmatchseries) && !empty($findmatchseries))
                                                @foreach ($findmatchseries as $matcseries)
                                                    <option value="<?php echo $matcseries->id; ?>" <?php if ($matcseries->id == $findmatchdetails->series) {
                                                        echo 'selected';
                                                    } ?>>
                                                        {{ $matcseries->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('series'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Announcement Text</label>
                                        <input type="text" class="form-control in_text" id="announcement"
                                            name="announcement" autocomplete="off" value="<?php echo $findmatchdetails->announcement; ?>">
                                        <!-- <div class="error-message help-inline">
                                          <?php echo $errors->first('announcement'); ?>
                                        </div> -->
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Sort</label>
                                        <input type="number" class="form-control in_text" id="sort" name="sort"
                                            autocomplete="off" value="<?php echo $findmatchdetails->sort; ?>">
                                        <!-- <div class="error-message help-inline">
                                          <?php echo $errors->first('sort'); ?>
                                        </div> -->
                                    </div>

                                    <!-- <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Allow Second Inning</label>
                                         <input type="number" class="form-control in_text" id="second_inning_allow" name="second_inning_allow"  value="<?php echo $findmatchdetails->second_inning_allow; ?>"> -->

                                    <!-- <div class="error-message help-inline">
                                        </div>
                                    </div> -->
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Mega Contest Prize</label>
                                        <input type="int" class="form-control in_text" id="mega_contest_prize"
                                            name="mega_contest_prize" value="<?php echo $findmatchdetails->mega_contest_prize; ?>">
                                        <!-- <div class="error-message help-inline">
                                          <?php echo $errors->first('mega_contest_prize'); ?>
                                        </div> -->
                                    </div>
                                    @if ($findmatchdetails->status == 'started')
                                        <div class="form-group col-md-6">
                                            <label class="lbl_frm py-2">Edit match status</label>
                                            <select class="form-control in_text" name="status">
                                                <option>select all</option>
                                                <option @if ($findmatchdetails->status == 'started') selected @endif value="started">
                                                    Started</option>
                                                <option @if ($findmatchdetails->status == 'notstarted') selected @endif
                                                    value="notstarted">Not started</option>
                                                <!-- <option value="canceled">Canceled</option> -->
                                            </select>
                                        </div>
                                    @endif
                                    <!-- <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team 1 Color Code</label>
                                        <input type="color" class="" style="margin-top: 8px;" id="team1_color_code" name="team1_color_code" value="<?php echo $findmatchdetails->team1_color_code; ?>">
                                         <!-- <div class="error-message help-inline">
                                          <?php //echo $errors->first('announcement');
                                          ?>
                                        </div> -->
                                    <!-- </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team 2 Color Code</label>
                                        <input type="color" class="" style="margin-top: 8px;" id="team2_color_code" name="team2_color_code" value="<?php echo $findmatchdetails->team2_color_code; ?>">
                                         <!-- <div class="error-message help-inline">
                                          <?php //echo $errors->first('team2_color_code');
                                          ?>
                                        </div> -->
                                    <!-- </div> -->

                                    @if ($findmatchdetails->sport_type != 7)
                                        <div class="form-group col-md-3 py-2">

                                            <!-- <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input" onchange="showHideSecondInningDate(event)" id="second_inning_allow" name="second_inning_allow" value="1"  <?php if ($findmatchdetails->second_inning_allow == 1) {
                                              echo 'checked';
                                          } ?>>
                                          <label class="form-check-label" for="second_inning_allow">Allow Second Inning</label>
                                      </div> -->
                                        </div>
                                    @endif

                                    <div class="form-group col-md-3 py-2">

                                        <!-- <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" onchange="is_unlimited_credits(event)" id="is_unlimited_credits" name="is_unlimited_credits" value="1" <?php if ($findmatchdetails->is_unlimited_credits == 1) {
                                                echo 'checked';
                                            } ?>>
                                            <label class="form-check-label">Is Unlimited Credits</label>
                                        </div> -->


                                    </div>
                                    <div class="form-group col-md-3 py-2">

                                        {{-- <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input"
                                                onchange="is_unlimited_credits(event)" id="is_unlimited_credits"
                                                name="is_allow_notification" value="1" <?php if ($findmatchdetails->is_allow_notification == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label">Is Allow Notification</label>
                                        </div> --}}


                                    </div>
                                    <?php /*  @if($findmatchdetails->status =='started')*/?>
                                    <!-- <div class="form-group col-md-3 py-2">
                                      <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input"  value="1"  <?php if ($findmatchdetails->flexible_breakup_set == 1) {
                                              echo 'checked';
                                          } ?>>
                                          <label class="form-check-label" for="second_inning_allow">Set Flexible Contest</label>
                                      </div>
                                    </div> -->
                                    <?php /*  @endif */?>

                                    <div class="form-group col-md-6 py-2">

                                        <div class="form-check mb-2">
                                            <input type="checkbox" class="form-check-input" id="is_bot_enable"
                                                name="is_bot_enable" value="1" <?php if ($findmatchdetails->is_bot_enable == 1) {
                                                    echo 'checked';
                                                } ?>>
                                            <label class="form-check-label" for="is_bot_enable">Enable Bot System</label>
                                        </div>
                                    </div>
                                    <!-- <div class="form-group col-md-6 py-2"> -->

                                        <!-- <div class="form-check mb-2">
                                          <input type="checkbox" class="form-check-input" onchange="showHideGiveawayText(event)"  id="is_giveaway" name="is_giveaway" value="1"  <?php if ($findmatchdetails->is_giveaway == 1) {
                                              echo 'checked';
                                          } ?>>
                                          <label class="form-check-label"  for="is_giveaway_enable">Is Giveaway</label>
                                      </div> -->
                                    <!-- </div> -->
                                    <div class="form-group col-md-6 toggleGiveaway" style="display:none">
                                        <label class="lbl_frm py-2">Free Giveaway Text Heading</label>
                                        <input class="form-control in_text" name="giveaway_heading" type="text"
                                            value="{{ @$findmatchdetails->giveaway_heading }}">
                                    </div>
                                    <div class="form-group col-md-6 toggleGiveaway" style="display:none">
                                        <label class="lbl_frm py-2">Free Giveaway Text sub Heading</label>
                                        <input class="form-control in_text" name="giveaway_subheading" type="text"
                                            value="{{ @$findmatchdetails->giveaway_subheading }}">
                                    </div>

                                    <!-- <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Image</label>
                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg"
                                            name="banner_image" class=" imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>

                                        <?php if($findmatchdetails->banner_image!=""){ ?>
                                        <img src="<?php echo url()->asset('uploads/banners/' . $findmatchdetails->banner_image); ?>" style="width:100px;height:100px;">
                                        <?php
                                        }else{
                                          ?>
                                        <?php } ?>
                                    </div> -->

                                    <div class="form-group col-md-6" style="display:none" id="toggleSecondStartDate">
                                        <label class="lbl_frm py-2">Second Inning Start Time</label>

                                        <?php
                                        $findSecondInning = DB::table('listmatches')
                                            ->where('matchkey', 'LIKE', '%' . $findmatchdetails->matchkey . '%')
                                            ->where('second_inning', 1)
                                            ->first();
                                        if (!empty($findSecondInning)) {
                                            $input_second_inning_start_date = $findSecondInning->start_date;
                                        } else {
                                            $input_second_inning_start_date = $findmatchdetails->start_date;
                                        }
                                        ?>
                                        <input class="form-control in_text" id="second_inning_start_date"
                                            name="second_inning_start_date" type="text"
                                            value="{{ $input_second_inning_start_date }}">
                                    </div>

                                    <?php
                                      $is_enabled_series_slide = DB::table('series')
                                          ->where('id', $findmatchdetails->series)
                                          ->value('is_series_slide');
                                          if (@$is_enabled_series_slide == 1) {

                                     ?>


                                    <div class="form-group col-md-4 py-2">
                                        <div class="form-check mb-2">
                                            <label class=" ">Team1 color</label>
                                            <input type="color" id="head" name="team1_color_code"
                                                value="{{ isset($findmatchdetails->team1_color_code) ? $findmatchdetails->team1_color_code : '' }}">

                                        </div>
                                    </div>
                                    <div class="form-group col-md-4 py-2">
                                        <div class="form-check mb-2">
                                            <label>Team2 color</label>
                                            <input type="color" id="head" name="team2_color_code"
                                                value="{{ isset($findmatchdetails->team2_color_code) ? $findmatchdetails->team2_color_code : '' }}">
                                            <div class="error-message help-inline">

                                            </div>
                                        </div>



                                    </div>
                                    <div class="form-group col-md-6">
                                        <!-- <label class="lbl_frm py-2">Image</label>
                                           <input class="form-control in_text" name="banner_image" id="banner_image" type="file"> -->
                                        <label class="lbl_frm py-2">Team1 Player Image</label>
                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg"
                                            name="team1_player_image" class=" imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>

                                        <?php if($findmatchdetails->team1_player_image!=""){ ?>
                                        <img src="<?php echo env('CDN_URL') . $findmatchdetails->team1_player_image; ?>" style="width:100px;height:100px;">
                                        <?php
                                        }else{
                                          ?>

                                        <?php } ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <!-- <label class="lbl_frm py-2">Image</label>
                                           <input class="form-control in_text" name="banner_image" id="banner_image" type="file"> -->
                                        <label class="lbl_frm py-2">Team2 Player Image</label>
                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg"
                                            name="team2_player_image" class=" imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>

                                        <?php if($findmatchdetails->team2_player_image!=""){ ?>
                                            <img src="<?php echo env('CDN_URL') . $findmatchdetails->team2_player_image; ?>" style="width:100px;height:100px;">
                                            <?php
                                            }else{
                                              ?>
    
                                            <?php } ?>
                                    </div>
                                  <?php } ?>
                                    <!-- <div class="form-row"> -->

                                    <!-- </div> -->
                                    <div class="py-2">
                                        <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                        <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog"
        aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <div class="row">
                            <div class="col-md-11">
                                <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                    <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        var $modal = $('.imagecrop');
        var image = document.getElementById('image');
        var cropper;
        $("body").on("change", ".imageUpload", function(e) {
            var files = e.target.files;
            var done = function(url) {
                image.src = url;
                $modal.modal('show');
            };
            var reader;
            var file;
            var url;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 0,
                viewMode: 0,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });
        $("body").on("click", "#crop,#crop1", function() {
            canvas = cropper.getCroppedCanvas({
                width: 160,
                height: 160,
            });
            canvas.toBlob(function(blob) {
                url = URL.createObjectURL(blob);
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onloadend = function() {
                    var base64data = reader.result;
                    $('#base64image').val(base64data);
                    // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                    $modal.modal('hide');
                }
            });
        })
    </script>

    <script language="text/Javascript">
        colorPicker.addEventListener("input", updateFirst, false);
        colorPicker.addEventListener("change", watchColorPicker, false);

        function watchColorPicker(event) {
            document.querySelectorAll("p").forEach((p) => {
                p.style.color = event.target.value;
            });
        }
    </script>

    <script type="text/javascript">
        function is_unlimited_credits(event) {
            if (event.target.checked) {
                $("#toggleSecondStartDate1").show();
            } else {
                $("#toggleSecondStartDate1").hide();
            }
        }

        function showHideSecondInningDate(event) {
            if (event.target.checked) {
                $("#toggleSecondStartDate").show();
            } else {
                $("#toggleSecondStartDate").hide();
            }
        }

        function showHideGiveawayText(event) {
            if (event.target.checked) {
                $(".toggleGiveaway").show();
            } else {
                $(".toggleGiveaway").hide();
            }
        }
        $(document).ready(function() {

            var second_inning_allow = '<?= $findmatchdetails->second_inning_allow ?>';
            if (second_inning_allow == '1') {
                $("#toggleSecondStartDate").show();
            }
            var second_inning = '<?= $findmatchdetails->second_inning ?>';
            if (second_inning == '1') {
                $("#secondInningCheckbox").hide();
                $("#toggleSecondStartDate").hide();

            }


            var is_free_giveaway = '<?= $findmatchdetails->is_giveaway ?>';
            if (is_free_giveaway == '1') {
                $("#toggleSecondStartDate").show();
            }
            var free_giveaway = '<?= $findmatchdetails->is_giveaway ?>';
            if (free_giveaway == '1') {
                $("#secondInningCheckbox").hide();
                $("#toggleSecondStartDate").hide();

            }




            $('#second_inning_start_date').datetimepicker();
            $('#start_date').datetimepicker();
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
        $('#EditUserForm')[0].disabled = true;


        $('#EditUserForm input').each(function() {
            if ($(this).attr("disabled")) {
                $(this).css({
                    "background": "#80808096",
                    "cursor": "not-allowed"
                });
            }
        });
    </script>

    <!--**********************************
    Content body end
    ***********************************-->
@endsection
