@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Join Users Details</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                  <a href="javascript:void(0)">Matches</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">All Join Persons</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
     <h4>
     <a href="{{url('admin/matches/join-users-detail-download/'.base64_encode(serialize($challenge_id)))}}"> Download User Detail</a></h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
	                                <th> S No.</th>
	                                <th> Team Name</th>
	                                <th> User Name</th>
	                                <th> Mobile</th>
	                                <th> Email Address </th>
	                                <th>Rank,Points ,Amount</th>
	                                <!-- <th> Amount </th>
	                                <th> Rank </th> -->
                                  <th>Joined Time</th>
	                                <th>Action</th>
	                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                  <th> S No.</th>
	                                <th> Team Name</th>
	                                <th> User Name</th>
	                                <th> Mobile</th>
	                                <th> Email Address </th>
	                                <th>Rank,Point ,Amount</th>
	                                <!-- <th> Amount </th>
	                                <th> Rank </th> -->
                                  <th>Joined Time</th>
	                                <th>Action</th>

	                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="team_modal">
    <div class="modal-dialog modal-lg">
          <div class="modal-content" style="width: 128%;">
              <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">User Created Team</h5>
             <button type="button" class="close  btn btn-danger" data-dismiss="modal" aria-label="Close">X</button>
             </div>
            <div class="modal-body">
              <table id="team_data" class="display" style="width:100%">
                  <thead>
                      <tr>
                      <th>S No.</th>
                      <th>Player Name</th>
                      <th>Role</th>
                      <th>Credit</th>
                      <th>Points</th>

                    </tr>
                  </thead>
                  <tfoot>
                      <tr>
                        <th>S No.</th>
                        <th>Player Name</th>
                        <th>Role</th>
                        <th>Credit</th>
                        <th>Points</th>

                  </tr>
                  </tfoot>
              </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-right" data-dismiss="modal">Close</button>

            </div>
        </div>

    </div>
</div>

<!----Show Data By Ajax----->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      //order: [1, 'DESC'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.join_users_details',base64_encode(serialize($challenge_id)))}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'teamname', name: 'teamname'},
            {data: 'username', name: 'username'},
            {data: 'mobile', name: 'mobile'},
            {data: 'email', name: 'email'},
            {data: 'point', name: 'point'},
            // {data: 'amount', name: 'amount'},
            // {data: 'rank', name: 'rank'},
            {data: 'joined_time', name: 'joined_time'},
            {data: 'action', name: 'action', orderable: false, searchable: false},

        ]
    });
});

$('body').on('click', '#team_details', function (event) {
  event.preventDefault();
  var id = $(this).data('id');

  var matchkey = $(this).data('matchkey');
  $('#team_data').DataTable().clear().destroy();
  $('#team_data').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax":{
        url:"{{route($modelName.'.view_team_model')}}",
        type: "POST",
        data : {"_token": "{{ csrf_token() }}","teamid":id , "matchkey":matchkey}
      },
      "columns": [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'player_name', name: 'player_name'},
          {data: 'role', name: 'role'},
          {data: 'credit', name: 'credit'},
          {data: 'points', name: 'points'},
      ]
  });
});

</script>
@endsection
