@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Matches</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Series</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                          <!-- <a href="{{route('Series.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a> -->
                          <h4>All Matches</h4>
                         <!--   <a href="{{route($modelName.'.import_schedule_data')}}" class="btn btn-primary btn-sm">Import data from API </a> -->
                        </div>
                        <div class="portlet-body table-responsive">
                            <div class="table-responsive">
                                <table id="dataList" class="table table-striped table-bordered table-hover" style="min-width: 845px">
                                    <thead>
                                    <tr>
                                        <th>Sr.no</th>
                                        <th>Match </th>
                                        <th>Refresh </th>
                                        <th>Team 1</th>
                                        <th>Team 2</th>
                                        <th>Status</th>
                                    </tr>
                                    </thead>
                                     @php $no = 1; @endphp
                                     @foreach($live_data as $row)
                                    <tbody>
                                            <tr>
                                                <td>{{ $no++ }}</td>
                                                <td><a href = "{{ route('Matches.viewdata', ['matchkey ' => $row->matchkey] ) }}" class="btn btn-info">{{ $row->name }}</a></td>
                                                <td><a href = "{{ route('Matches.LiveScore', ['match_id' => $row->matchkey, 'comp_id'=>1] ) }}" class="btn btn-success">Refresh live scores</a></td>
                                                <td>{{ $row->team1display }}</td>
                                                <td>{{ $row->team2display}}</td>
                                                <td>{{ $row->launch_status }}</td>
                                            </tr>
                                    </tbody>
                                         @endforeach
                                    <tfoot>
                                        <tr>
                                        <th>S No.</th>
                                        <th>Match</th>
                                        <th>Date & Time</th>
                                        <th>Teams</th>
                                        <th>Action</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
    </div>
</div>

<!-- <script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "pageLength": 100,
        "ajax":{
          url:"{{route($modelName.'.matchmapping')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'start_date', name: 'start_date', orderable: true, searchable: false},
            {data: 'teams', name: 'teams',orderable: false, searchable: false},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script> -->
@endsection
