@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>

  <style type="text/css">
      .list-inline li {
            display: inline-table;
            padding: 5px 14px;
            /*background: #5d78ff;*/
            border-radius: 3px;
        }

        .list-inline li a {
            color: #fff;
        }
  </style>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Matches</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Series</a></li>
            </ol> -->
        </div>
    </div>

    <div class="row">
        <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                          <!-- <a href="{{route('Series.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a> -->
                          <h4>All Matches</h4>


                           @foreach($sportTypes as $sport)
                            {{-- @if($sport->id==1) --}}
                                <a class="btn btn-primary btn-sm" href="{{route($modelName.'.get_matches',$sport->sport_key)}}"> Import {{$sport->sport_name}} data from api </a>
                            {{--  @endif --}}
                            @endforeach

                        </div>
                        <div class="container">
                        <ul class="list-inline">
                            @foreach($sportTypes as $sport)
                              {{--   @if($sport->id==1)--}}
                            <li>
                                <a class="<?php if($sport->id==$sport_type) { echo 'btn btn-success'; } else { echo 'btn btn-primary'; } ?>" href="{{route($modelName.'.matchmapping',$sport->id)}}"> {{$sport->sport_name}}</a>
                            </li>

                            {{--   @endif--}}
                            @endforeach
                        <li>
                          <a class="btn btn-primary" href="{{route('Lineup.update')}}" >Update Lineup</a>
                      </li>
                        </ul>

                        </div>
                        <div class="card-body">

                            <div class="table-responsive">
                                <table id="dataList" class="display" style="min-width: 845px">
                                    <thead>
                                        <tr>
                                        <th>S No.</th>
                                        <th>Match</th>
                                        <th>Sport</th>
                                        <th>Date & Time</th>
                                        <th>Teams</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>

                                    <tfoot>
                                        <tr>
                                        <th>S No.</th>
                                        <th>Match</th>
                                        <th>Sport</th>
                                        <th>Date & Time</th>
                                        <th>Teams</th>
                                        <th>Action</th>
                                    </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      // order: [0, 'desc'],
       "lengthMenu": [ 10, 25, 50, 100, 500,1000 ],
        "processing": true,
        "serverSide": true,
        "pageLength": 100,
        "ajax":{
          url:"{{route($modelName.'.matchmapping', @$sport_type)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'sport_type', name: 'sport_type', orderable: true, searchable: false},
            {data: 'start_date', name: 'start_date', orderable: true, searchable: false},
            {data: 'teams', name: 'teams',orderable: false, searchable: false},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script>
@endsection
