@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Winner users list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="javascript:void(0)">All Matches</a></li>
                <li class="breadcrumb-item">Winners</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
            <div class="card-header"><h4>All Winners</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                      <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th><input type="text" id="filter_username" name="filter_username" value="<?php echo @$_GET['filter_username']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_username')">
                                  Username</th>
                                <th><input type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')">
                                  UserEmail</th>
                                <th><input type="text" id="filter_mobile" name="filter_mobile" value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_mobile')">
                                  UserMobile</th>
                                <th><input type="text" id="filter_teamname" name="filter_teamname" value="<?php echo @$_GET['filter_teamname']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_teamname')">
                                  UserTeamName</th>
                                <th>ChallengeID</th>
                                <th>IsJoin</th>
                                <th>IsRefund</th>
                                <th>Iswin</th>
                                <th>Userid</th>
                                <!-- <th>JoinDate</th> -->
                                <th>RefundDate</th>
                                <th>WinDate</th>
                                <th>TeamRank</th>
                                <th>RefundAmount</th>
                                <th>Winamount</th>
                                <th>TotalPoints</th>
                                <th>ChallengeName</th>
                                <th>EntryFee</th>
                                <th>ConfirmedLeauge</th>
                                <th>MaximumUsers</th>
                                <th>IsPrivate</th>
                                <th>MaxNumberofwinners</th>
                                <th>Joined users</th>
                                <th>IsGrand</th>
                            </tr>
                            </thead>

                            <tfoot>
                              <tr>
                              <th>S No.</th>
                              <th>Username</th>
                              <th>UserEmail</th>
                              <th>UserMobile</th>
                              <th>UserTeamName</th>
                              <th>ChallengeID</th>
                              <th>IsJoin</th>
                              <th>IsRefund</th>
                              <th>Iswin</th>
                              <th>Userid</th>
                              <!-- <th>JoinDate</th> -->
                              <th>RefundDate</th>
                              <th>WinDate</th>
                              <th>TeamRank</th>
                              <th>RefundAmount</th>
                              <th>Winamount</th>
                              <th>TotalPoints</th>
                              <th>ChallengeName</th>
                              <th>EntryFee</th>
                              <th>ConfirmedLeauge</th>
                              <th>MaximumUsers</th>
                              <th>IsPrivate</th>
                              <th>MaxNumberofwinners</th>
                              <th>Joined users</th>
                              <th>IsGrand</th>
                          </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
var fieldname = '';
var filtercolums = {

}

function cancelEvent(){
  event.stopPropagation();
}

var input_filter_teamname = '';
var input_filter_email = '';
var input_filter_mobile = '';
var input_filter_username = '';

function updateURL(event , fieldname){
  var value = event.target.value;

  if(fieldname == 'filter_teamname'){
    input_filter_teamname = value;
  }
  if(fieldname == 'filter_email'){
    input_filter_email = value;
  }

  if(fieldname == 'filter_mobile'){
    input_filter_mobile = value;
  }

  if(fieldname == 'filter_username'){
    input_filter_username = value;
  }

  var url = window.location.href.split('?')[0];
  history.pushState('', '', url+"?filter=1&filter_teamname="+input_filter_teamname+"&filter_email="+input_filter_email+"&filter_mobile="+input_filter_mobile+"&filter_username="+input_filter_username);

}

function filterData(event , fieldname){

  var value = event.target.value;
   updateURL(event,fieldname);

  if(fieldname == 'filter_teamname'){
    filtercolums['filter_teamname'] = value;
  }
  if(fieldname == 'filter_email'){
    filtercolums['filter_email'] = value;
  }
  if(fieldname == 'filter_mobile'){
    filtercolums['filter_mobile'] = value;
  }
  if(fieldname == 'filter_username'){
    filtercolums['filter_username'] = value;
  }
  //URL UPDATE
  $('#dataList').DataTable().clear().destroy(); //clear table data Table

  $('#dataList').DataTable({
    order: [0, 'desc'],
      "processing": true,
      "serverSide": true,
      "ajax":{
        url:"{{route($modelName.'.view_winners',['matchkey'=>$matchkey])}}",
        type: "POST",
        data : {"_token": "{{ csrf_token() }}","filter_columns":filtercolums}

      },
      "columns": [
          {data: 'DT_RowIndex', name: 'DT_RowIndex'},
          {data: 'username', name: 'username'},
          {data: 'email', name: 'email'},
          {data: 'mobile', name: 'mobile'},
          {data: 'team', name: 'team'},
          {data: 'challengeid', name: 'challengeid'},
          {data: 'isjoin', name: 'isjoin'},
          {data: 'isrefund', name: 'isrefund'},
          {data: 'iswin', name: 'iswin'},
          {data: 'userid', name: 'userid'},
          {data: 'refunddate', name: 'refunddate'},
          {data: 'windate', name: 'windate'},
          {data: 'rank', name: 'rank'},
          {data: 'refundamount', name: 'refundamount'},
          {data: 'winamount', name: 'winamount'},
          {data: 'points', name: 'points'},
          {data: 'challengename', name: 'challengename'},
          {data: 'entryfee', name: 'entryfee'},
          {data: 'confirmedleauge', name: 'confirmedleauge'},
          {data: 'maximum_user', name: 'maximum_user'},
          {data: 'is_private', name: 'is_private'},
          {data: 'maximum_number_of_winners', name: 'maximum_number_of_winners'},
          {data: 'joinedusers', name: 'joinedusers'},
          {data: 'isgrand', name: 'isgrand'},
      ]
   });
   document.getElementById(fieldname).focus();
 }

</script>

<script type="text/javascript">

    let filter_teamname = '<?php echo @$_GET['filter_teamname']; ?>';
    let filter_email = '<?php echo @$_GET['filter_email']; ?>';
    let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';
    let filter_username = '<?php echo @$_GET['filter_username']; ?>';
    var filtercolums = {

    }
    // FOR SELECT Filtering
    if(filter_teamname !==''){
      filtercolums['filter_teamname'] = filter_teamname;
    }
    if(filter_email !==''){
      filtercolums['filter_email'] = filter_email;
    }
    if(filter_mobile !==''){
      filtercolums['filter_mobile'] = filter_mobile;
    }
    if(filter_username !==''){
      filtercolums['filter_username'] = filter_username;
    }

      $(document).ready(function() {

        $('#dataList').DataTable().clear().destroy(); //clear table data Table

        $('#dataList').DataTable({
          order: [0, 'desc'],
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.view_winners',['matchkey'=>$matchkey])}}",
              type: "POST",
              data : {"_token": "{{ csrf_token() }}","filter_columns":filtercolums}

            },
            "columns": [
                {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                {data: 'username', name: 'username'},
                {data: 'email', name: 'email'},
                {data: 'mobile', name: 'mobile'},
                {data: 'team', name: 'team'},
                {data: 'challengeid', name: 'challengeid'},
                {data: 'isjoin', name: 'isjoin'},
                {data: 'isrefund', name: 'isrefund'},
                {data: 'iswin', name: 'iswin'},
                {data: 'userid', name: 'userid'},
                {data: 'refunddate', name: 'refunddate'},
                {data: 'windate', name: 'windate'},
                {data: 'rank', name: 'rank'},
                {data: 'refundamount', name: 'refundamount'},
                {data: 'winamount', name: 'winamount'},
                {data: 'points', name: 'points'},
                {data: 'challengename', name: 'challengename'},
                {data: 'entryfee', name: 'entryfee'},
                {data: 'confirmedleauge', name: 'confirmedleauge'},
                {data: 'maximum_user', name: 'maximum_user'},
                {data: 'is_private', name: 'is_private'},
                {data: 'maximum_number_of_winners', name: 'maximum_number_of_winners'},
                {data: 'joinedusers', name: 'joinedusers'},
                {data: 'isgrand', name: 'isgrand'},
            ]
         });
      });
</script>

@endsection
