@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>All Winner user list</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                  <a href="javascript:void(0)">Matches</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">All  Winner user list</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
	                                <th>S No.</th>
	                                <th>Challance id</th>
	                                <th>User Name</th>
	                                <th>Email</th>
	                                <th>Mobile</th>
	                                <th>Win Amount</th>
	                                <th>Rank</th>
	                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                  <th>S No.</th>
                                 <th>Challance id</th>
                                 <th>User Name</th>
                                 <th>Email</th>
                                 <th>Mobile</th>
                                 <th>Win Amount</th>
                                 <th>Rank</th>
	                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!----Show Data By Ajax----->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      //order: [1, 'DESC'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.winner_list',[$matchkey,$sport_key])}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'challengeid', name: 'challengeid'},
            {data: 'username', name: 'username'},
            {data: 'email', name: 'email'},
            {data: 'mobile', name: 'mobile'},
            {data: 'amount', name: 'amount'},
            {data: 'rank', name: 'rank'},
        ]
    });
});
</script>
@endsection
