@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.css"/> -->




    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">

            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view') }}">All Player</a></li>
                    <li class="breadcrumb-item">Add</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add Player</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.add') }}" id="playerAddForm" method="post"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Player Name</label>
                                        <input class="form-control in_text" autocomplete="off"
                                            placeholder="enter player name here" id="player_name" name="player_name"
                                            type="text" value="">
                                        <label class="error-message help-inline">
                                            {{ $errors->first('player_name') }}
                                        </label>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Sport Type</label>
                                        <select class="form-control in_text sport_types" name="sport_type">
                                            <option value="">Select Sport</option>
                                            @foreach ($sport_types as $key => $value)
                                                <option value="{{ $value->id }}">{{ $value->sport_name }}</option>
                                            @endforeach
                                        </select>
                                        <label class="error-message help-inline">
                                            {{ $errors->first('sport_type') }}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Team</label>
                                        <select class="form-control in_text" name="team">
                                            <option value="">Select Country</option>
                                            @foreach ($teams as $key => $value)
                                                <option value="{{ $value->id }}">{{ $value->team }}</option>
                                            @endforeach
                                        </select>
                                        <label class="error-message help-inline">
                                            {{ $errors->first('team') }}
                                        </label>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Select Role</label>
                                        <select class="form-control in_text roles" name="role">
                                            <option value="">Select Role</option>
                                        </select>
                                        <label class="error-message help-inline">
                                            {{ $errors->first('role') }}
                                        </label>
                                    </div>
                                </div>
                                <div class="form-row cricket_div">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Batting style</label>
                                        <input id="batting_style" type="text" name="batting_style"
                                            class="form-control in_text" value=""
                                            placeholder="enter batting style of player here">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Bowling style</label>
                                        <input class="form-control in_text" autocomplete="off"
                                            placeholder="enter bowling style of player here" id="bowling_style"
                                            name="bowling_style" type="text" value="">
                                    </div>
                                </div>

                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Credit</label>
                                        <input id="credit" type="text" name="credit"
                                            class="form-control in_text number-only" value=""
                                            placeholder="enter player credit here">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Image</label>

                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="image"
                                            class="imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>

                                        <label class="error-message help-inline py-2">
                                            <?php echo $errors->first('image'); ?>
                                        </label>
                                    </div>

                                </div>
                                <!-- <div class="form-group col-md-6">
                                <div class="avatar-edit">
                                          <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="imageUpload" class=" imageUpload" />
                                          <input type="hidden" name="base64image" name="base64image" id="base64image">
                                          <label for="imageUpload"></label>
                                      </div>
                                    </div> -->
                                <!-- <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Date of Birth</label>
                                        <input id="dob" type="text" name="dob"  value="" class="form-control datetimepickerget in_text" placeholder="Enter date of birth">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Country</label>
                                        <input class="form-control in_text" autocomplete="off" placeholder="enter country player here" id="country" name="country" type="text" value="">
                                    </div>
                                </div> -->
                                <div class="form-row">


                                </div>

                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>







    <div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog"
        data-backdrop="static" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <div class="row">
                            <div class="col-md-11">
                                <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                    <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>



    <!-- <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script> -->
    <!-- <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script> -->
    <!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script> -->
    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.js"></script> -->
    <script>
        var $modal = $('.imagecrop');
        var image = document.getElementById('image');
        var cropper;
        $("body").on("change", ".imageUpload", function(e) {
            var files = e.target.files;
            var done = function(url) {
                image.src = url;
                $modal.modal('show');
            };
            var reader;
            var file;
            var url;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 0,
                viewMode: 0,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });
        $("body").on("click", "#crop,#crop1", function() {
            canvas = cropper.getCroppedCanvas({
                // width: 160,
                // height: 160,
            });
            canvas.toBlob(function(blob) {
                url = URL.createObjectURL(blob);
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onloadend = function() {
                    var base64data = reader.result;
                    $('#base64image').val(base64data);
                    // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                    $modal.modal('hide');
                }
            });
        })
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#dob").datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });


            $(".cricket_div").hide();
            $(".sport_types").on("change", function() {
                var sport_type = $(this).val();
                if (sport_type == 1) {
                    var rolehtml = '<option value="">Select Role</option>';
                    rolehtml += '<option value="batsman">Batsman</option>';
                    rolehtml += '<option value="bowler">Bowler</option>';
                    rolehtml += '<option value="allrounder">All rounder</option>';
                    rolehtml += '<option value="keeper">Wicket Keeper</option>';
                    $(".roles").html(rolehtml);
                    $(".cricket_div").show();
                } else if (sport_type == 2) {
                    var rolehtml = '<option value="">Select Role</option>';
                    rolehtml += '<option value="Goalkeeper">Goalkeeper</option>';
                    rolehtml += '<option value="Defender">Defender</option>';
                    rolehtml += '<option value="Midfielder">Midfielder</option>';
                    rolehtml += '<option value="Forward">Forward</option>';
                    $(".roles").html(rolehtml);
                    $(".cricket_div").hide();
                } else {
                    var rolehtml = '<option value="">Select Role</option>';

                    $(".roles").html(rolehtml);

                    $(".cricket_div").hide();
                }
            });
        });

        onload = function() {
            var ele = document.querySelectorAll('.number-only')[0];
            ele.onkeypress = function(e) {
                if (isNaN(this.value + "" + String.fromCharCode(e.charCode)))
                    return false;
            }
            ele.onpaste = function(e) {
                e.preventDefault();
            }
        }
    </script>
    <!--**********************************
    Content body end
    ***********************************-->
@endsection
