@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #dd4545;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked+.slider {
            background-color: #2E8408;
        }

        input:focus+.slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked+.slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

    <style>
        .toggle {
            --width: 80px;
            --height: calc(var(--width) / 3);

            position: relative;
            display: inline-block;
            width: var(--width);
            height: var(--height);
            box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.3);
            border-radius: var(--height);
            cursor: pointer;
        }

        .toggle input {
            display: none;
        }

        .toggle .slider {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border-radius: var(--height);
            background-color: #d34343;
            transition: all 0.4s ease-in-out;
        }

        .toggle .slider::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: calc(var(--height));
            height: calc(var(--height));
            border-radius: calc(var(--height) / 2);
            background-color: #fff;
            box-shadow: 0px 1px 3px rgba(0, 0, 0, 0.3);
            transition: all 0.4s ease-in-out;
        }

        .toggle input:checked+.slider {
            background-color: green;
        }

        .toggle input:checked+.slider::before {
            transform: translateX(calc(var(--width) - var(--height)));
        }

        .toggle .labels {
            position: absolute;
            top: 5px;
            left: 0px;
            width: 100%;
            height: 100%;
            font-size: 13px;
            font-family: sans-serif;
            transition: all 0.4s ease-in-out;
        }

        .toggle .labels::after {
            /* content: attr(data-off); */
            content: "Deactive";
            position: absolute;
            right: 5px;
            color: #fff;
            opacity: 1;
            font-size: 12px;
            font-family: sans-serif;
            text-align: center;
            text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.4);
            transition: all 0.4s ease-in-out;
        }

        .toggle .labels::before {
            /* content: attr(data-on); */
            content: "Active";
            position: absolute;
            left: 5px;
            color: #ffffff;
            font-size: 12px;
            font-family: sans-serif;
            opacity: 0;
            text-shadow: 1px 1px 2px rgba(255, 255, 255, 0.4);
            transition: all 0.4s ease-in-out;
        }

        .toggle input:checked~.labels::after {
            opacity: 0;
        }

        .toggle input:checked~.labels::before {
            opacity: 1;
        }
    </style>
    <!--**********************************
        Content body start
    ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <div class="welcome-text">
                    <h4>Add Leaderboard</h4>

                </div>
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.addleader') }}">Leaderboard</a></li>
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Add</a></li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add Form</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.addleader') }}" id="leaderboardAddForm" method="post">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Name</label>
                                        <input type="text" class="form-control" name="name" id="name"
                                            placeholder="Name">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    <!-- <div class="form-group col-md-6">
                                        <label>Select Sport Type</label>
                                        <select class="form-control sport_types" name="sport_type">
                                            <option value="">Select Sport</option>
                                            @foreach ($sport_types as $key => $value)
    <option value="{{ $value->id }}">{{ $value->sport_name }}</option>
    @endforeach
                                        </select>
                                        <div class="error-message help-inline">
                                         <?php //echo $errors->first('sport_type');
                                         ?>
                                       </div>
                                    </div> -->
                                    <div class="form-group col-md-6">
                                        <label>Start Date</label>
                                        <input class="form-control datetimepickerget" autocomplete="off"
                                            placeholder="Start date" id="start_date" name="start_date"
                                            aria-describedby="inputSuccess2Status2" type="text">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('start_date'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>End Date</label>
                                        <input class="form-control datetimepickerget" placeholder="End date"
                                            autocomplete="off" name="end_date" id="end_date"
                                            aria-describedby="inputSuccess2Status2" type="text">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('end_date'); ?>
                                        </div>
                                    </div>

                                    <!-- <div class="form-group col-md-5 ml-3 mt-2" >
                            <label>Status</label><br/>
                            <label class="switch">
                              <input class="form-control" type="checkbox" name="status" id="togBtn" value="">
                              <span class="slider round"></span>
                            </label>
                          </div> -->

                                    <div class="form-group col-md-5 ml-3 mt-2">
                                        <label>Leaderboard Status</label><br />
                                        <label class="toggle">
                                            <input class="form-control" type="checkbox" name="status" id="togBtn"
                                                value="">
                                            <span class="slider"></span>
                                            <span class="labels" data-on="ON" data-off="OFF"></span>
                                        </label>
                                    </div>

                                </div>
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#start_date').datetimepicker({
                timepicker: true,
                format: 'Y-m-d'
            });
            $('#end_date').datetimepicker({
                timepicker: true,
                format: 'Y-m-d'
            });
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });


            var inval = "";
            $("#togBtn").on('change', function() {
                if ($(this).is(':checked')) {
                    switchStatusOn = $(this).is(':checked');
                    if (switchStatusOn == true) {
                        inval = document.getElementById("togBtn").value = "1";
                    }
                } else {
                    switchStatusoff = $(this).is(':checked');
                    if (switchStatusoff == false) {
                        inval = document.getElementById("togBtn").value = "0";
                    }

                }
            });
        });
    </script>

    <!--**********************************
        Content body end
    ***********************************-->
@endsection
