@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All series list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Series</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                  <h4>All Promoter Leaderboard list
                  </h4>

                  <a href="{{route('Promotors.addleader')}}" class="btn btn-primary btn-sm"> Add New Promoter Leaderboard</a>


                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Leaderboard Name <br>
                                  <!-- <input type="text" id="filter_leaderboard_name" name="filter_leaderboard_name" value="<?php echo @$_GET['filter_leaderboard_name']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_series_name')"> -->
                                </th>
                                <th>Start date</th>
                                <th>End Date</th>

                                <th>Action</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                  <th>S No.</th>
                                  <th>Leaderboard Name <br>
                                    <!-- <input type="text" id="filter_leaderboard_name" name="filter_leaderboard_name" value="<?php echo @$_GET['filter_leaderboard_name']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_series_name')"> -->
                                  </th>
                                  <th>Start date</th>
                                  <th>End Date</th>

                                  <th>Action</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

            function cancelEvent(){
              event.stopPropagation();
            }

            var filtercolums = {

            };

            var input_filter_series_name = '';
            var input_filter_series_status = '';

            function updateURL(event , fieldname){
              var value = event.target.value;

              if(fieldname == 'filter_series_name'){
                input_filter_series_name = value;
              }
              // if(fieldname == 'filter_series_status'){
              //   input_filter_series_status = value;
              // }

              var url = window.location.href.split('?')[0];
              history.pushState('', '', url+"?filter=1&filter_series_name="+input_filter_series_name+"&filter_series_status="+input_filter_series_status);

            }

            function filterData( event , fieldname){

              var value = event.target.value;

              updateURL(event,fieldname);

              if(fieldname == 'filter_series_name'){
                filtercolums['filter_series_name'] = value;
              }
              if(fieldname == 'filter_series_status'){
                filtercolums['filter_series_status'] = value;
              }

              $('#dataList').DataTable().clear().destroy(); //clear table data Table

              $('#dataList').DataTable({
                order: [0, 'desc'],
                "lengthMenu": [ 10, 25, 50, 100, 500,1000 ],
                  "processing": true,
                  "serverSide": true,
                  "ajax":{
                    url:"{{route($modelName.'.viewleader')}}",
                    type: "POST",
                    data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}

                  },

                  "columns": [
                      {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                      {data: 'name', name: 'name'},
                      {data: 'start_date', name: 'start_date'},
                      {data: 'end_date', name: 'end_date'},

                      {data: 'action', name: 'action', orderable: false, searchable: false},
                  ]
              });

              document.getElementById(fieldname).focus();

            }

            $(document).ready(function() {
              let series_name = '<?php echo @$_GET['filter_series_name']; ?>';
              let series_status = '<?php echo @$_GET['filter_series_status']; ?>';

              if(series_name != ''){
                  filtercolums['filter_series_name'] = series_name;
              }

              if(series_status != ''){
                  filtercolums['filter_series_status'] = series_status;
              }

                $('#dataList').DataTable({
                  order: [0, 'desc'],
                    "processing": true,
                    "serverSide": true,
                    "lengthMenu": [ 10, 25, 50, 100, 500,1000 ],
                    "ajax":{
                      url:"{{route($modelName.'.viewleader')}}",
                      type: "POST",
                      data : {"_token": "{{ csrf_token() }}" ,"filter_columns":filtercolums}
                    },
                    "columns": [
                        {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                        {data: 'name', name: 'name'},
                        {data: 'start_date', name: 'start_date'},
                        {data: 'end_date', name: 'end_date'},

                        {data: 'action', name: 'action', orderable: false, searchable: false},
                    ]
                });
            });
            </script>
            @endsection
