@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Add User Avatars</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.user_avatars') }}">Default Avatars</a>
                    </li>
                    <li class="breadcrumb-item">Add Avatar</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Add User Avatars</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.add_user_avatars') }}" id="AddAvatarsForm" method="post"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-row mb-3">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Uploaded Image</label>
                                        <input type="file" class="form-control in_text" name="image[]">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('image'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Approval status</label>
                                        <select class="form-control in_text" id="status" required="" name="status">
                                            <option value=""> Select status </option>
                                            <option value="1"> Active </option>
                                            <option value="0"> InActive </option>
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('status'); ?>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
    Content body end
    ***********************************-->

    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
@endsection
