@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>Edit User team</h4>
                        <span class="ml-1">Layout</span>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.view') }}">View all User</a>
                    </li>
                    <li class="breadcrumb-item">Edit User team</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit User Team</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.update_team', base64_encode(serialize($id))) }}"
                                id="EditUserForm" method="POST" enctype="multipart/form">

                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Keeper</label>
                                        <select class="form-control select_players_box_keep" id="players[]" name="players[]"
                                            autocomplete="off" multiple="">
                                            <option value=""> Select keeper </option>
                                            @if (isset($Json['keeper']) && !empty($Json['keeper']))
                                                @foreach ($Json['keeper'] as $value)
                                                    <option value="{{ $value->pid }}" <?php if($value->is_selected==1) { ?> selected
                                                        <?php } ?>>
                                                        {{ $value->playername . ' (' . $value->points . ')' }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('players'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Batsman</label>
                                        <select class="form-control select_players_box_keep" id="players[]" name="players[]"
                                            autocomplete="off" multiple="">
                                            <option value=""> Select Batsman </option>
                                            @if (isset($Json['batsman']) && !empty($Json['batsman']))
                                                @foreach ($Json['batsman'] as $value)
                                                    <option value="{{ $value->pid }}" <?php if($value->is_selected==1) { ?> selected
                                                        <?php } ?>>
                                                        {{ $value->playername . ' (' . $value->points . ')' }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('players'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Bowlers</label>
                                        <select class="form-control select_players_box_keep" id="players[]" name="players[]"
                                            autocomplete="off" multiple="">
                                            <option value=""> Select Bowlers </option>
                                            @if (isset($Json['bowler']) && !empty($Json['bowler']))
                                                @foreach ($Json['bowler'] as $value)
                                                    <option value="{{ $value->pid }}" <?php if($value->is_selected==1) { ?> selected
                                                        <?php } ?>>
                                                        {{ $value->playername . ' (' . $value->points . ')' }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('players'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>All Rounder</label>
                                        <div class="form-group col-md-6">
                                            <select class="form-control select_players_box_keep" id="players[]"
                                                name="players[]" autocomplete="off" multiple="">
                                                <option value=""> Select Rounder </option>
                                                @if (isset($Json['allrounder']) && !empty($Json['allrounder']))
                                                    @foreach ($Json['allrounder'] as $value)
                                                        <option value="{{ $value->pid }}" <?php if($value->is_selected==1) { ?> selected
                                                            <?php } ?>>
                                                            {{ $value->playername . ' (' . $value->points . ')' }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <div class="error-message help-inline">
                                                <?php echo $errors->first('players'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Captain</label>
                                        <select class="form-control select_captain_box" id="captain" name="captain"
                                            autocomplete="off" multiple="">
                                            <option value=""> Select Captain </option>
                                            @if (isset($playerdetails) && !empty($playerdetails))
                                                @foreach ($playerdetails as $value)
                                                    <option value="{{ $value->pid }}" <?php if($value->is_captain==1) { ?> selected
                                                        <?php } ?>>
                                                        {{ $value->playername }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('captain'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Vice Captain </label>
                                        <select class="form-control select_captain_box" id="vicecaptain" name="vicecaptain"
                                            autocomplete="off" multiple="">
                                            <option value=""> Select Vice Captain </option>
                                            @if (isset($playerdetails) && !empty($playerdetails))
                                                @foreach ($playerdetails as $value)
                                                    <option value="{{ $value->pid }}" <?php if($value->is_vc==1) { ?> selected
                                                        <?php } ?>>
                                                        {{ $value->playername }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('vicecaptain'); ?>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                <button class="btn btn-gray" id="cancel_btn" type="button">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
        ***********************************-->
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>

@endsection
