@extends('admin.layouts.default')
@section('content')

<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Edit User</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                    <a href="{{route($modelName.'.view')}}">View all User</a></li>
                <li class="breadcrumb-item">Edit User</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Transfer Amount</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form action="{{route($modelName.'.edit_users_amount',base64_encode(serialize($user->id)))}}" id="EditUserAmountForm" method="POST" enctype="multipart/form-data" >
                        @csrf

                            <div class="form-row">
                              <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Team</label>
                                    <b class="lbl_frm py-2">{{$user->team}}</b>
                              </div>
                                <!-- <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Email</label>
                                    <b class="lbl_frm py-2">{{$user->email}}</b>
                                </div> -->

                            </div>
                            <div class="form-row">
                              <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Unutilized</label>
                                  <b class="lbl_frm py-2">{{$user->balance}}</b>
                              </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Winnings</label>
                                    <b class="lbl_frm py-2">{{$user->winning}}</b>
                                </div>

                            </div>
                            <div class="form-row">
                              <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Cash Bonus</label>
                                  <b class="lbl_frm py-2">{{$user->bonus}}</b>
                              </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">GST /TDS Bonus</label>
                                    <b class="lbl_frm py-2">{{$user->gst_bonus}}</b>
                                </div>

                            </div>
                            <div class="form-row">
                              <!-- <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Affiliation Amount</label>
                                    <b class="lbl_frm py-2">{{$user->affiliation_commission}}</b>
                              </div> -->
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Total Balance</label>
                                    <!-- <b class="lbl_frm py-2">{{$user->balance + $user->winning + $user->bonus+$user->gst_bonus+$user->affiliation_commission}}</b> -->
                                      <b class="lbl_frm py-2">{{$user->balance + $user->winning + $user->bonus+$user->gst_bonus}}</b>
                                </div>

                            </div>
                            <div class="form-row">
                              <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Transfer From</label>

                                  <!-- <input class="form-control in_text" autocomplete="off" placeholder="enter team name here" id="team" name="team" type="text" value="{{$user->bonus}}"> -->
                                  <select  class="form-control col-md-6" name="transfer_from" required>
                                    <option value="">Select type</option>
                                    <option value="0">Unutilized</option>
                                    <option value="1">Winning</option>
                                    <option value="2">Cash Bonus</option>
                                    <option value="3">GST/TDS Bonus</option>
                                    <!-- <option value="4">Affiliation Amount</option> -->
                                  </select>
                                   <div class="error-message help-inline">
                                    <?php echo $errors->first('transfer_from'); ?>
                                  </div>
                              </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Transfer To</label>
                                    <select  class="form-control col-md-6" name="transfer_to" required>
                                      <option value="">Select type</option>
                                      <option value="0">Unutilized</option>
                                      <option value="1">Winning</option>
                                      <option value="2">Cash Bonus</option>
                                      <option value="3">GST/TDS  Bonus</option>
                                      <!-- <option value="4">Affiliation Amount</option> -->
                                    </select>
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('transfer_to'); ?>
                                    </div>
                                </div>

                            </div>
                            <div class="form-row">
                              <div class="form-group col-md-6">
                                  <label class="lbl_frm py-2">Amount</label>
                                  <input class="form-control col-md-6" autocomplete="off" placeholder="Enter Amount" name="amount" type="text" >
                                   <div class="error-message help-inline">
                                    <?php echo $errors->first('amount'); ?>
                                  </div>
                              </div>


                            </div>



                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
    $('#dob').datetimepicker({
        timepicker: false,
        format:'Y-m-d'
    });
    $(document).on("click","#cancel_btn", function(){
        let href = $(".breadcrumb-item.active a").attr("href");
        window.location = href;
    });
});
</script>
<!--**********************************
Content body end
***********************************-->
@endsection
