@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <?php
    $indianStates = ['AR' => 'Arunachal Pradesh', 'AR' => 'Arunachal Pradesh', 'AS' => 'Assam', 'BR' => 'Bihar', 'CT' => 'Chhattisgarh', 'GA' => 'Goa', 'GJ' => 'Gujarat', 'HR' => 'Haryana', 'HP' => 'Himachal Pradesh', 'JK' => 'Jammu and Kashmir', 'JH' => 'Jharkhand', 'KA' => 'Karnataka', 'KL' => 'Kerala', 'MP' => 'Madhya Pradesh', 'MH' => 'Maharashtra', 'MN' => 'Manipur', 'ML' => 'Meghalaya', 'MZ' => 'Mizoram', 'NL' => 'Nagaland', 'OR' => 'Odisha', 'PB' => 'Punjab', 'RJ' => 'Rajasthan', 'SK' => 'Sikkim', 'TN' => 'Tamil Nadu', 'TG' => 'Telangana', 'TR' => 'Tripura', 'UP' => 'Uttar Pradesh', 'UT' => 'Uttarakhand', 'WB' => 'West Bengal', 'AN' => 'Andaman and Nicobar Islands', 'CH' => 'Chandigarh', 'DN' => 'Dadra and Nagar Haveli', 'DD' => 'Daman and Diu', 'LD' => 'Lakshadweep', 'DL' => 'National Capital Territory of Delhi', 'PY' => 'Puducherry'];
    
    ?>
    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>Edit bank details</h4>
                        <span class="ml-1">Layout</span>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.verify_bank_account') }}">Bank Account Verification Requests</a>
                    </li>
                    <li class="breadcrumb-item">Edit Details</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Bank Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form
                                action="{{ route($modelName . '.edit_bank_details', base64_encode(serialize($editbankdetails->id))) }}"
                                id="UpdateBankForm" method="post" enctype="multipart/form-data">
                                @csrf <div class="form-row">
                                    @csrf
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Account number</label>
                                        <input type="text" id="accno" name="accno" class="form-control in_text"
                                            value="{{ $editbankdetails->accno }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('accno'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">IFSC Code</label>
                                        <input type="text" id="ifsc" name="ifsc" class="form-control in_text"
                                            value="{{ $editbankdetails->ifsc }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('ifsc'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Bank Name</label>
                                        <input type="text" class="form-control in_text" name="bankname" id="bankname"
                                            value="{{ $editbankdetails->bankname }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('bankname'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Bank Branch</label>
                                        <input type="text" id="bankbranch" name="bankbranch" class="form-control in_text"
                                            value="{{ $editbankdetails->bankbranch }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('bankbranch'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">State</label>
                                        <select class="form-control in_text" name="state" id="state">
                                            <option value="">Select State</option>
                                            @foreach ($indianStates as $state)
                                                <option value="{{ $state }}">{{ $state }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Uploaded Image</label>
                                        <a href="<?php echo $editbankdetails->image; ?>" target="_blank">
                                            @php $ext = pathinfo($editbankdetails->image, PATHINFO_EXTENSION) @endphp
                                            @if ($ext == 'pdf')
                                                <i class="fa fa-file-pdf-o" style="color:red;font-size:30px;"></i>
                                            @else
                                                <img src="{{ $editbankdetails->image }}" style="max-width:100px;">
                                            @endif
                                        </a>

                                        <input type="file" name="image" class="m-2" style="margin-top:20px;">
                                        <input type="hidden" name="oldimage"
                                            value="{{ BANK_IMAGE_ROOT_PATH . $editbankdetails->image }}">
                                        <!--  <div class="error-message help-inline">
                                              <?php echo $errors->first('image'); ?>
                                            </div> -->

                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Approval status</label>
                                        <select class="form-control in_text" name="status" id="status">
                                            <option value=""> Select status </option>
                                            <option value="1" <?php if ($editbankdetails->status == 1) {
                                                echo 'selected';
                                            } ?>> Approved </option>
                                            <option value="2" <?php if ($editbankdetails->status == 2) {
                                                echo 'selected';
                                            } ?>> Reject </option>
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('status'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Description</label>
                                        <textarea type="text" rows="1" class="form-control in_text py-2 my-1" required="" name="comment"
                                            placeholder="Comment" id="commentpan">{{ $editbankdetails->comment }}</textarea>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('comment'); ?>
                                        </div>
                                    </div>
                                </div>
                                <input name="id" type="hidden"
                                    value="{{ isset($editbankdetails->id) && !empty($editbankdetails->id) ? $editbankdetails->id : '' }}">
                        </div>
                        <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2" onclick="pandetailsupdate()">Update
                                Details</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
        ***********************************-->
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
@endsection
<script>
    function pandetailsupdate() {
        var accno = $("#accno").val();
        var ifsc = $("#ifsc").val();
        var bankbranch = $("#bankbranch").val();
        var bankname = $("#bankname").val();
        var state = $("#state").val();
        if (accno != "" && ifsc != "" && bankbranch != "" && bankname != "" && state != "") {
            var getstatus = $("#panstatus").val();
            if (getstatus != "") {
                if (getstatus == 2) {
                    var getcomment = $("#commentpan").val();
                    if (getcomment == "") {
                        alert('Please Enter comment first.');
                        return false;
                    }
                }
                document.getElementById("UpdateBankForm").submit();
            }
        } else {
            alert('Please fill out all the fields');
        }
    } //End Function
</script>
