@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Edit Pan card details</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.verify_pan') }}">PAN Card Verification Requests</a>
                    </li>
                    <li class="breadcrumb-item">Edit Details</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit PAN Card Details</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="UpdatePanForm"
                                action="{{ route($modelName . '.edit_pan_details', base64_encode(serialize($editpandetails->id))) }}"
                                method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Name on PAN Cad</label>
                                        <input type="text" id="pancardname" name="pan_name" class="form-control in_text"
                                            value="{{ $editpandetails->pan_name }}" placeholder="enter PAN Card name here">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('pan_name'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">PAN Card number</label>
                                        <input type="text" id="pancardnumber" name="pan_number"
                                            class="form-control in_text" value="{{ $editpandetails->pan_number }}"
                                            placeholder="enter PAN Card number here" style="text-transform:uppercase;">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('pan_number'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">PAN Card DOB</label>
                                        <input class="form-control in_text" id="pancarddob" name="pan_dob" type="text"
                                            value="{{ $editpandetails->pan_dob }}">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('pan_dob'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Uploaded Image</label>
                                        <a href="<?php echo $editpandetails->image; ?>" target="_blank">
                                            @php
                                                $ext = pathinfo($editpandetails->image, PATHINFO_EXTENSION);
                                            @endphp
                                            @if (isset($ext) && $ext == 'pdf')
                                                <i class="fa fa-file-pdf-o" class="m-2"
                                                    style="color:red;font-size:30px;"></i>
                                            @else
                                                <img src="{{ $editpandetails->image }}" class="m-2"
                                                    style="max-width:100px;">
                                            @endif
                                        </a>
                                        <input type="file" name="image" style="margin-top:10px;">
                                        <input type="hidden" name="oldimage"
                                            value="{{ PAN_IMAGE_ROOT_PATH . $editpandetails->image }}">


                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Approval status</label>
                                        <select class="form-control in_text" name="status" id="status">
                                            <option value=""> Select status </option>
                                            <option value="1" <?php if ($editpandetails->status == 1) {
                                                echo 'selected';
                                            } ?>> Approved </option>
                                            <option value="2" <?php if ($editpandetails->status == 2) {
                                                echo 'selected';
                                            } ?>> Reject </option>
                                        </select>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('status'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Description</label>
                                        <textarea type="text" rows="1" class="form-control in_text py-2 my-1" required="" name="comment"
                                            placeholder="Comment" id="commentpan">{{ $editpandetails->comment }}</textarea>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('comment'); ?>
                                        </div>
                                    </div>
                                </div>
                                <input name="id" type="hidden"
                                    value="{{ isset($editpandetails->id) && !empty($editpandetails->id) ? $editpandetails->id : '' }}">
                        </div>
                        <!--  <input type="submit" class="btn btn-primary" name="submit" id="submit" value="Update PAN Card Details"> -->
                        <div class="py-2">
                            <button type="submit" class="btn btn-primary mr-2" id="submit">Update Details</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#pancarddob').datetimepicker();
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
        $(document).ready(function() {
            $('#pan_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
        });
    </script>
    <!--**********************************
    Content body end
    ***********************************-->
@endsection
