@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Withdraw Detail</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.view')}}">View all User</a></li>
                <li class="breadcrumb-item">Joined Leagues</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"> <h4>Joined Leagues</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Season</th>
                                <th>Title</th>
                                <th>Format</th>
                                <th>Team 1 Name</th>
                                <th>Team 2 Name</th>
                                <th>Final Status</th>
                                <th>Start Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Season</th>
                                <th>Title</th>
                                <th>Format</th>
                                <th>Team 1 Name</th>
                                <th>Team 2 Name</th>
                                <th>Final Status</th>
                                <th>Start Date</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@php
$id = base64_encode(serialize($id));
@endphp
<!--End Edit User Balance Modal -->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      /*order: [1, 'desc'],*/
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.join_leauges',$id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'season', name: 'season'},
            {data: 'title', name: 'title'},
            {data: 'format', name: 'format'},
            {data: 'team1display', name: 'team1display'},
            {data: 'team2display', name: 'team2display'},
            {data: 'final_status', name: 'final_status'},
            {data: 'start_date', name: 'start_date'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script>
@endsection
