@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<style>

</style>
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">

    <div class="row">
        <div class="col-12 mt-4">
          <div class="withdraw_clsBTn mb-4">
            <form id="Downlode_withdrawForm" class="row justify-content-end " action="{{route($modelName.'.manual_withdraw_amount_bank')}}" method="get">
              <div class="col-2">
                <select name="type" id="withdraw_type" class="form-control">
                  <option value="">Select Type</option>
                  <option value="1">Approved</option>
                  <option value="2">Rejected</option>
                  <option value="pending" selected>Pending</option>
                </select>
              </div>
              <div class="col-6">
                <input type="hidden" name="download" value="download">
                <button id="Downlode_withdrawBtn" class="btn btn-info gst-download mt-1"><i class="fa fa-file-excel-o mr-2"></i>Download Withdrawal Report
                </button>
              </div>
            </form>
          </div>
            <div class="card" data-aos="fade-up">
                <form id="withdraw_form" action="{{route($modelName.'.admin_comment_bank_withdraw_multi')}}" method="POST" enctype="multipart/form-data" >
              @csrf
                <div class="card-header">

                <div class="card-body p-0">
                    <div class="basic-form">
                            <div class="form-row">
                                <div class="col-md-10">
                                    <div class="form-group">
                                        <h4>Manual Withdraw Requests</h4>
                                    </div>
                                </div>
                                <div>
                                  <button class="btn btn-info admin-comment1" data-type="approved" style="color:#000;margin-top:3px;">Approve</button>
                                  <button class="btn btn-info admin-comment1" data-type="rejected" style="color:#000;margin-top:3px;">Reject</button>
                                </div>

                                <!-- <div class="col-md-4 d-flex justify-content-between mt-2">
                                    <div class="form-group flex-fill pr-3 mb-0">
                                        <input type="file" required="" name="file" class="pull-left form-control" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel">
                                    </div>
                                    <button type="submit" class="btn btn-primary"><i class="fa fa-file-excel-o mr-2"></i>Upload CSV</button>
                                </div> -->

                                <!-- <div class="form-group col-md-4">
                                    <input type="file" required="" name="file" class="pull-left form-control" accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel">
                                </div>
                                <button type="submit" class="btn btn-primary"><i class="fa fa-file-excel-o"></i>Upload CSV</button>
                            </div> -->
                            </div>
                    </div>

                </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>Select</th>
                                <!-- <th><input type="checkbox" onchange="checkAllCheckboxes(1 , event)"></th> -->
                                <th>S No.</th>
                                <th>User Name</th>
                                <th>Email </th>
                                <th>Mobile</th>
                                <th>PAN</th>
                                <th>Bank Name</th>
                                <th>Bank Branch</th>
                                <th>IFSC Code</th>
                                <th>Account No.</th>
                                <th>Amount</th>
                                <th>Withdraw Request ID </th>
                                <th>Withdraw Status</th>
                                <th>Comment</th>
                                <th>Request Date</th>
                                <th>Approve Date</th>
                                <!-- <th>Action</th> -->
                            </tr>
                            </thead>

                            <!-- <tfoot>
                                <tr>
                                    <th>S No.</th>
                                    <th>Baneficiary</th>
                                    <th>Acc Number</th>
                                    <th>Mobile Number</th>
                                    <th>Withdraw Request ID</th>
                                    <th>Bank IFSC Code</th>
                                    <th>Bank Name</th>
                                    <th>Bank Branch</th>
                                    <th>Approve Manual</th>
                                    <th>Requested Date</th>
                                    <th>Approved Date</th>
                                    <th>ORDER ID</th>
                                    <th>User Name</th>
                                    <th>User Email</th>
                                    <th>Admin Comment</th>
                                    <th>Withdrawl Amount</th>
                                    <th>Cashfree Status</th>
                                    <th>Cashfree Message</th>
                                    <th>Comment</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot> -->
                        </table>

                    </div>

                </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
var withdrawIds = [];
function checkAllCheckboxes(index , event){

  var elementChecked = $("#dataList_"+index+" :input[type='checkbox']").first().prop("checked");
  if(elementChecked){
    var checkboxes = document.querySelectorAll("#dataList_"+index+" input[type='checkbox'][name='withdrawId']");
    for (var j = 0; j < checkboxes.length; j++) {

      if(withdrawIds.findIndex(x => x.challenge_id == checkboxes[j].value) === -1){
        let sort_order_val = document.getElementsByName('sort_order_'+checkboxes[j].value)[0].value;
        withdrawIds.push({"withdrawId":checkboxes[j].value ,"sort_order":sort_order_val});
        checkboxes[j].checked = true;
      }
    }
  }else{
    var checkboxes = document.querySelectorAll("#dataList_"+index+" input[type='checkbox'][name='withdrawId']");
      for (var j = 0; j < checkboxes.length; j++) {
      checkboxes[j].checked = false;
        if(withdrawIds.findIndex(x => x.challenge_id == checkboxes[j].value) !== -1){
            withdrawIds.splice(withdrawIds.findIndex(x => x.challenge_id === checkboxes[j].value) , 1);
        }
      }
  }
  console.log(withdrawIds);
}


function addOrRemoveChallenge(event){
  if(event.target.checked){
    let sort_order_val = document.getElementsByName('sort_order_'+event.target.value)[0].value;
    withdrawIds.push({"withdrawId" : event.target.value , "sort_order":sort_order_val});
  }else{

    if(withdrawIds.findIndex(x => x.challenge_id == event.target.value) !== -1){
      withdrawIds.splice(withdrawIds.findIndex(x => x.challenge_id === event.target.value) , 1);
    }
    // if(withdrawIds.indexOf(event.target.value) !== -1){
    //   withdrawIds.splice(withdrawIds.indexOf(event.target.value) , 1);
    // }
  }
  console.log(withdrawIds);
}

    $(document).on('click','.admin-comment1',function(){
        let checkBoxId = document.getElementById('checkBefore');
        let form_type = $(this).data("type").trim();
        let text_comment = $(this).closest(".text-comment").val();
        if(!checkBoxId.checked) {
            alert("Please select any user");
            return false;
        }
        if(text_comment == ''){
            alert("please fill input field.");
            return false;
        }
        else {
            let input = jQuery('<input type="hidden"  name="type" value="'+form_type+'">');
            $(this).closest('form').append(input);
            $(this).form.submit();
        }
    });



    $('#withdraw_form').on('submit', function(e){
     var form = this;
      $.each(withdrawIds, function(index, rowId){

        // rowIds.push(rowId);
         // Create a hidden element
         $(form).append(
             $('<input>')
                .attr('type', 'hidden')
                .attr('name', 'challenge_ids[]')
                .val(JSON.stringify(rowId))
         );
      });
      // submitleaguesforlaunch
   });

   $(document).on('click', '#Downlode_withdrawBtn', function(event){
        $( "#Downlode_withdrawForm" ).submit();
    });


$(document).ready(function() {
    var withdraw_type = '';
    usersWalletData(withdraw_type);

    $(document).on('change','#withdraw_type', function(){
      let option_value = $(this).val().trim();
      $('#dataList').DataTable().clear().destroy();
      usersWalletData(option_value);
    });

    function usersWalletData(withdraw_type){
      $('#dataList').DataTable({
        // order: [1, 'desc'],
          "processing": true,
          "serverSide": true,
          "ajax":{
            url:"{{route($modelName.'.manual_withdraw_amount_bank')}}",
            type: "POST",
            data : {"_token": "{{ csrf_token() }}", "type":withdraw_type}
          },
          "columns": [
               {data: '#', name: '#'},
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'username', name: 'username'},
              {data: 'email', name: 'email'},
              {data: 'mobile', name: 'mobile'},
              {data: 'pan', name: 'pan'},
              {data: 'bankname', name: 'bankname'},
              {data: 'bankbranch', name: 'bankbranch'},
              {data: 'ifsc', name: 'ifsc'},
              {data: 'accno', name: 'accno'},
              {data: 'withdraw_amount', name: 'withdraw_amount'},
              {data: 'withdraw_request_id', name: 'withdraw_request_id'},
              {data: 'withdraw_status', name: 'withdraw_status'},
              {data: 'comment', name: 'comment'},
              // // {data: 'approve_bank_manual', name: 'approve_bank_manual'},
              {data: 'withdraw_request', name: 'withdraw_request'},
              {data: 'approved_date', name: 'approved_date', class:'approveee pt-4'},
              // {data: 'action', name: 'action',orderable: false, searchable: false},
          ]
        });
    }
});
</script>
@endsection
