@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
  <link rel="stylesheet" href="{{asset('assets/vendor/datatables/css/jquery.dataTables.min.css')}}" />

<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All User Team Detail</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active"><a href="{{route($modelName.'.view')}}">View all User</a></li>
                <li class="breadcrumb-item">User Team</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header"><h4 class="card-title">User Team</h4></div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="example-advance-1" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Team Number</th>
                                    <th>Match Key</th>
                                    <th>Players</th>
                                    <th>Captain</th>
                                    <th>Vice Captain</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @if(isset($Json) && !empty($Json))
                                @foreach($Json as $player)
                                <tr>
                                    <td>{{$player['teamid']}}</td>
                                    <td>{{$player['teamnumber']}}</td>
                                    <td>{{$player['matchkey']}}</td>
                                    <td>
                                        <ul>
                                            <li>
                                                <h4 style="color:blue;"><b>Keeper</b></h4>
                                                <ul>
                                                @if(isset($player['keeper']) && !empty($player['keeper']))
                                                @foreach($player['keeper'] as $value)
                                                <li>{{$value->playername}}</li>
                                                @endforeach
                                                @endif
                                                </ul>
                                            </li>
                                            <li>
                                                <h4 style="color:blue;"><b>Batsman</b></h4>
                                                <ul>
                                                @if(isset($player['batsman']) && !empty($player['batsman']))
                                                @foreach ($player['batsman'] as $value)
                                                    <li>{{$value->playername}}</li>
                                                @endforeach
                                                @endif
                                                </ul>
                                            </li>
                                            <li>
                                                <h4 style="color:blue;"><b>All Rounder</b></h4>
                                                <ul>
                                                @if(isset($player['allrounder']) && !empty($player['allrounder']))
                                                @foreach ($player['allrounder'] as $value)
                                                    <li>{{$value->playername}}</li>
                                                @endforeach
                                                @endif
                                                </ul>
                                            </li>
                                            <li>
                                                <h4 style="color:blue;"><b>Bowler</b></h4>
                                                <ul>
                                                @if(isset($player['bowler']) && !empty($player['bowler']))
                                                @foreach ($player['bowler'] as $value)
                                                    <li>{{$value->playername}}</li>
                                                @endforeach
                                                @endif
                                                </ul>
                                            </li>
                                        </ul>
                                    </td>
                                    <td>{{$player['captain']}}</td>
                                    <td>{{$player['vicecaptain']}}</td>
                                    <td><a class="btn btn-dark" href="{{route($modelName.'.edit_team',base64_encode(serialize($player['teamid'])))}}"><i class="fa fa-pencil mr-2"></i>Edit</a></td>
                                </tr>
                                @endforeach
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>ID</th>
                                    <th>Team Number</th>
                                    <th>Match Key</th>
                                    <th>Players</th>
                                    <th>Captain</th>
                                    <th>Vice Captain</th>
                                    <th>Action</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{asset('assets/vendor/datatables/js/jquery.dataTables.min.js')}}"> </script>
<script src="{{asset('assets/js/plugins-init/datatables-adv-init.js')}}"> </script>
@endsection
