@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>PAN Card Approval Detail</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.verify_pan') }}">PAN Card Verification
                            Requests</a></li>
                    <li class="breadcrumb-item">PAN Detail</li>
                </ol>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4> PAN Card Approval Detail</h4>
                    </div>
                    <div class="card-body col-md-6">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.update_pan_status') }}" id="panUpdateDetailForm"
                                method="POST" enctype="multipart/form-data" @csrf <input name="status" type="hidden"
                                value="" id="panstatus">
                                @csrf
                                <input name="id" type="hidden" value="{{ $pancarddetails->id }}" id="panstatus">

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">User ID</label>
                                    <div class="col-sm-9">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancarddetails->userid) && !empty($pancarddetails->userid) ? $pancarddetails->userid : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Email</label>
                                    <div class="col-sm-9">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancarddetails->email) && !empty($pancarddetails->email) ? $pancarddetails->email : '' }}"
                                            readonly="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Name</label>
                                    <div class="col-sm-9">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancarddetails->pan_name) && !empty($pancarddetails->pan_name) ? $pancarddetails->pan_name : '' }}"
                                            readonly="">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">DoB</label>
                                    <div class="col-sm-9">
                                        <?php
                                        $pancarddetailsdob = '';
                                        if (!empty($pancarddetails->dob) && $pancarddetails->dob != '1970-01-01' && $pancarddetails->dob != '0000-00-00') {
                                            $pancarddetailsdob = $pancarddetails->dob;
                                        } ?>
                                        <input type="" class="form-control" value="<?php echo !empty($pancarddetailsdob) ? date('d-m-Y', strtotime($pancarddetailsdob)) : ''; ?>"
                                            readonly="">
                                        <!-- {{ isset($pancarddetails->dob) && !empty($pancarddetails->dob) ? $pancarddetails->dob : '' }} -->
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">PAN No.</label>
                                    <div class="col-sm-9">
                                        <input type="" class="form-control"
                                            value="{{ isset($pancarddetails->pan_number) && !empty($pancarddetails->pan_number) ? $pancarddetails->pan_number : '' }}"
                                            readonly="">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Image</label>
                                    <div class="col-sm-9">
                                        <?php
                                        $ext = pathinfo($pancarddetails->image, PATHINFO_EXTENSION); ?>
                                        @if ($ext == 'pdf')
                                            <i class="fa fa-file-pdf-o" style="color:red;font-size:30px;"></i>
                                        @else
                                            <!-- <a href="<?php //echo $pancarddetails->image;
                                            ?>" target="_blank" class="btn btn-info">
                                                 <img src="{{ url()->asset($pancarddetails->image) }}" style="max-width:100px;"></a> -->
                                            <?php $im = explode('/', $pancarddetails->image); ?>
                                            <?php //echo CONTENT_URL.'uploads/users/'.end($im);
                                            ?>
                                            <img src="<?php echo $pancarddetails->image; ?>" style="max-width:100px;">
                                            <!-- <img src="<?php echo CONTENT_URL . 'uploads/users/' . end($im); ?>" style="max-width:100px;"> -->
                                        @endif
                                    </div>
                                    <!-- <div class="col-sm-3 text-right"><a class="btn btn-info" href="{{ route($modelName . '.edit_pan_details', base64_encode(serialize($pancarddetails->id))) }}" style="curor:pointer"><i class="fa fa-edit"></i> Edit pan details</a></div> -->
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <div class="col-sm-9">
                                        <?php $im = explode('/', $pancarddetails->image); ?>
                                        <a href="<?php echo $pancarddetails->image; ?>" target="_blank" class="btn btn-info mr-2"><i
                                                class="fa fa-eye mr-2"></i>View Image </a>
                                        <a class="btn btn-info"
                                            href="{{ route($modelName . '.edit_pan_details', base64_encode(serialize($pancarddetails->id))) }}"
                                            style="curor:pointer"><i class="fa fa-edit mr-2"></i>Edit pan details</a>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Comment</label>
                                    <div class="col-sm-9">
                                        <textarea type="text" rows="3" class="form-control" required="" name="comment" placeholder="Comment"
                                            id="commentpan" style="width:100%;float:left;margin-right:15px;"></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label">Status</label>
                                    <div class="col-sm-9 py-2">
                                        @if ($pancarddetails->status == 1)
                                            <span style="color:green"><i
                                                    class="fa fa-check-circle-o success_icn mr-2"></i>Request
                                                Approved</span>
                                        @else
                                            @if ($pancarddetails->status == 2)
                                                <span style="color:red"><i
                                                        class="fa fa-times-circle-o failed_icn mr-2"></i>Request
                                                    Rejected</span>
                                            @else
                                                <span style="color:#5D78FF"><i
                                                        class="fa fa-clock-o primary_icn mr-2"></i>Pending</span>
                                            @endif
                                        @endif
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label class="col-sm-3 col-form-label"></label>
                                    <div class="col-sm-9">
                                        <!-- <div class="row no-gutters">
                                            <div class="col">
                                                @if ($pancarddetails->status == 1)
    <a style="color:white" class="btn btn-success">Request Approved</a>
@else
    <a  onclick="clickpan('1');" class="btn btn-info" style="curor:pointer">Approve Request</a>
    @endif
                                            </div>
                                            <div class="col pl-3">
                                                @if ($pancarddetails->status == 2)
    <a style="color:white" class="btn btn-danger">Request Rejected</a>
@else
    <a  onclick="clickpan('2');" class="btn btn-danger" style="curor:pointer">Reject Request</a>
    @endif
                                            </div>
                                        </div>  -->
                                        <div class="row no-gutters">
                                            <div class="col">
                                                @if ($pancarddetails->status == 1)
                                                    <a onclick="clickpan('2');" class="btn btn-danger"
                                                        style="curor:pointer">Reject Request</a>
                                                @else
                                                    @if ($pancarddetails->status == 2)
                                                        <a onclick="clickpan('1');" class="btn btn-success"
                                                            style="curor:pointer;">Approve Request</a>
                                                    @else
                                                        @if ($pancarddetails->status == 0)
                                                            <a onclick="clickpan('1');" class="btn btn-success mr-2"
                                                                style="curor:pointer;">Approve Request</a>
                                                            <a onclick="clickpan('2');" class="btn btn-danger"
                                                                style="curor:pointer">Reject Request</a>
                                                        @endif
                                                    @endif
                                                @endif
                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
<script>
    function clickpan(value) {
        if (value == 2) {
            var getcomment = $("#commentpan").val();
            if (getcomment == "") {
                alert('Please Enter comment first.');
                return false;
            }
        }
        $("#panstatus").val(value);
        $("#panUpdateDetailForm").submit();
    }
</script>
