@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
            $('#start_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
            $('#end_date').datetimepicker({
                timepicker: false,
                format: 'Y-m-d'
            });
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>All Refered Users</h4>
                    </div> -->
                <?php //echo base64_encode(serialize(84304));
                ?>
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('Registerusers.view') }}">All Register Users</a></li>
                    <li class="breadcrumb-item">View Transactions</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4>View All Transactions</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <div class="col-md-3"></div>
                            <div class="col-md-3"></div>
                            <div class=" col-md-3">
                                <form action="{{ route($modelName . '.download', base64_encode(serialize($id))) }}"
                                    enctype="multipart/form-data" class="form-inline" id="transactionsForm" method="POST">
                                    @csrf
                                    <input type="hidden" name="status" value="{{ $status }}">
                                    <input type="hidden" name="start_date" value="{{ $start_date }}">
                                    <input type="hidden" name="end_date" value="{{ $end_date }}">
                                    <button class="btn btn-primary mr-3" type="submit"></i>Download Report</button>
                                </form>
                            </div>
                            <form action="{{ route($modelName . '.transactions', base64_encode(serialize($id))) }}"
                                class="form-inline" id="transactionsForm" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group col-md-3">
                                    <!-- Card -->
                                    <div class="col-md card mb-0" data-aos="fade-up">
                                        <div class="card-body">
                                            <h5 class="mb-0">Pick Start Date</h5>
                                            <input name="start_date" id="start_date"
                                                class="datepicker-default form-control datetimepickerget"
                                                autocomplete="off">
                                        </div>
                                        <!-- <div class="card-body">
                                                <p class="mb-1">Default picker</p>
                                                <input name="start_date" id="start_date" class="datepicker-default form-control datetimepickerget" autocomplete="off">
                                            </div> -->
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <!-- Card -->
                                    <div class="col-md card mb-0" data-aos="fade-up">
                                        <div class="card-body">
                                            <h5 class="mb-0">Pick End Date</h5>
                                            <input name="end_date" id="end_date"
                                                class="datepicker-default form-control datetimepickerget"
                                                autocomplete="off">
                                        </div>
                                        @if (Session()->has('successs'))
                                            <div class="alert alert-danger">
                                                <!-- <ul> -->
                                                <span>{!! session()->get('successs') !!}</span>
                                                <!-- </ul> -->
                                            </div>
                                        @endif
                                        <!-- <div class="card-body">
                                                <p class="mb-1">Default picker</p>
                                                <input name="end_date" id="end_date" class="datepicker-default form-control datetimepickerget" autocomplete="off">
                                            </div> -->
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <!-- Card -->
                                    <div class="col-md card mb-0" data-aos="fade-up">
                                        <div class="card-body">
                                            <h5 class="mb-0">Select status</h5>
                                            <select name="status" class="form-control">
                                                <option value="">Select Deposit/Withdraw</option>
                                                <option value="deposit">Deposit</option>
                                                <option value="withdraw">Withdraw</option>
                                                <option value="admin">Admin</option>

                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md card mb-0 b_shad_n" data-aos="fade-up">
                                    <div class="card-body">
                                        <button class="btn btn-primary mr-3" type="submit"><i
                                                class="fa fa-search mr-2"></i>Search</button>
                                        <a href="{{ route($modelName . '.transactions', base64_encode(serialize($id))) }}"
                                            class="btn btn-gray"><i class="fa fa-repeat mr-2"></i>Reset</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @if (isset($allplayers) && count($allplayers) > 0)
            <div class="row">
                <div class="col-12">
                    <div class="card" data-aos="fade-up">
                        <div class="card-header">
                            <h4>Transaction Details</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataList" class="display" style="min-width: 845px">

                                    <thead>
                                        <tr>
                                            <th>Type</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Winning Balance</th>
                                            <th>Cash Balance</th>
                                            <th>Bonus Balance</th>
                                            <th>GST Bonus</th>
                                            <th>Affiliation Amount</th>
                                            <th>Total Available Balance</th>
                                            <th>Challenge ID</th>
                                            <th>Deposit By</th>
                                            <th>Match Title</th>
                                            <th>Transaction Id</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($allplayers as $player)
                                            <tr role="row" class="odd">
                                                <td style="width: 250px !important;">{{ $player->type }}</td>
                                                <td
                                                    style="color: <?php if($player->type=='Challenge Joining Fee' || $player->type=='Amount Withdrawn' || $player->transaction_by=='wallet') { ?>red; <?php } else { ?>green; <?php } ?>">
                                                    <?php echo $player->amount; ?></td>
                                                <td>{{ $player->paymentstatus }}</td>
                                                <td>{{ $player->bal_win_amt }}</td>
                                                <td>{{ $player->bal_fund_amt }}</td>
                                                <td>{{ $player->bal_bonus_amt }}</td>
                                                <td>{{ $player->bal_gst_bonus_amt }}</td>
                                                <td>{{ $player->bal_affi_amt }}</td>
                                                <td>{{ $player->total_available_amt }}</td>
                                                <td>{{ $player->challengeid }}</td>
                                                <td>
                                                    @if (
                                                        $player->transaction_by == 'PHONEPAY' ||
                                                            $player->transaction_by == 'SubPaisa' ||
                                                            $player->transaction_by == 'SONICPAY' ||
                                                            $player->transaction_by == 'admin' ||
                                                            $player->transaction_by == 'razorPay')
                                                        {{ $player->transaction_by }}
                                                    @else
                                                    @endif
                                                </td>
                                                <td>{{ $player->title }}</td>
                                                <td>{{ @$player->transaction_id }}</td>
                                                <td>{{ date('Y-m-d', strtotime($player->created)) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Type</th>
                                            <th>Amount</th>
                                            <th>Winning Bal</th>
                                            <th>Cash Bal</th>
                                            <th>Bonus Bal</th>
                                            <th>Total Available Bal</th>
                                            <th>Challenge ID</th>
                                            <th>Deposit By</th>
                                            <th>Match Title</th>
                                            <th>Date</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
@else
    <p> No Record founds!</p>
    @endif

@endsection
<script src="https://code.jquery.com/jquery-3.4.1.min.js"
    integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
<script type="text/javascript">
    /*$(document).on("click", ".get-transactions-data", function () {
    $('#dataList').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{ route($modelName . '.transactions', $id) }}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}",
                "start_date": $('input[name=start_date]').val(),
                "end_date": $('input[name=end_date]').val(),
                }
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'type', name: 'transactions.type'},
            {data: 'amount', name: 'amount'},
            {data: 'bal_win_amt', name: 'bal_win_amt'},
            {data: 'bal_fund_amt', name: 'bal_fund_amt'},
            {data: 'bal_bonus_amt', name: 'bal_bonus_amt'},
            {data: 'total_available_amt', name: 'total_available_amt'},
            {data: 'challengeid', name: 'challengeid'},
            {data: 'title', name: 'title'},
            {data: 'created', name: 'created'},
        ]
    });*/
    $(document).ready(function() {
        $('#dataList').DataTable({
            "order": false
        });
    });
</script>
