@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Paytm Withdraw Requests</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <!-- <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="javascript:void(0)">Paytm Withdraw Requests</a></li>
                </ol> -->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <div class="card-body p-0">
                            <div class="basic-form">
                                <form action="{{ route($modelName . '.upload_withdrawl_excel') }}" method="post"
                                    id="panUpdateDetailForm" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <h4>Instant Withdraw Requests</h4>
                                            </div>
                                        </div>
                                        <div class="col-md-4 d-flex justify-content-between">
                                            <div class="form-group flex-fill pr-3 mb-0">
                                                <input type="file" required="" name="file"
                                                    class="pull-left form-control"
                                                    accept=".csv, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel">
                                            </div>
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="fa fa-file-excel-o mr-2"></i>Upload CSV</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="dataList" class="display" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>
                                            <input type="text" id="filter_mobile" name="filter_mobile"
                                                value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_mobile')">
                                            Mobile Number
                                        </th>
                                        <th>
                                            <input type="text" id="filter_withdraw_amount" name="filter_withdraw_amount"
                                                value="<?php echo @$_GET['filter_withdraw_amount']; ?>" onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_withdraw_amount')">
                                            Withdrawl Amount
                                        </th>
                                        <!-- <th>
                                        <input type="text" id="filter_username" name="filter_username" value="<?php echo @$_GET['filter_username']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_username')">
                                        User Name</th> -->
                                        <th>
                                            <input type="text" id="filter_withdraw_request_id"
                                                name="filter_withdraw_request_id" value="<?php echo @$_GET['filter_withdraw_request_id']; ?>"
                                                onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_withdraw_request_id')">
                                            Withdraw Request ID
                                        </th>
                                        <!-- <th>
                                        <input type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')">
                                        User Email</th> -->
                                        <!-- <th>Approve Manual</th> -->
                                        <th>Requested Date</th>
                                        <th>Approved Date</th>
                                        <th>Razorpay Status</th>
                                        <th>
                                            <select id="filter_withdraw_status" name="filter_withdraw_status"
                                                style="width:100%" onclick="cancelEvent()"
                                                onchange="filterData(event , 'filter_withdraw_status')">
                                                <option selected value="">All</option>
                                                <option <?php if (@$_GET['filter_withdraw_status'] === '0') {
                                                    echo 'selected';
                                                } ?> value="0">Pending</option>
                                                <option <?php if (@$_GET['filter_withdraw_status'] === '1') {
                                                    echo 'selected';
                                                } ?> value="1">Approved</option>
                                                <option <?php if (@$_GET['filter_withdraw_status'] === '2') {
                                                    echo 'selected';
                                                } ?> value="2">Rejected</option>
                                            </select><br>
                                            Status
                                        </th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                                <tfoot>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Mobile Number</th>
                                        <th>Withdrawl Amount</th>
                                        <!-- <th>User Name</th> -->
                                        <th>Withdraw RequestId</th>
                                        <!-- <th>User Email</th> -->
                                        <!-- <th>Approve Manual</th> -->
                                        <th>Requested Date</th>
                                        <th>Approved Date</th>
                                        <th>Razorpay Status</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        var fieldname = '';
        var filtercolums = {

        }


        function cancelEvent() {
            event.stopPropagation();
        }

        var filtercolums = {

        };

        var input_filter_mobile = '';
        var input_filter_withdraw_amount = '';
        var input_filter_username = '';
        var input_filter_withdraw_request_id = '';
        var input_filter_email = '';
        var input_filter_withdraw_status = '';
        var input_filter_status = '';

        function updateURL(event, fieldname) {
            var value = event.target.value;


            if (fieldname == 'filter_status') {
                input_filter_status = value;
            }


            if (fieldname == 'filter_mobile') {
                input_filter_mobile = value;
            }
            if (fieldname == 'filter_withdraw_amount') {
                input_filter_withdraw_amount = value;
            }
            if (fieldname == 'filter_username') {
                input_filter_username = value;
            }
            if (fieldname == 'filter_withdraw_request_id') {
                input_filter_withdraw_request_id = value;
            }
            if (fieldname == 'filter_email') {
                input_filter_email = value;
            }
            if (fieldname == 'filter_withdraw_status') {
                input_filter_withdraw_status = value;
            }

            var url = window.location.href.split('?')[0];
            history.pushState('', '', url + "?filter=1&filter_mobile=" + input_filter_mobile + "&filter_withdraw_amount=" +
                input_filter_withdraw_amount + "&filter_username=" + input_filter_username +
                "&filter_withdraw_request_id=" + input_filter_withdraw_request_id + "&filter_email=" +
                input_filter_email + "&filter_withdraw_status=" + input_filter_withdraw_status + "&filter_status=" +
                input_filter_status);

        }

        function filterData(event, fieldname) {

            var value = event.target.value;
            updateURL(event, fieldname);

            if (fieldname == 'filter_mobile') {
                filtercolums['filter_mobile'] = value;
            }
            if (fieldname == 'filter_withdraw_amount') {
                filtercolums['filter_withdraw_amount'] = value;
            }
            if (fieldname == 'filter_username') {
                filtercolums['filter_username'] = value;
            }
            if (fieldname == 'filter_withdraw_request_id') {
                filtercolums['filter_withdraw_request_id'] = value;
            }
            if (fieldname == 'filter_email') {
                filtercolums['filter_email'] = value;
            }
            if (fieldname == 'filter_withdraw_status') {
                filtercolums['filter_withdraw_status'] = value;
            }

            if (fieldname == 'filter_status') {
                filtercolums['filter_status'] = value;
            }

            //URL UPDATE


            $('#dataList').DataTable().clear().destroy(); //clear table data Table

            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.withdraw_amount_instant') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "filter_columns": filtercolums
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'withdraw_amount',
                        name: 'withdraw_amount'
                    },
                    // {data: 'username', name: 'username'},
                    {
                        data: 'withdraw_request_id',
                        name: 'withdraw_request_id'
                    },
                    // {data: 'email', name: 'email'},
                    // {data: 'approve_paytm_manual', name: 'approve_paytm_manual'},
                    {
                        data: 'withdraw_request',
                        name: 'withdraw_request'
                    },
                    {
                        data: 'approved_date',
                        name: 'approved_date'
                    },
                    {
                        data: 'cashfree_error_text',
                        name: 'cashfree_error_text'
                    },
                    {
                        data: 'withdraw_status',
                        name: 'withdraw_status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            document.getElementById(fieldname).focus();

        }


        function DataTable(obj = null, filtercolums) {
            var req_id_update = {};

            if (obj != null) {
                var req_id_update = {
                    withdraw_request_id: obj.withdraw_request_id,
                    id: obj.id
                };
            }

            let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';
            let filter_withdraw_amount = '<?php echo @$_GET['filter_withdraw_amount']; ?>';
            let filter_username = '<?php echo @$_GET['filter_username']; ?>';
            let filter_withdraw_request_id = '<?php echo @$_GET['filter_withdraw_request_id']; ?>';
            let filter_email = '<?php echo @$_GET['filter_email']; ?>';
            let filter_withdraw_status = '<?php echo @$_GET['filter_withdraw_status']; ?>';


            if (filter_mobile !== '') {
                filtercolums['filter_mobile'] = filter_mobile;
            }
            if (filter_withdraw_amount !== '') {
                filtercolums['filter_withdraw_amount'] = filter_withdraw_amount;
            }
            if (filter_username !== '') {
                filtercolums['filter_username'] = filter_username;
            }
            if (filter_withdraw_request_id !== '') {
                filtercolums['filter_withdraw_request_id'] = filter_withdraw_request_id;
            }
            if (filter_email !== '') {
                filtercolums['filter_email'] = filter_email;
            }
            if (filter_withdraw_status !== '') {
                filtercolums['filter_withdraw_status'] = filter_withdraw_status;
            }
            $('#dataList').DataTable({
                // order: [0, 'desc'],
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.withdraw_amount_instant') }}",
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "req_id_update": req_id_update,
                        "filter_columns": filtercolums
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'withdraw_amount',
                        name: 'withdraw_amount'
                    },
                    // {data: 'username', name: 'username'},
                    {
                        data: 'withdraw_request_id',
                        name: 'withdraw_request_id'
                    },
                    // {data: 'email', name: 'email'},
                    // {data: 'approve_paytm_manual', name: 'approve_paytm_manual'},
                    {
                        data: 'withdraw_request',
                        name: 'withdraw_request'
                    },
                    {
                        data: 'approved_date',
                        name: 'approved_date'
                    },
                    {
                        data: 'cashfree_error_text',
                        name: 'cashfree_error_text'
                    },
                    {
                        data: 'withdraw_status',
                        name: 'withdraw_status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
        }
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            let filter_status = '<?php echo @$_GET['filter_status']; ?>';

            var filtercolums = {

            }
            // FOR SELECT Filtering
            if (filter_status !== '') {
                filtercolums['filter_status'] = filter_status;
            }

            DataTable(null, filtercolums);

            $(document).on('click', '.admin-comment', function() {
                let form_type = $(this).data("type").trim();
                let text_comment = $(this).closest(".text-comment").val();
                if (text_comment == '') {
                    alert("please fill input field.");
                    return false;
                } else {
                    let input = jQuery('<input type="hidden"  name="type" value="' + form_type + '">');
                    $(this).closest('form').append(input);
                    $(this).form[0].submit();
                }
            });

            function getFormData(id2) {
                let id = $('#w_id' + id2).val();
                let withdraw_request_id = $('#req_id' + id2).val();

                if (id != '' && withdraw_request_id != '') {

                    var obj = {
                        id: id,
                        withdraw_request_id: withdraw_request_id
                    }

                    DataTable(obj, filtercolums);
                }
            }

        });
    </script>
@endsection
