@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script type="text/javascript">
$(function(){
	$(document).on('click', '.confirm_box', function(e) {
		e.preventDefault();
		var target_url 	= $(this).attr('href');
		var rel 	= $(this).attr('rel');
		var id 	= $(this).attr('rev');
		bootbox.confirm({
			message: $(this).attr('rel'),
			buttons: {
				confirm: {
					label: 'Yes',
					className: 'btn-success'
				},
				cancel: {
					label: 'No',
					className: 'btn-danger'
				}
			},
			callback: function (result) {
				if (result == true)
				{
					window.location = target_url;
				}
			}
		});
	});
});
</script>
<script>
	$(document).ready(function(){
		$('[data-toggle="tooltip"]').tooltip();
	});
</script>
<div class="portlet box green">
	<div class="portlet-title">
		<div class="caption">
			<i class="fa fa-users"></i>{{trans("messages.$modelName.table_heading_index")}} </div>
		<div class="tools add-user">
			<a href="{{route($modelName.'.add')}}">{{trans('messages.global.add_new')}}</a>
		 </div>
	</div>
	<div class="portlet-body table-responsive">
		<table class="table table-striped table-bordered table-hover" id="userList">
			<thead>
				<tr>
					<th> {{ trans("messages.$modelName.id") }} </th>
					<th> {{ trans("messages.$modelName.title") }} </th>
					<th> {{ trans("messages.$modelName.key") }} </th>
					<th> {{ trans("messages.$modelName.value") }} </th>
					<th> {{ trans("messages.global.action") }} </th>
				</tr>
			</thead>
			@if(isset($model) && count($model)>0)
				<tbody>
					@foreach($model as $result)
					<?php
						$key = $result->key_value;
						$keyE = explode('.', $key);
						$keyPrefix = $keyE['0'];
						if (isset($keyE['1'])) {
							$keyTitle = '.' . $keyE['1'];
						} else {
							$keyTitle = '';
						}?>
					<tr>
						<td data-th='{{ trans("messages.$modelName.id") }}'>{{ $result->id }}</td>
						<td data-th='{{ trans("messages.$modelName.title") }}'>{{ $result->title }}</td>
						<td data-th='{{ trans("messages.$modelName.key") }}'>
							<a target="_blank" href='{{ route("Setting.prefix_index",array($keyPrefix)) }}' >{{ $keyPrefix }}</a>{{ $keyTitle }}
						</td>
						<td data-th='{{ trans("messages.$modelName.value") }}'>
							{{ strip_tags(Str::limit($result->value, 20)) }}
						</td>
						<td data-th='{{ trans("messages.global.action") }}'>
							<a href="{{ route('Setting.edit',array($result->id))}}" class="btn btn-info btn-small">{{ trans("messages.global.edit") }} </a>
							<a href="{{ route('Setting.delete',array($result->id))}}" data-delete="delete" rel="Are you sure to delete" class="btn btn-danger btn-small no-ajax confirm_box">{{ trans("messages.global.delete") }} </a>
						</td>
					</tr>
				@endforeach
				</tbody>
			@endif
		</table>
	</div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->
<script>
	$(document).ready(function(){
		$('#userList').DataTable();

		$(document).on('click', '.action-setting', function () {
	        if(!confirm("Are You Sure to delete this setting?"))
	        event.preventDefault();
	    });


	});
</script>
@endsection
