@extends('admin.layouts.default')

@section('content')
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>

<script>
	/**
	 * Function to get prefix of setting
	 */
	$(document).ready(function(){
		<?php
		if($prefix == 'Email'){
		?>
			var emailTypeVal = $('.emailTypeSelect').val();
			if(emailTypeVal == 'Normal'){
				$("#CustomFormValidation").find('.mws-form-row').hide();
				$("#CustomFormValidation").find('.emailType').show();
			}
		<?php }  ?>
		<?php if($prefix == 'Email'){  ?>
				if($('.emailTypeSelect').val() == 'Normal'){
					$("#CustomFormValidation").find('input,textarea,label').hide();
					$('.emailDropDown').show();
					$('.emailDropDownlabel').show();
				}
				$('.emailTypeSelect').change(function(){
					var emailTypeVal = $(this).val();
					if(emailTypeVal == 'Normal'){
						$("#CustomFormValidation").find('input,textarea,label').hide();
						$("#CustomFormValidation").find('.mws-form-row').hide();
						$("#CustomFormValidation").find('.emailType').show();
						$('.emailDropDown').show();
						$('.emailDropDownlabel').show();
					}else{
						$("#CustomFormValidation").find('input,textarea,label').show();
						$("#CustomFormValidation").find('.mws-form-row').show();
					}
				});
		<?php } ?>
	});
</script>

<div class="mws-panel grid_8">
	<div class="mws-panel-header">
		<span>{{ trans("messages.settings.setting") }} {{ $prefix }}</span>
	</div>
	<div class="mws-panel-body no-padding">
        <form action="{{ route("Setting.prefix_update",array($prefix)) }}" method="POST" enctype="multipart/form-data" id="CustomFormValidation" >
            @csrf
            <div class="mws-form-inline">
		<?php $i = 0;
		if(!empty($result)){
			foreach ($result AS $setting) {
				$text_extention 	= 	'';
				$key				= 	$setting['key_value'];
				$asterisk			=	 '*';
				$keyE 				= 	explode('.', $key);
				$keyTitle 			= 	$keyE['1'];
				$label = $keyTitle;
				if ($setting['title'] != null) {
					$label = $setting['title'];
				}
				$inputType = 'text';
				if ($setting['input_type'] != null) {
					$inputType = $setting['input_type'];
				} ?>
                <input type="hidden" name="{{$setting[$i]['type']}}" value="{{$inputType}}" />
                <input type="hidden" name="{{$setting[$i]['id']}}" value="{{$$setting['id']}}" />
                <input type="hidden" name="{{$setting[$i]['key_value']}}" value="{{$$setting['key_value']}}" />
				<?php switch($inputType){
						case 'checkbox':
				?>

				<div class="mws-form-row">
					<label class="mws-form-label" style="width:300px;"><?php echo $label; ?></label>
					<div class="mws-form-item clearfix">
						<ul class="mws-form-list inline">
							<?php
								$checked = ($setting['value'] == 1 )? true: false;
								$val	 = (!empty($setting['value'])) ? $setting['value'] : 0;
							?>
                            <input type="checkbox" name="{{$setting[$i]['key_value']}}" value="{{$val}}" @if($checked) checked @endif >
						</ul>
					</div>
				</div>
				<?php
						break;
						case 'textarea':
						case 'text':
				?>

				<div class="mws-form-row">
					<label  class="mws-form-label"  style="width:300px;">
					<?php echo $label; ?></label>
					<div class="mws-form-item">
                        <input type="{{$inputType}}" name="{{$setting[$i]['value']}}" value="{{$setting['value']}}" class="small" placeholder="{{$label}}">
						<?php
						if($setting['key_value']== 'Site.video'){
						?>
						<span class='tooltipHelp' title="" data-html="true" data-toggle="tooltip"  data-original-title="<?php echo trans("messages.setting.please_enter_iframe_embedded_url");  ?>" style="cursor:pointer;">
									<i class="fa fa-question-circle fa-2x"> </i>
								</span>
					<?php  } ?>
					</div>
				</div>
				<?php
					break;
					case 'select':
				?>
				<div class="mws-form-row emailType" >
					<label class="mws-form-label emailDropDownlabel"  style="width:300px;">
                        <label class="control-label emailDropDown"> {{$setting[$i]['value']}} </label>
					</label>
					<div class="mws-form-item">
						<?php
							$options		=	explode(',',$setting['value']);
							$arrayValues	=	array_values($options);
							$options 		=	array_combine($arrayValues,$arrayValues);
							$emailClass		=	($prefix == 'Email') ? 'emailTypeSelect' : '';
							$selected		=	(in_array($setting['default_type'],$arrayValues)) ? $setting['default_type'] : '';
						?>
						<select class="emailClass small" name="{{$setting[$i]['value']}}">
                            @foreach($options as $key => $value)
                                <option value="{{$key}}"> {{$value}} </option>
                            @endforeach
                        </select>
					</div>
					<span class="help-inline">

					</span>
				</div>
				<?php
					break;
					case	'file':
				?>
				<div class="mws-form-row">
					<label  class="mws-form-label"  style="width:300px;"><?php echo $label; ?></label>
					<div class="mws-form-item">
						{{ Form::{}("Setting[$i][".'value'."]",['class'=>'floatleft',"accept"=>"image/*"]) }}
                        <input type="{{$inputType}}" name="Setting[$i][".'value'."]"
						<?php
							$image	=	Input::old('image');
							$image	=	isset($image) ? $image : $setting['value'];
						?>
							@if($image && File::exists(SETTING_IMG_ROOT_PATH.$setting['value']))
								<a href="<?php echo SETTING_IMG_URL.$image; ?>"  class="items-image" data-lightbox="roadtrip" >
									{{ HTML::image(SETTING_IMG_URL.$setting['value'], $setting['value'] , array( 'width' => 70, 'height' => 70 )) }}
								</a>
							@endif
						<span class='tooltipHelp' title="" data-html="true" data-toggle="tooltip"  data-original-title="<?php echo trans("messages.global.image_mime_type_msg").' '.IMAGE_EXTENSION;  ?>" style="cursor:pointer;">
							<i class="fa fa-question-circle fa-2x"> </i>
						</span>
					</div>
				</div>
				<?php
					break;
					default:
				?>
				<div class="mws-form-row">
					<label  class="mws-form-label"  style="width:300px;"><?php echo $label; ?></label>
					<div class="mws-form-item">
						{{ Form::textarea("Setting[$i][".'value'."]",$setting['value'], ['class' => 'small','placeholder'=>$label]) }}
					</div>
				</div>
				<?php break; }
				$i++;
			}
		}
		?>
	</div>
		<div class="mws-button-row">
			<button type="submit" class="btn btn-danger" id="submit"> {{ trans('messages.settings.save') }} </button>
		</div>
		{{ Form::close() }}
	</div>
</div>
<script>
/** For tooltip */
	$('[data-toggle="tooltip"]').tooltip();
</script>
@stop
