@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--*************** Content body start ******************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>Edit Sub Admin</h4>
                        <span class="ml-1">Layout</span>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active">
                        <a href="{{ route($modelName . '.view') }}">View all Sub Admin</a>
                    </li>
                    <li class="breadcrumb-item">Edit Sub Admin</li>
                </ol>
            </div>
        </div>

        <?php //echo "<pre>"; print_r($selected_model);
        ?>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Sub Admin</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form action="{{ route($modelName . '.edit', base64_encode(serialize($subadmin->id))) }}"
                                enctype="multipart/form-data" id="EditForm">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Name</label>
                                        <input id="name" name="name" type="text"
                                            placeholder="enter sub admin name" class="form-control in_text"
                                            value="{{ $subadmin->name }}" autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('name'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Email</label>
                                        <input id="email" name="email" type="text"
                                            placeholder="enter sub admin email id" class="form-control in_text"
                                            value="{{ $subadmin->email }}" autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('email'); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Phone No</label>

                                        <input id="mobile"
                                       name="mobile"
                                       type="tel"
                                       placeholder="Enter sub admin mobile no"
                                       class="form-control in_text"
                                       value="{{ $subadmin->mobile }}"
                                       inputmode="numeric"
                                       pattern="[0-9]*"
                                       maxlength="10"
                                       title="Please enter a valid 10-digit mobile number"
                                       oninput="this.value = this.value.replace(/[^0-9]/g, '')">

                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('mobile'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Password</label>
                                        <input id="password" name="password" type="password"
                                            placeholder="enter sub admin password" class="form-control in_text"
                                            autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('password'); ?>
                                        </div>
                                    </div>
                                </div>
                                <?php $model_ids = []; ?>
                                <div class="form-group col-md-6 pl-1 overflow-hidden">
                                    <label class="lbl_frm py-2">Module</label>
                                    <select class="form-control in_text" id="model_id[]" name="model_id[]"
                                        multiple="multiple" autocomplete="off">
                                        @if (isset($sub_model) && !empty($sub_model))
                                            @foreach ($sub_model as $model_val)
                                                <?php
                                                $str = '';
                                                foreach ($selected_model as $selected_model_val) {
                                                    if ($model_val->id === $selected_model_val->model_id) {
                                                        //$model_ids[]=$model_val->id;

                                                        $str = 'selected=""';
                                                    }
                                                }
                                                ?>
                                                <option value="<?php echo $model_val->id; ?>"
                                                    onclick="viewAction(event,<?php echo $model_val->id; ?>)" <?php echo $str; ?>>
                                                    {{ $model_val->model_name }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                    <div class="error-message help-inline">
                                        <?php echo $errors->first('model_id[]'); ?>
                                    </div>
                                </div>

                                @if (isset($selected_model_action) && !empty($selected_model_action))
                                    <div class="row">
                                        @foreach ($selected_model_action as $selected_model_val)
                                            <div class="col-md-4 mb-3 checkbox-{{ $selected_model_val->model_id }}">
                                                <div class="card p-3">
                                                    <?php
                                                    $modelname = DB::table('models')->where('id', $selected_model_val->model_id)->first();
                                                    ?>
                                                    <h5 class="mb-3">{{ @ucwords($modelname->model_name) }}</h5>

                                                    <?php
                                                    $actionname = DB::table('model_actions')->where('model_id', $selected_model_val->model_id)->get();
                                                    ?>

                                                    @foreach ($actionname as $action_model_val)
                                                        <?php
                                                        $checkaction = DB::table('sub_admin_models')->where('model_id', $selected_model_val->model_id)->where('model_actions_id', $action_model_val->id)->where('sub_admin_id', $subadmin->id)->select('model_actions_id')->first();

                                                        $checkIfzero = DB::table('sub_admin_models')->where('model_id', $selected_model_val->model_id)->where('sub_admin_id', $subadmin->id)->select('model_actions_id')->first();
                                                        ?>

                                                        <div class="form-check">
                                                            <input type="checkbox" class="form-check-input"
                                                                name="models_actions[]"
                                                                value="{{ $action_model_val->id . ',' . $selected_model_val->model_id }}"
                                                                <?php if (!empty($checkaction) || $checkIfzero->model_actions_id == 0) {
                                                                    echo "checked='' ";
                                                                } ?>>
                                                            <label
                                                                class="form-check-label">{{ ucwords($action_model_val->action) }}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif


                            </form>

                        </div>

                    </div>

                    <div class="card-footer py-4">
                        <button type="submit" class="btn btn-primary mr-2 submit-from">Submit</button>
                        <button class="btn btn-gray" id="cancel_btn" type="button">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--**********************************
        Content body end
        ***********************************-->
    <script type="text/javascript">
        var dbData = [];

        function addDbData() {
            <?php
  foreach ($selected_model_action as $value) {
    ?>
            dbData.push(parseInt('<?= $value->model_id ?>'));
            <?php
  }
  ?>
            console.log(dbData)
        }

        let isInitialized = false; // This should become true after first load

  // Example function to initialize (call this after your initial data load)
  function initializeData() {
      for (let p = 0; p < dbData.length; p++) {
          $("select option[value='" + dbData[p] + "']").prop("selected", true);
      }
      isInitialized = true; // Set flag to true after initialization is done
  }

  function viewAction(event, model_id) {
      if (!isInitialized) {
          alert("Please wait until the data is loaded");
          // return false;
      }

      for (let p = 0; p < dbData.length; p++) {
          $("select option[value='" + dbData[p] + "']").prop("selected", true);
      }

      var selectedInput = $("select option:selected");
      var selectdArr = [];
      for (let s = 0; s < selectedInput.length; s++) {
          selectdArr.push(parseInt(selectedInput[s].value));
      }

      if (dbData.includes(model_id)) {
          alert("Module is already selected");
      }

      for (let i = 0; i <= 21; i++) {
          if (!selectdArr.includes(i)) {
              if (!dbData.includes(i)) {
                  $('.checkbox-' + i).remove();
              }
          }
      }

      if ($('.checkbox-' + model_id).length) {
          if (!selectdArr.includes(model_id)) {
              if (!dbData.includes(model_id)) {
                  $('.checkbox-' + model_id).remove();
                  $("select option[value='" + model_id + "']").prop("selected", false);
              }
          }
      } else {
          if (!dbData.includes(model_id)) {
              $.ajax({
                  url: "{{ WEBSITE_ADMIN_SITE_URL }}Sub_admin/get-model-action",
                  cache: false,
                  type: "POST",
                  data: {
                      model_id: model_id
                  },
                  success: function(html) {
                      $("#EditForm").append(html);
                  }
              });
          }
      }
  }

        $(document).ready(function() {
            addDbData();
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
            $(document).on('click', '.submit-from', function() {
                $("#EditForm").submit();
            });
        });
    </script>

@endsection
