@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All series list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Series</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
              <div>
                <div class="card-header">
                  <h4>TDS Details
                  </h4>
                </div>
                  <div class="card-body">
                      <div class="basic-form">
                          <form id="searchTDSForm" method="GET" action="{{route('userTdsDetails')}}" >
                          @php

                              $start_date = @$_GET['start_date'] != '' ? $_GET['start_date'] : date('Y-m-d', strtotime("2021-03-01"));
                              $end_date = @$_GET['end_date'] != '' ? $_GET['end_date'] : date('Y-m-d', strtotime("2021-03-31"));
                          @endphp
                          <div class="form-row">

                              <div class="form-group col-md-2 mb-0">
                                  <label>Start Date</label>
                                  <div class="form-group col-md-6">
                                      <input type="text" name="start_date" id="start_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($start_date) && !empty($start_date) ? $start_date:''}}" autocomplete="off">
                                  </div>
                              </div>

                              <div class="form-group col-md-2 mb-0">
                                  <label>End Date</label>
                                  <div class="form-group col-md-6">
                                      <input type="text" name="end_date" id="end_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($end_date) && !empty($end_date) ? $end_date:''}}" autocomplete="off">
                                  </div>
                              </div>
                          </div>

                      </div>
                  </div>
                  <div class="card-footer py-4">
                      <button name="get-report" type="submit" class="btn btn-primary" >Get TDS Details</button>
                  </div>
                </form>
                  <!-- <a href="{{route('Series.add')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a> -->
                  <div class="card-footer py-4">
                    <form action="{{route($modelName.'.download')}}" method="POST" id="" enctype="multipart/form-data" >

                      <input type="hidden" name="start_date" id="start_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($start_date) && !empty($start_date) ? $start_date:''}}" autocomplete="off">
                      <input type="hidden" name="end_date" id="end_date" class="pull-left form-control datetimepickerget w-95" value="{{isset($end_date) && !empty($end_date) ? $end_date:''}}" autocomplete="off">
                        <button type="submit" class="btn btn-primary btn-sm mt-3"  style="height: 40px!important;"><i class="fa fa-file-excel-o mr-2"></i> Download CSV</button>
                    </form>
                  </div>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                  <th>S No.</th>
                                  <th>User Name </th>
                                  <th>Email id
                                    <input type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')">
                                  </th>
                                  <th>Mobile</th>
                                  <th>User Pan No</th>
                                  <th>Series Name</th>
                                  <th>Match Name</th>
                                  <th>Wining Amount</th>
                                  <th>TDS Amount</th>
                                  <th>Net Wining Amount</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                  <th>S No.</th>
                                  <th>User Name</th>
                                  <th>Email id </th>
                                  <th>Mobile</th>
                                  <th>User Pan No</th>
                                  <th>Series Name</th>
                                  <th>Match Name</th>
                                  <th>Wining Amount</th>
                                  <th>TDS Amount</th>
                                  <th>Net Wining Amount</th>
                                <!-- <th>Series Status</th>
                                <th>Action</th> -->
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">

            function cancelEvent(){
              event.stopPropagation();
            }

            var filtercolums = {

            };

            var input_filter_email = '';
          //  var input_filter_series_status = '';

            function updateURL(event , fieldname){
              var value = event.target.value;

              if(fieldname == 'filter_email'){
                input_filter_email = value;
              }
              // if(fieldname == 'filter_series_status'){
              //   input_filter_series_status = value;
              // }

              var url = window.location.href.split('?')[0];
            //  history.pushState('', '', url+"?filter=1&filter_email="+input_filter_email+"&filter_series_status="+input_filter_series_status);
                 history.pushState('', '', url+"?filter=1&filter_email="+input_filter_email);
            }

            function filterData( event , fieldname){

              var value = event.target.value;

              updateURL(event,fieldname);

              if(fieldname == 'filter_email'){
                filtercolums['filter_email'] = value;
              }
              // if(fieldname == 'filter_series_status'){
              //   filtercolums['filter_series_status'] = value;
              // }

              $('#dataList').DataTable().clear().destroy(); //clear table data Table

              $('#dataList').DataTable({
                order: [0, 'desc'],
                  "processing": true,
                  "serverSide": true,
                  "ajax":{
                    url:"{{route('userTdsDetails')}}",
                    type: "POST",
                    data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}

                  },

                  "columns": [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'username', name: 'username'},
                    {data: 'email', name: 'email'},
                    {data: 'mobile', name: 'mobile'},
                    {data: 'pan_number', name: 'pan_number'},
                    {data: 'name', name: 'name'},
                    {data: 'matchname', name: 'matchname'},
                    {data: 'amount', name: 'amount'},
                    {data: 'tds_amount', name: 'tds_amount'},
                    {data: 'net_amount', name: 'net_amount'},
                    //  {data: 'series_status', name: 'series_status'},
                    //  {data: 'action', name: 'action', orderable: false, searchable: false},
                  ]
              });

              document.getElementById(fieldname).focus();

            }

            $(document).ready(function() {
              let series_name = '<?php echo @$_GET['filter_email']; ?>';
              let startDate = '<?php echo @$_GET['start_date']; ?>';
              let endDate = '<?php echo @$_GET['end_date']; ?>';
              //let series_status = '<?php //echo @$_GET['filter_series_status']; ?>';

              if(series_name != ''){
                  filtercolums['filter_email'] = series_name;
              }

              if(start_date != ''){
                  filtercolums['filter_start'] = startDate;
              }


              if(end_date != ''){
                  filtercolums['filter_end'] = endDate;
              }



              // if(series_status != ''){
              //     filtercolums['filter_series_status'] = series_status;
              // }

                $('#dataList').DataTable({
                  order: [0, 'desc'],
                    "processing": true,
                    "serverSide": true,
                    "ajax":{
                      url:"{{route('userTdsDetails')}}",
                      type: "POST",
                      data : {"_token": "{{ csrf_token() }}" ,"filter_columns":filtercolums}
                    },
                    "columns": [
                      {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                      {data: 'username', name: 'username'},
                      {data: 'email', name: 'email'},
                      {data: 'mobile', name: 'mobile'},
                      {data: 'pan_number', name: 'pan_number'},
                      {data: 'name', name: 'name'},
                      {data: 'matchname', name: 'matchname'},
                      {data: 'amount', name: 'amount'},
                      {data: 'tds_amount', name: 'tds_amount'},
                      {data: 'net_amount', name: 'net_amount'},
                      //  {data: 'series_status', name: 'series_status'},
                      //  {data: 'action', name: 'action', orderable: false, searchable: false},
                    ]
                });
            });
            </script>
            <script type="text/javascript">

                //datepicket without time
                $(document).ready(function(){
                    $('#end_date,#start_date').datetimepicker({
                        timepicker: false,
                        format:'Y-m-d',
                        closeOnDateSelect:true,
                    });
                });

                $(document).on('click', '#Downlode_GSTBtn', function(event){
                    $( "#Downlode_GSTForm" ).submit();
                });

            </script>
            @endsection
