@extends('admin.layouts.default')
@section('content')
    <script type="text/javascript">
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <!--********************************** Content body start  ***********************************-->
    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                            <h4>Edit Team</h4>
                            <span class="ml-1">Layout</span>
                        </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route($modelName . '.view') }}">All Teams</a></li>
                    <li class="breadcrumb-item">Edit</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Edit Team</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="TeamEditForm" action="{{ route('Team.edit', base64_encode(serialize($series->id))) }}"
                                method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team Name</label>
                                        <input type="text" id="team" name="team" class="form-control in_text"
                                            value="{{ $series->team }}">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('team') }}
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team Short Name</label>
                                        <input type="text" id="short_name" name="short_name" class="form-control in_text"
                                            value="{{ $series->short_name }}">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('short_name') }}
                                        </div>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team Key</label>
                                        <input type="text" id="team_key" name="team_key" class="form-control in_text"
                                            value="{{ $series->team_key }}" disabled="">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('team_key') }}
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Color code</label>
                                        <input type="color" id="head" name="color"
                                            value="{{ isset($series->color) ? $series->color : '' }}">
                                        <div class="error-message help-inline">
                                            {{ $errors->first('team_key') }}
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="lbl_frm py-2">Team Logo</label>
                                        <!-- <input class="form-control in_text" name="logo[]" id="logo" type="file"> -->

                                        <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="logo[]"
                                            class="imageUpload form-control in_text" />
                                        <input type="hidden" name="base64image" name="base64image" id="base64image">
                                        <label for="imageUpload"></label>
                                        <div class="error-message help-inline">
                                            {{ $errors->first('logo') }}
                                        </div>
                                        @if ($series->logo != '')
                                            <img src="{{ $series->logo }}" class="py-2"
                                                style="width:100px;height:100px;">
                                        @else
                                            <img src="{{ DEFAULT_TEAM_IMAGE_URL }}" class="py-2"
                                                style="width:100px;height:100px;background-color:red;">
                                        @endif

                                    </div>
                                </div>
                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog"
        data-backdrop="static" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <!-- <span aria-hidden="true">&times;</span> -->
                    </button>
                </div>
                <div class="modal-body">
                    <div class="img-container">
                        <div class="row">
                            <div class="col-md-11">
                                <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                    <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
                </div>
            </div>
        </div>
    </div>



    <!-- <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script> -->
    <!-- <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js'></script> -->
    <!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script> -->
    <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.6/cropper.js"></script> -->
    <script>
        var $modal = $('.imagecrop');
        var image = document.getElementById('image');
        var cropper;
        $("body").on("change", ".imageUpload", function(e) {
            var files = e.target.files;
            var done = function(url) {
                image.src = url;
                $modal.modal('show');
            };
            var reader;
            var file;
            var url;
            if (files && files.length > 0) {
                file = files[0];
                if (URL) {
                    done(URL.createObjectURL(file));
                } else if (FileReader) {
                    reader = new FileReader();
                    reader.onload = function(e) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(file);
                }
            }
        });
        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 0,
                viewMode: 0,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
            cropper = null;
        });
        $("body").on("click", "#crop,#crop1", function() {
            canvas = cropper.getCroppedCanvas({
                width: 160,
                height: 160,
            });
            canvas.toBlob(function(blob) {
                url = URL.createObjectURL(blob);
                var reader = new FileReader();
                reader.readAsDataURL(blob);
                reader.onloadend = function() {
                    var base64data = reader.result;
                    $('#base64image').val(base64data);
                    // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                    $modal.modal('hide');
                }
            });
        })
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                let href = $(".breadcrumb-item.active a").attr("href");
                window.location = href;
            });
        });
    </script>
    <script language="text/Javascript">
        colorPicker.addEventListener("input", updateFirst, false);
        colorPicker.addEventListener("change", watchColorPicker, false);

        function watchColorPicker(event) {
            document.querySelectorAll("p").forEach((p) => {
                p.style.color = event.target.value;
            });
        }
    </script>
    <!--**********************************
                Content body end
            ***********************************-->
@endsection
