@extends('admin.layouts.default')
@section('content')

    <div class="portlet light bordered">
        <!-- add new and back button-->
        <div class="portlet-title">
            <div class="caption font-red-sunglo">
                <i class="icon-settings font-red-sunglo"></i>
                <span class="caption-subject bold uppercase"> {{ trans("messages.$modelName.table_heading_edit") }}</span>
            </div>
            <div class="actions">
                <div class="btn-group">
                    <a class="btn btn-sm green dropdown-toggle" href="{{ route($modelName . '.index', $type) }}">
                        {{ trans('messages.global.back') }}
                        <i class="fa fa-angle-left"></i>
                    </a>
                </div>
            </div>
        </div>
        <div class="portlet-body form">
            <form method="POST" action="{{ route("$modelName.update", ["$type", "$result->id"]) }}" class="mws-form">
                @csrf
                <div class="form-body">
                    <div class="mws-panel-body no-padding">
                        <div class="mws-form-inline">
                            <div class="mws-form-row">
                                <label for="value" class="mws-form-label">Value <span class="requireRed"> *
                                    </span></label>
                                <div class="mws-form-item">
                                    <input type="text" name="value" id="value" class="form-control" />
                                    <div class="error-message help-inline">
                                        <?php echo $errors->first('value'); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- button-->
                <div class="mws-button-row">
                    <div class="input">
                        <input type="submit" value="{{ trans('messages.global.save') }}" class="btn btn-danger">
                        <a href='{{ route("$modelName.edit", ["$type", "$result->id"]) }}' class="btn primary"><i
                                class=\"icon-refresh\"></i> {{ trans('messages.global.reset') }}</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

@stop
