@extends('admin.layouts.default')
@section('content')
 <!-- DATATABLE GLOBAL SCRIPTS -->
 <link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
 <script src="{{asset('assets/js/admin/datatable.js')}}"></script>
	<!-- DATATABLE GLOBAL SCRIPTS -->
<div class="portlet box green">
	<div class="portlet-title">
		<div class="caption">
			<i class="fa fa-globe"></i>{{ trans('messages.testsetting_index') }}</div>
		<div class="tools add-user">
			<a href="{{route('TextSetting.add',$type)}}">Add New</a>
		 </div>
	</div>
	<div class="portlet-body">
		<table class="table table-striped table-bordered table-hover" id="dataList">
			<thead>
				<tr>
					<th> S.No.</th>
					<th> Id</th>
					<th> {{ trans("messages.global.key") }} </th>
					<th> {{ trans("messages.global.value") }} </th>
					<th> {{ trans("messages.global.action") }} </th>
				</tr>
			</thead>
		</table>
	</div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
    	order: [1, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
        	url:"{{route($modelName.'.index',$type)}}",
        	type: "POST",
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'id', name: 'id'},
            {data: 'key_value', name: 'key_value'},
            {data: 'value', name: 'value'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });
});
</script>
@endsection
