@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
  {{ HTML::style('css/admin/datatable.css') }}
  {{ HTML::script("js/admin/datatable.js") }}
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Setting list</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <!-- <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="javascript:void(0)">Datatable</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Setting</a></li>
            </ol> -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4>Settings</h4>
                  <a href="{{route($modelName.'.smsadd')}}" class="btn btn-primary btn-sm"> Add New {{$modelName}}</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Key</th>
                                <th>Value</th>
                                <th>Created</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>Key</th>
                                <th>Value</th>
                                <th>Created</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--------------------End---------------------------->

<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      order: [0, 'desc'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.smsview')}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'setting_key', name: 'setting_key'},
            {data: 'value', name: 'value'},
            {data: 'created_at', name: 'created_at'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });

    $(document).on('click', '.action-setting', function () {
        if(!confirm("Are You Sure to delete this sms?"))
        event.preventDefault();
    });
    $(document).on('click', '.action-users', function () {
              if(!confirm("are you sure want to activate this sms?"))
              event.preventDefault();
    });
    $(document).on('click', '.action-userss', function () {
              if(!confirm("are you sure want to deactivate this Payout sms?"))
              event.preventDefault();
    });
});
</script>
@endsection
