@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>All Registered Users Wallet List</h4>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
              <li class="breadcrumb-item">Transaction Manager</li>
                <li class="breadcrumb-item">Invested Amount</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">

                    <h4>Invested Amount</h4>

                    <!-- <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-file-excel-o mr-2"></i> Download CSV</a></button>
                    <button class="btn btn-primary btn-sm" id="refresh_users_wallet">Refresh Data</button> -->
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>Sports</th>
                                <th>Series Name</th>
                                <th>Match Name</th>
                                <th>Date & Time</th>
                                <th>Match Status</th>

                                <th>Invested Amount</th>

                            </tr>
                            </thead>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
      var fieldname = '';
      var filtercolums = {

      }

      function cancelEvent(){
        event.stopPropagation();
      }

      var input_filter_teamname = '';


      function updateURL(event , fieldname){
        var value = event.target.value;

        if(fieldname == 'filter_teamname'){
          input_filter_teamname = value;
        }


        var url = window.location.href.split('?')[0];
        history.pushState('', '', url+"?filter=1&filter_teamname="+input_filter_teamname);

      }

      function filterData(event , fieldname){

        var value = event.target.value;
         updateURL(event,fieldname);

        if(fieldname == 'filter_teamname'){
          filtercolums['filter_teamname'] = value;
        }
        //URL UPDATE

        $('#dataList').DataTable().clear().destroy(); //clear table data Table

        $('#dataList').DataTable({
             order: [0, 'desc'],
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.investedamount')}}",
              type: "POST",
              data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums}
            },

            "columns": [
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'sports', name: 'sports'},
              {data: 'series_name', name: 'series_name'},
              {data: 'name', name: 'name'},
              {data: 'start_date', name: 'start_date'},
              {data: 'final_status', name: 'final_status'},
              {data: 'investedamount', name: 'investedamount'}
            ]
        });

        document.getElementById(fieldname).focus();
      }

</script>

<script type="text/javascript">
$(document).ready(function() {

    usersWalletData();

    $(document).on('click','#refresh_users_wallet', function(){
        $('#dataList').DataTable().clear().destroy();
        usersWalletData();
    });

    function usersWalletData(){
      let filter_teamname = '<?php echo @$_GET['filter_teamname']; ?>';
      let filter_email = '<?php echo @$_GET['filter_email']; ?>';
      let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';

      var filtercolums = {

      }
      // FOR SELECT Filtering
      if(filter_teamname !==''){
        filtercolums['filter_teamname'] = filter_teamname;
      }
      if(filter_email !==''){
        filtercolums['filter_email'] = filter_email;
      }
      if(filter_mobile !==''){
        filtercolums['filter_mobile'] = filter_mobile;
      }
      $('#dataList').DataTable().clear().destroy();

        $('#dataList').DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
              url:"{{route($modelName.'.investedamount')}}",
              type: "POST",
                  data : {"_token": "{{ csrf_token() }}" , "filter_columns":filtercolums }
            },
            "columns": [
              {data: 'DT_RowIndex', name: 'DT_RowIndex'},
              {data: 'sports', name: 'sports'},
              {data: 'series_name', name: 'series_name'},
              {data: 'name', name: 'name'},
              {data: 'start_date', name: 'start_date'},
              {data: 'final_status', name: 'final_status'},
              {data: 'investedamount', name: 'investedamount'}
            ]
        });

        return true;
    }


});
</script>
@endsection
