@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                        <h4>All Registered Users Wallet List</h4>
                    </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">Transaction Manager</li>
                    <li class="breadcrumb-item">Promotor Commission TDS Details</li>
                </ol>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4>Promotor Commission TDS Details</h4>
                        <!-- <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-file-excel-o mr-2"></i> Download CSV</a></button>
                            <button class="btn btn-primary btn-sm" id="refresh_users_wallet">Refresh Data</button> -->
                    </div>
                    <div class="card-body">

                        <div class="basic-form">
                            <form id="searchTdsForm"
                                action="{{ url('admin/transaction-manager/promotor_tds_details/' . $userId) }}"
                                method="GET">
                                @php
                                    $start_date = @$_GET['start_date'] != '' ? $_GET['start_date'] : '';
                                    $end_date = @$_GET['end_date'] != '' ? $_GET['end_date'] : '';
                                @endphp
                                <div class="form-row">

                                    <div class="form-group col-md-2 mb-0">
                                        <label>Start Date</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="start_date" id="start_date"
                                                class="pull-left form-control datetimepickerget w-100"
                                                value="{{ !empty($start_date) ? $start_date : date('Y-m-01 H:i:s') }}"
                                                autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-2 mb-0">
                                        <label>End Date</label>
                                        <div class="form-group col-md-6">
                                            <input type="text" name="end_date" id="end_date"
                                                class="pull-left form-control datetimepickerget w-100"
                                                value="{{ isset($end_date) && !empty($end_date) ? $end_date : date('Y-m-d H:i:s') }}"
                                                autocomplete="off">
                                        </div>
                                    </div>
                                    <div class="form-group py-4 px-4">
                                        <button type="submit" class="btn btn-primary mt-2">Get TDS Report</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="card-footer">
                            <form id="Downlode_TDSForm"
                                action="{{ url('admin/transaction-manager/promotor_tds_details/' . $userId) }}"
                                method="get">
                                <input type="hidden" name="start_date" id="download_start_date"
                                    value="{{ !empty($start_date) ? $start_date : date('Y-m-01') }}">
                                <input type="hidden" name="end_date" id="download_end_date"
                                    value="{{ !empty($end_date) ? $end_date : date('Y-m-d') }}">
                                <input type="hidden" name="download" value="download">
                                <button id="Downlode_TDSBtn" class="btn btn-primary gst-download">Download TDS Report
                                </button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="dataList" class="display" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <!-- <th>Sport Type</th>
                                            <th>Match Name</th>
                                            <th>Match Start Date</th> -->
                                        <!-- <th>Total Earn Commission</th> -->
                                        <th>Total Earn Amount</th>
                                        <th>Deducted TDS Amount</th>
                                        <th>Withdraw Amount</th>
                                        <th>TDS Date</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
            var start_date = $('#start_date').val();
            var end_date = $('#end_date').val();

            userid = "<?php echo $userId; ?>";
            $('#dataList').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: '<?php echo url()->asset('admin/transaction-manager/promotor_tds_details/' . $userId); ?>?start_date=' + start_date + '&end_date=' + end_date,
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "userid": userid
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    // {data: 'sport_type', name: 'sport_type'},
                    // {data: 'match_name', name: 'match_name'},
                    // {data: 'match_date', name: 'match_date'},
                    {
                        data: 'earn_comsn',
                        name: 'earn_comsn'
                    },
                    {
                        data: 'deducted_tds_amount',
                        name: 'deducted_tds_amount'
                    },
                    {
                        data: 'withdraw_amount',
                        name: 'withdraw_amount'
                    },
                    {
                        data: 'tds_date',
                        name: 'tds_date'
                    },
                ]
            });
            $(document).ready(function() {
                $('#end_date,#start_date').datetimepicker({
                    timepicker: true,
                    format: 'Y-m-d H:i:s',
                    closeOnDateSelect: false,
                });
            });

            $(document).on('click', '#Downlode_TDSBtn', function(event) {
                var start_date = $('#start_date').val();
                $('#download_start_date').val(start_date);
                var end_date = $('#end_date').val();
                $('#download_end_date').val(end_date);
                $("#Downlode_TDSForm").submit();
            });

            $(document).on('change', '#start_date', function() {
                let start_date = $(this).val().trim();
                let end_date = $('#end_date').val().trim();
                if (start_date > end_date) {
                    alert("Please Select Start Date before End Date ");
                    $(this).val(new Date());
                    return;
                }
            });
            $(document).on('change', '#end_date', function() {
                let end_date = $(this).val().trim();
                let start_date = $('#start_date').val().trim();
                if (start_date > end_date) {
                    alert("Please Select Start Date before End Date ");
                    $(this).val(new Date());
                    return;
                }
            });
        });
    </script>
@endsection
