@extends('admin.layouts.default')
@section('content')
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <link rel="stylesheet" href="{{ asset('assets/css/admin/datatable.css') }}" />
    <script src="{{ asset('assets/js/admin/datatable.js') }}"></script>
    <!-- DATATABLE GLOBAL SCRIPTS -->
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>All Registered Users Wallet List</h4>
                </div> -->
            </div>
            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">Transaction Manager</li>
                    <li class="breadcrumb-item">TDS Report</li>
                </ol>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">

                        <h4>TDS Report 2024-25</h4>
                        <!-- <div class="card-body d-flex justify-content-end">
                          <h6>Select User</h6>
                          <select class="form-control ml-3" style="width:50%" id="searchusers" name="searchusers">
                            <option>Select User</option>
                            @if (!empty($userslist))
    @foreach ($userslist as $value)
    <option value="{{ $value->u_id }}"> {{ $value->username }}</option>
    @endforeach
    @endif
                          </select>
                        </div>-->
                        <div class="basic-form">
                            <form action="{{ url('admin/transaction-manager/tds_report_new/') }}" method="GET"
                                id="searchTdsForm">
                                @php
                                    $start_date = @$_GET['start_date'] != '' ? $_GET['start_date'] : '';
                                    $end_date = @$_GET['end_date'] != '' ? $_GET['end_date'] : '';
                                @endphp
                                <div class="form-row">

                                    <div class="form-group col-md-4 mb-0">
                                        <label>Start Date</label>
                                        <div class="form-group col-md-6">
                                            <!-- <input type="text" name="start_date" id="start_date" class="pull-left form-control datetimepickerget w-100" value="{{ !empty($start_date) ? $start_date : date('Y-m-01 H:i:s') }}" autocomplete="off"> -->
                                            <input type="text" name="start_date" id="start_date"
                                                class="pull-left form-control datetimepickerget w-100"
                                                value="{{ !empty($start_date) ? $start_date : '' }}" autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="form-group col-md-4 mb-0">
                                        <label>End Date</label>
                                        <div class="form-group col-md-6">
                                            <!-- <input type="text" name="end_date" id="end_date" class="pull-left form-control datetimepickerget w-100" value="{{ isset($end_date) && !empty($end_date) ? $end_date : date('Y-m-d H:i:s') }}" autocomplete="off"> -->
                                            <input type="text" name="end_date" id="end_date"
                                                class="pull-left form-control datetimepickerget w-100"
                                                value="{{ isset($end_date) && !empty($end_date) ? $end_date : '' }}"
                                                autocomplete="off">
                                        </div>
                                    </div>
                                    <div class="form-group py-4 px-4">
                                        <button type="submit" class="btn btn-primary mt-2">Get TDS Report</button>
                                    </div>
                                </div>
                            </form>

                        </div>
                        <form id="Downlode_TDSForm" action="{{ route($modelName . '.tds_report_new') }}" method="get">
                            <input type="hidden" name="start_date" id="download_start_date"
                                value="{{ !empty($start_date) ? $start_date : date('Y-m-01') }}">
                            <input type="hidden" name="end_date" id="download_end_date"
                                value="{{ !empty($end_date) ? $end_date : date('Y-m-d') }}">
                            <input type="hidden" name="download" value="download">
                            <button id="Downlode_TDSBtn" class="btn btn-primary gst-download">Download TDS Summery Reports
                            </button>
                        </form>
                        <!-- <form id="Downlode_TDSForm" action="{{ route($modelName . '.tds_report_new') }}" method="get">
                              <input type="hidden" name="download" value="download">
                              <button id="Downlode_TDSBtn" class="btn btn-primary gst-download">Download All Users TDS
                              </button>
                          </form> -->
                        <form id="Downlode_TDSUsersForm" action="{{ route($modelName . '.tds_report_new') }}" method="get">
                            <input type="hidden" name="start_date" id="download_start_date"
                                value="{{ !empty($start_date) ? $start_date : date('Y-m-01') }}">
                            <input type="hidden" name="end_date" id="download_end_date"
                                value="{{ !empty($end_date) ? $end_date : date('Y-m-d') }}">
                            <input type="hidden" name="download_all_users_tds" value="download_all_users_tds">
                            <button id="Downlode_TDSUsersBtn" class="btn btn-success gst-download">Download All Users TDS
                                Reports
                            </button>
                        </form>
                        <!-- <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-file-excel-o mr-2"></i> Download CSV</a></button>
                        <button class="btn btn-primary btn-sm" id="refresh_users_wallet">Refresh Data</button> -->
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="dataList" class="display" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>S No.</th>
                                        <th>Name
                                            <input style="margin-top:5px" type="text" id="filter_name"
                                                name="filter_name" value="<?php echo @$_GET['filter_name']; ?>" onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_name')" autocomplete="off">
                                        </th>
                                        <!-- <th>Email
                                    <input style="margin-top:5px" type="text" id="filter_email" name="filter_email" value="<?php echo @$_GET['filter_email']; ?>" onclick="cancelEvent()" onkeyup="filterData(event , 'filter_email')" autocomplete="off">
                                    </th> -->
                                        <th>Mobile
                                            <input style="margin-top:5px" type="text" id="filter_mobile"
                                                name="filter_mobile" value="<?php echo @$_GET['filter_mobile']; ?>" onclick="cancelEvent()"
                                                onkeyup="filterData(event , 'filter_mobile')" autocomplete="off">
                                        </th>
                                        <th>PAN</th>
                                        <th>STATE</th>
                                        <!-- <th>Opening bal</th> -->
                                        <th>Deposit</th>
                                        <!-- <th>Investment</th> -->
                                        <th>Withdraw</th>
                                        <th>TDS</th>
                                        <th>Refunded TDS Amount</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        var fieldname = '';
        var filtercolums = {
            'filter_name': '',
            'filter_email': '',
            'filter_mobile': '',
        }
        var start_date = $('#start_date').val();
        var end_date = $('#end_date').val();

        function cancelEvent() {
            event.stopPropagation();
        }

        var input_filter_teamname = '';


        function updateURL(event, fieldname) {
            var value = event.target.value;

            if (fieldname == 'filter_name') {
                input_filter_name = value;
            }


            var url = window.location.href.split('?')[0];
            history.pushState('', '', url + "?filter=1&filter_name=" + filtercolums['filter_name'] + "&filter_email=" +
                filtercolums['filter_email'] + "&filter_mobile=" +
                filtercolums['filter_mobile']);

        }

        var url = window.location.href.split('?')[0];
        history.pushState('', '', url + "?filter=1&filter_name=" + filtercolums['filter_name'] + "&filter_email=" +
            filtercolums['filter_email'] + "&filter_mobile=" +
            filtercolums['filter_mobile']);

        function filterData(event, fieldname) {

            var value = event.target.value;
            updateURL(event, fieldname);

            if (fieldname == 'filter_name') {
                filtercolums['filter_name'] = value;
            }
            if (fieldname == 'filter_email') {
                filtercolums['filter_email'] = value;
            }
            if (fieldname == 'filter_mobile') {
                filtercolums['filter_mobile'] = value;
            }
            //URL UPDATE

            $('#dataList').DataTable().clear().destroy(); //clear table data Table

            $('#dataList').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    url: "{{ route($modelName . '.tds_report_new') }}?start_date=" + start_date + "&end_date=" +
                        end_date,
                    type: "POST",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "filter_columns": filtercolums
                    }
                },
                "columns": [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    // {data: 'email', name: 'email'},
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'pan_number',
                        name: 'pan_number'
                    },
                    {
                        data: 'state',
                        name: 'state'
                    },
                    //  {data: 'open_blnc', name: 'open_blnc'},
                    {
                        data: 'deposit',
                        name: 'deposit'
                    },
                    // {data: 'investment', name: 'investment'},
                    {
                        data: 'withdraw',
                        name: 'withdraw'
                    },
                    {
                        data: 'tds',
                        name: 'tds'
                    },
                    {
                        data: 'refund_tds',
                        name: 'refund_tds'
                    },
                    {
                        data: 'action',
                        name: 'action'
                    },
                ]
            });
            document.getElementById(fieldname).focus();
        }
    </script>

    <script type="text/javascript">
        $(document).ready(function() {

            $(document).on('change', '#searchusers', function() {
                let userid = $(this).val();
                if (userid == '')
                    return false;
                $('#dataList').DataTable().clear().destroy();
                usersWalletData(userid);

            });
            usersWalletData();

            $(document).on('click', '#refresh_users_wallet', function() {
                $('#dataList').DataTable().clear().destroy();
                usersWalletData();
            });

            function usersWalletData(userid) {
                let filter_name = '<?php echo @$_GET['filter_name']; ?>';
                let filter_email = '<?php echo @$_GET['filter_email']; ?>';
                let filter_mobile = '<?php echo @$_GET['filter_mobile']; ?>';
                var start_date = $('#start_date').val();
                var end_date = $('#end_date').val();
                var filtercolums = {

                }
                // FOR SELECT Filtering
                if (filter_name !== '') {
                    filtercolums['filter_name'] = filter_name;
                }
                if (filter_email !== '') {
                    filtercolums['filter_email'] = filter_email;
                }
                if (filter_mobile !== '') {
                    filtercolums['filter_mobile'] = filter_mobile;
                }
                $('#dataList').DataTable().clear().destroy();

                $('#dataList').DataTable({
                    "processing": true,
                    "serverSide": true,
                    "ajax": {
                        url: "{{ route($modelName . '.tds_report_new') }}?start_date=" + start_date +
                            "&end_date=" + end_date,
                        type: "POST",
                        data: {
                            "_token": "{{ csrf_token() }}",
                            "filter_columns": filtercolums,
                            "user_id": userid
                        }
                    },
                    "columns": [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        //   {data: 'email', name: 'email'},
                        {
                            data: 'mobile',
                            name: 'mobile'
                        },
                        {
                            data: 'pan_number',
                            name: 'pan_number'
                        },
                        {
                            data: 'state',
                            name: 'state'
                        },
                        //{data: 'open_blnc', name: 'open_blnc'},
                        {
                            data: 'deposit',
                            name: 'deposit'
                        },
                        //  {data: 'investment', name: 'investment'},
                        {
                            data: 'withdraw',
                            name: 'withdraw'
                        },
                        {
                            data: 'tds',
                            name: 'tds'
                        },
                        {
                            data: 'refund_tds',
                            name: 'refund_tds'
                        },
                        {
                            data: 'action',
                            name: 'action'
                        },
                    ]
                });

                return true;
            }
            $(document).on('click', '#Downlode_TDSBtn', function(event) {
                $("#Downlode_TDSForm").submit();
            });
            $(document).on('click', '#Downlode_TDSUsersBtn', function(event) {
                $("#Downlode_TDSUsersForm").submit();
            });
            $(document).ready(function() {
                $('#end_date,#start_date').datetimepicker({
                    timepicker: true,
                    format: 'Y-m-d H:i:s',
                    closeOnDateSelect: false,
                });
            });

            // $(document).on('click', '#Downlode_TDSBtn', function(event){
            //     $( "#Downlode_TDSForm" ).submit();
            // });
            $(document).on('click', '#Downlode_TDSBtn', function(event) {
                var start_date = $('#start_date').val();
                $('#download_start_date').val(start_date);
                var end_date = $('#end_date').val();
                $('#download_end_date').val(end_date);
                $("#Downlode_TDSForm").submit();
            });
            $(document).on('click', '#Downlode_TDSUsersBtn', function(event) {
                var start_date = $('#start_date').val();
                $('#download_start_date').val(start_date);
                var end_date = $('#end_date').val();
                $('#download_end_date').val(end_date);
                $("#Downlode_TDSUsersForm").submit();
            });

            // $(document).on('change','#start_date', function(){
            //   let start_date = $(this).val().trim();
            //   let end_date = $('#end_date').val().trim();
            //   if(start_date >end_date){
            //     alert("Please Select Start Date before End Date ");
            //     $(this).val(new Date());
            //     return;
            //   }
            // });
            $(document).on('change', '#end_date', function() {
                let end_date = $(this).val().trim();
                let start_date = $('#start_date').val().trim();
                if (start_date > end_date) {
                    alert("Please Select Start Date before End Date ");
                    $(this).val(new Date());
                    return;
                }
            });

        });
    </script>
@endsection
