@extends('admin.layouts.default')
@section('content')
<script type="text/javascript">
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!--********************************** Content body start  ***********************************-->
<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <!-- <div class="welcome-text">
                <h4>Edit Youtuber</h4>
                <span class="ml-1">Layout</span>
            </div> -->
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                    <a href="{{route($modelName.'.view')}}">View all Promoters</a></li>
                <li class="breadcrumb-item">Edit Promoter</li>
            </ol>
        </div>
    </div>
    <!-- row -->
    <div class="row">
        <div class="col-xl-12 col-xxl-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                    <h4 class="card-title">Edit Promoter</h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{route($modelName.'.edit',base64_encode(serialize($user->id)))}}" id="EditUserForm" enctype="multipart/form-data"
                            @csrf
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Username</label>
                                    <input id="username" type="text" placeholder="enter username here" name="username" class="form-control in_text" value="{{$user->username}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('username'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Mobile</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter mobile no here" id="mobile" name="mobile" type="text" value="{{$user->mobile}}">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('mobile'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Email</label>
                                    <input id="email" type="text" placeholder="enter email here" name="email" class="form-control in_text" value="{{$user->email}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('email'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Gender</label>
                                    <div class="form-group row">
                                        <label class="radio-inline col-md py-2 pl-0">
                                            <input type="radio" name="gender" class="mr-2" value="male" <?php if($user->gender=='male') { echo'checked'; } ?> >Male</label>
                                        <label class="radio-inline col-md py-2">
                                            <input type="radio" name="gender" class="mr-2" value="female" <?php if($user->gender=='female') { echo'checked'; } ?> > Female</label>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('gender'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Image</label>
                                    <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="image[]" class=" imageUpload form-control in_text" />
                                    <input type="hidden" name="base64image" name="base64image" id="base64image">
                                    <label for="imageUpload"></label>
                                    <!-- <input type="file" class="form-control in_text" name="image[]" autocomplete="off"> -->
                                    @if($user->image!='')
                                    <img src="{{url()->asset('uploads/user/'.$user->image)}}" style='width:100px;height:100px;' class="my-2">
                                    @else
                                        <img src="{{url()->asset('images/logo.png')}}" style='width:100px;height:100px;' class="my-2">
                                    @endif
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('image'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Country</label>
                                    <input id="country" type="text" placeholder="enter country here" name="country" class="form-control in_text" value="{{$user->country}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('country'); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                 <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">States</label>
                                    <select class="form-control in_text" id="state" name="state" autocomplete="off">
                                        <option value=""> Select states </option>
                                        @if(isset($states) && !empty($states))
                                        @foreach($states as $statesval)
                                        <option value="<?php echo $statesval->name ?>" <?php if($statesval->name == $user->state) { echo "selected"; }?> >
                                        {{$statesval->name}}
                                        </option>
                                        @endforeach
                                        @endif
                                    </select>
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('state'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">City</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter city here" id="city" name="city" type="text" value="{{$user->city}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('city'); ?>
                                    </div>
                                </div>
                            </div>
                             <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">DOB</label>
                                    <input class="form-control datetimepickerget in_text" autocomplete="off" placeholder="enter dob here" id="dob" name="dob" type="text" value="{{date('Y-m-d',strtotime($user->city))}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('dob'); ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Team</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter team name here" id="team" name="team" type="text" value="{{$user->team}}">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('team'); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Promoter Commission Type</label>
                                    <div class="form-group row">
                                        <label class="radio-inline col-md py-2 pl-0">
                                            <input type="radio" name="youtuber_commission_type" class="mr-2" value="0" <?php if($user->youtuber_commission_type=='0') { echo'checked'; } ?>>Revenue Amount</label>
                                        <label class="radio-inline col-md py-2 pl-0">
                                            <input type="radio" name="youtuber_commission_type" class="mr-2" value="1" <?php if($user->youtuber_commission_type=='1') { echo'checked'; } ?>>Flat Amount</label>
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('youtuber_commission_type'); ?>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="form-group col-md-6">
                                    <label class="lbl_frm py-2">Promoter Commission</label>
                                    <input class="form-control in_text" autocomplete="off" placeholder="enter Youtuber Commission name here" id="youtuber_commission" name="youtuber_commission" type="text" value="{{$user->youtuber_commission}}" autocomplete="off">
                                     <div class="error-message help-inline">
                                      <?php echo $errors->first('youtuber_commission'); ?>
                                    </div>
                                </div> -->
                               <div class="form-group col-md-6">
                                   <label class="lbl_frm py-2">Promoter Commission</label>
                                   <input class="form-control in_text" autocomplete="off" placeholder="enter Youtuber Commission name here" id="youtuber_commission" name="player_percentage" type="text" value="{{$user->player_percentage}}" autocomplete="off">
                                    <div class="error-message help-inline">
                                     <?php echo $errors->first('player_percentage'); ?>
                                   </div>
                               </div>
                            </div>

                            <button type="submit" class="btn btn-primary mr-2">Submit</button>
                            <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade bd-example-modal-lg imagecrop" id="model" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <!-- <span aria-hidden="true">&times;</span> -->
                </button>
            </div>
            <div class="modal-body">
                <div class="img-container">
                    <div class="row">
                        <div class="col-md-11">
                            <img id="image" src="https://avatars0.githubusercontent.com/u/3456749">
                        </div>
                    </div>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" id="crop1">Close</button>
                <button type="button" class="btn btn-primary crop" id="crop">Crop</button>
              </div>
          </div>
        </div>
      </div>
                <script>
                    var $modal = $('.imagecrop');
                    var image = document.getElementById('image');
                    var cropper;
                    $("body").on("change", ".imageUpload", function(e){
                        var files = e.target.files;
                        var done = function(url) {
                            image.src = url;
                            $modal.modal('show');
                        };
                        var reader;
                        var file;
                        var url;
                        if (files && files.length > 0) {
                            file = files[0];
                            if (URL) {
                                done(URL.createObjectURL(file));
                            } else if (FileReader) {
                                reader = new FileReader();
                                reader.onload = function(e) {
                                    done(reader.result);
                                };
                                reader.readAsDataURL(file);
                            }
                        }
                    });
                    $modal.on('shown.bs.modal', function() {
                        cropper = new Cropper(image, {
                            aspectRatio: 0,
                            viewMode: 0,
                        });
                    }).on('hidden.bs.modal', function() {
                        cropper.destroy();
                        cropper = null;
                    });
                    $("body").on("click", "#crop,#crop1", function() {
                        canvas = cropper.getCroppedCanvas({
                            width: 160,
                            height: 160,
                        });
                        canvas.toBlob(function(blob) {
                            url = URL.createObjectURL(blob);
                            var reader = new FileReader();
                            reader.readAsDataURL(blob);
                            reader.onloadend = function() {
                                 var base64data = reader.result;
                                 $('#base64image').val(base64data);
                                 // document.getElementById('imagePreview').style.backgroundImage = "url("+base64data+")";
                                 $modal.modal('hide');
                            }
                        });
                    })

                </script>
<script type="text/javascript">
    $(document).ready(function(){
        $(document).on("click","#cancel_btn", function(){
            let href = $(".breadcrumb-item.active a").attr("href");
            window.location = href;
        });
        $('#dob').datetimepicker({
            timepicker: false,
            format:'Y-m-d'
        });
    });
</script>
<!--**********************************
Content body end
***********************************-->
@endsection
