@extends('admin.layouts.default')
@section('content')
<!-- DATATABLE GLOBAL SCRIPTS -->
<link rel="stylesheet" href="{{asset('assets/css/admin/datatable.css')}}" />
<script src="{{asset('assets/js/admin/datatable.js')}}"></script>
<!-- DATATABLE GLOBAL SCRIPTS -->
<script>
  $(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
  });
</script>

<div class="container-fluid">
    <div class="row page-titles mx-0" data-aos="fade-up">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4>Youtuber Users Chalange List</h4>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
            <ol class="breadcrumb">
                <li class="breadcrumb-item active">
                  <a href="javascript:void(0)">Youtuber Users Chalange List</a></li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card" data-aos="fade-up">
                <div class="card-header">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataList" class="display" style="min-width: 845px">
                            <thead>
                                <tr>
                                <th>S No.</th>
                                <th>ID</th>
                                <th>Entry Fee</th>
                                <th>Win Amount</th>
                                <th>Maximum User</th>
                                <th>Minimum User</th>
                                <th>Challenge Type</th>
                            </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                <th>S No.</th>
                                <th>ID</th>
                                <th>Entry Fee</th>
                                <th>Win Amount</th>
                                <th>Maximum User</th>
                                <th>Minimum User</th>
                                <th>Challenge Type</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@php
$id=base64_encode(serialize($id));
@endphp
<!---Show Ajax---------->
<script type="text/javascript">
$(document).ready(function() {
    $('#dataList').DataTable({
      //order: [1, 'DESC'],
        "processing": true,
        "serverSide": true,
        "ajax":{
          url:"{{route($modelName.'.user_chalange',$id)}}",
          type: "POST",
          data : {"_token": "{{ csrf_token() }}"}
        },
        "columns": [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'id', name: 'id'},
            {data: 'entryfee', name: 'entryfee'},
            {data: 'win_amount', name: 'win_amount'},
            {data: 'maximum_user', name: 'maximum_user'},
            {data: 'minimum_user', name: 'minimum_user'},
            {data: 'challenge_type', name: 'challenge_type'},
        ]
    });
});
</script>

@endsection
