@extends('admin.layouts.default')
@section('content')
    <script>
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
    <link rel="stylesheet" href="{{ asset('assets/css/admin/lightbox.css') }}" />
    <script src="{{ asset('assets/js/admin/lightbox.js') }}"></script>

    <div class="container-fluid">
        <div class="row page-titles mx-0" data-aos="fade-up">
            <div class="col-sm-6 p-md-0">
                <!-- <div class="welcome-text">
                    <h4>Change Password</h4>
                    <span class="ml-1">Layout</span>
                </div> -->
            </div>

            <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin_dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item">Change Password</li>
                </ol>
            </div>
        </div>
        <!-- row -->
        <div class="row">
            <div class="col-xl-12 col-xxl-12">
                <div class="card" data-aos="fade-up">
                    <div class="card-header">
                        <h4 class="card-title">Change Password</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="userUpdatePasswordForm" action="{{ route('myprofile.profile_change_password') }}"
                                method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <label>Password</label>
                                        <input id="password" type="password" placeholder="enter password here"
                                            name="password" class="form-control w-95" autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('password'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>New Password</label>
                                        <input class="form-control w-95" placeholder="enter new password here"
                                            id="n_password" name="n_password" type="password" autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('n_password'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Confirm Password</label>
                                        <input id="c_password" type="password" placeholder="enter confirm password here"
                                            name="c_password" class="form-control w-95" autocomplete="off">
                                        <div class="error-message help-inline">
                                            <?php echo $errors->first('c_password'); ?>
                                        </div>
                                    </div>
                                </div>
                                <input class="form-control" name="id" id="id" type="hidden"
                                    value="{{ session()->get('id') }}">
                                <div class="py-2">
                                    <button type="submit" class="btn btn-primary mr-2">Submit</button>
                                    <button class="btn btn-gray" type="button" id="cancel_btn">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!----------->
    <script type="text/javascript">
        $(document).ready(function() {
            $(document).on("click", "#cancel_btn", function() {
                window.location = "{{ route('admin_dashboard') }}";
            });
        });
    </script>
@endsection
