<!DOCTYPE html>
<html lang="en" class="h-100">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo env("APP_NAME") ?></title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset("assets/images/favicon.png")}}">
    <link rel="stylesheet" type="text/css" href="http://dev.rglabs.net/fc_admin/css/style.css">
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}" />

</head>

<body class="h-100">
    <div class="authincation h-100">
        <div class="container h-100">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-10">
                    <div class="authincation-content">
                        <div class="row no-gutters">
                            <div class="col-xl-6">
                                <div class="welcome-content">
                                    <div class="brand-logo login">
                                        <a href="index.html"><?php echo env("APP_NAME") ?> Admin</a>

                                    <h3 class="welcome-title">Welcome to <?php echo env("APP_NAME") ?> Fantasy Sports Admin.</h3></div>
                                    <div class="intro-social">
                                        <ul>
                                            <li><a href="<?php echo BRAND['facebook']; ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                            <li><a href="<?php echo BRAND['instagram']; ?>" target="_blank" ><i class="fa fa-instagram"></i></a></li>
                                            <li><a href="<?php echo BRAND['telegram']; ?>" target="_blank" ><i class="fa fa-telegram"></i></a></li>
                                            <li><a href="<?php echo BRAND['twitter']; ?>" target="_blank" ><i class="fa fa-twitter"></i></a></li>
                                            <li><a href="<?php echo BRAND['youtube']; ?>" target="_blank" ><i class="fa fa-youtube"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                          <!-- BEGIN LOGIN -->
                            <div class="col-xl-6 position-relative">
                                @if(session()->has('error'))
                                    <p class="alert {{ session()->get('alert-class', 'alert-danger') }}">{{ session()->get('error') }}</p>
                                  @endif
                                  @if(session()->has('success'))
                                    <p class="alert {{ session()->get('alert-class', 'alert-success') }}">{{ session()->get('success') }}</p>
                                  @endif
                                  @if(session()->has('flash_notice'))
                                    <p class="alert {{ session()->get('alert-class', 'alert-success') }}">{{ session()->get('flash_notice') }}</p>
                                  @endif
                                  <div class="auth-form">
                                    <div class="form_title"><h3 class="text-center">Sign in<!-- your account --></h3><p class="h4 text-center mb-5">to continue to <?php echo env("APP_NAME"); ?> Admin</p></div>
                                     @yield('content')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<script
  src="https://code.jquery.com/jquery-3.7.1.js"
  integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
  crossorigin="anonymous"></script>
<script src="{{asset('assets/global/plugins/jquery-validation/js/jquery.validate.min.js')}}" ></script>
<script src="{{asset('assets/global/plugins/jquery-validation/js/additional-methods.min.js')}}" ></script>
<script src="{{asset('assets/global/plugins/select2/js/select2.full.min.js')}}" ></script>
<!-- END PAGE LEVEL PLUGINS -->
        <script>
            $(document).ready(function()
            {
                $('#clickmewow').click(function()
                {
                    $('#radio1003').attr('checked', 'checked');
                });
            })
        </script>
    </body>
</html>
