@extends('layouts.default')
@section('content')
<!--==========================
  Home Banner Section
============================-->
<section id="home_banner" class="home_banner bg-theme" style="background-image: url({{WEBSITE_URL}}images/bannar/home-banner-01.jpg);">
  <div class="container">
    <div class="row">

      <div class="col-12 text-center">

        <div class="video-card mb-3">
          <a href="#" class="video-btn" data-toggle="modal" data-src="https://www.youtube.com/embed/Jfrjeg26Cwk" data-target="#videoModal">
            <span class="play_btn"><i class="fa fa-play"></i></span>
          </a>

          <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        <!-- 16:9 aspect ratio -->
                        <div class="embed-responsive embed-responsive-16by9">
                            <iframe class="embed-responsive-item" id="video" allowscriptaccess="always" autoplay="1" allow="autoplay"></iframe>
                        </div>
                    </div>
                </div>
            </div>
          </div><!-- Modal -->
        </div><!-- end of video -->

        <div class="home_banner_content body_content">
          <h1>ALL NATURAL FOODS</h1>
          <p>Perfect reward of freshly baked premium treats.</p>
        </div>

      </div>

    </div>
  </div>
</section><!-- #home_banner -->

<main id="main">

  <!--==========================
    Quick View Modal
  ============================-->
  <!-- The Modal -->
  <div class="modal fade view_product_detail_modal" id="viewProduct_modal">
    <div class="modal-dialog modal-dialog-centered modal-lg">
      <div class="modal-content">

        <button type="button" class="close" data-dismiss="modal"><i class="fas fa-times"></i></button>

        <!-- Modal body -->
        <div class="modal-body row no-gutters">

          <div class="col-md-6 col-12 modal-body-left">
            <div class="slider slider-for product_modal_slider_for">
              <div><img src="images/product/product-01.jpg" alt="" /></div>
              <div><img src="images/product/product-02.jpg" alt="" /></div>
              <div><img src="images/product/product-03.jpg" alt="" /></div>
            </div>
            <div class="slider slider-nav product_modal_slider_nav">
              <div><img src="images/product/product-01.jpg" alt="" /></div>
              <div><img src="images/product/product-02.jpg" alt="" /></div>
              <div><img src="images/product/product-03.jpg" alt="" /></div>
            </div>
          </div>

          <div class="col-md-6 col-12 modal-body-right">

            <div class="product_view_detail_content text-center">

              <h3>Kibbles’n Bits mini bites</h3>
              <h6 class="mb-3">Kibbles</h6>
              <div class="rating">
                <div class="starrr ratable d-inline-block">
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star"></i>
                  <i class="fas fa-star-half-alt"></i>
                  <i class="far fa-star"></i>
                </div>
                <h6 class="count d-inline-block">3.5 (12 Reviews)</h6>
              </div>
              <div class="price_block">
                <div class="price"><i class="fas fa-rupee-sign"></i>350</div>
              </div>
              <div id="sizes" class="sizes mt-3">
                <label class="d-inline-block">Size</label>
                <ul class="list-unstyled d-inline-block">
                  <li data-size="3kgs" class="active">3 Kgs</li>
                  <li data-size="12kgs">12 Kgs</li>
                </ul>
              </div>
              <div class="product-quantity">
                <label for="product-quantity-input" class="product-quantity-label d-inline-block">Quantity</label>
                <div class="quantity buttons_added">
                  <input type="button" value="-" class="minus">
                  <input type="number" step="1" min="1" max="" name="quantity" value="2" title="Qty" class="input-text qty text" size="4" pattern="" inputmode="">
                  <input type="button" value="+" class="plus">
                </div>
              </div>

              <div class="total_price_block mt-3">
                <label class="d-inline-block">Total</label>
                <div class="price d-inline-block"><i class="fas fa-rupee-sign"></i>700</div>
              </div>
              <div class="product-checkout-actions mt-3">
                <a href="#" class="btn bg rounded add_cart_btn btn">Add to Cart</a>
              </div>

            </div>

          </div>

        </div>

      </div>
    </div>
  </div> <!-- Quick View Modal -->


  <!--==========================
    Product Toys Section
  ============================-->
  <section id="product_area" class="product_area pt-100">
    <div class="container">
      <div class="row">

        <div class="col-12 mb-3 text-center">
          <h2 class="product_section_title"><span>Toys</span></h2>
        </div>

        <div class="col-12">

          <div class="owl-carousel owl-theme product-carousel">

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-01.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Apple Cinder Donuts</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>

              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-02.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>235</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-03.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-04.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>310</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-05.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>350</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

          </div><!-- product-carousel -->

        </div>

         <div class="col-12 view_all_block">
          <div class="view_all_area text-right">
            <a href="#" class="view_btn">View All <i class="fas fa-chevron-right"></i></a>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!--==========================
    Natural Section
  ============================-->
  <section id="natural" class="natural pt-100">
    <div class="container">
      <div class="w-75 m-auto">
        <div class="row align-items-center">

          <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.2s">
            <div class="natural_theme">
              <img src="images/natural_theme-01.jpg" alt=""/>
            </div>
          </div>

          <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.2s">
            <div class="natural_content">
              <h2 class="title mb-3">100% natural, gluten free</h2>
              <p>onsectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip</p>
            </div>
          </div>

        </div>
      </div>
    </div>
  </section><!-- natural -->

  <!--==========================
    Product Treats Section
  ============================-->
  <section id="product_area" class="product_area pt-100">
    <div class="container">
      <div class="row">

        <div class="col-12 mb-3 text-center wow fadeInUp" data-wow-delay="0.2s">
          <h2 class="product_section_title"><span>Treats</span></h2>
        </div>

        <div class="col-12">

          <div class="owl-carousel owl-theme product-carousel">

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-01.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Apple Cinder Donuts</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-02.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>235</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-03.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-04.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>310</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-05.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>350</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

          </div><!-- product-carousel -->

        </div>

         <div class="col-12 view_all_block">
          <div class="view_all_area text-right">
            <a href="#" class="view_btn">View All <i class="fas fa-chevron-right"></i></a>
          </div>
        </div>

      </div>
    </div>
  </section>


  <!--==========================
    Product Food Section
  ============================-->
  <section id="product_area" class="product_area pt-100">
    <div class="container">
      <div class="row">

        <div class="col-12 mb-3 text-center wow fadeInUp" data-wow-delay="0.2s">
          <h2 class="product_section_title"><span>Food</span></h2>
        </div>

        <div class="col-12">

          <div class="owl-carousel owl-theme product-carousel">

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-01.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Apple Cinder Donuts</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-02.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>235</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-03.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-04.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>310</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-05.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>350</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

          </div><!-- product-carousel -->

        </div>

         <div class="col-12 view_all_block">
          <div class="view_all_area text-right">
            <a href="#" class="view_btn">View All <i class="fas fa-chevron-right"></i></a>
          </div>
        </div>

      </div>
    </div>
  </section>


  <!--==========================
    Product Birthday Dog & More Section
  ============================-->
  <section id="product_area" class="product_area pt-100">
    <div class="container">
      <div class="row">

        <div class="col-12 mb-3 text-center wow fadeInUp" data-wow-delay="0.2s">
          <h2 class="product_section_title"><span>Birthday Dog & More</span></h2>
        </div>

        <div class="col-12">

          <div class="owl-carousel owl-theme product-carousel">

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-01.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Apple Cinder Donuts</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-02.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>235</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-03.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>210</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-04.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>310</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/product-toys-05.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>Ballistic Crakler</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>350</div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

          </div><!-- product-carousel -->

        </div>

         <div class="col-12 view_all_block">
          <div class="view_all_area text-right">
            <a href="#" class="view_btn">View All <i class="fas fa-chevron-right"></i></a>
          </div>
        </div>

      </div>
    </div>
  </section>


  <!--==========================
    Product Barkbutler boxes Section
  ============================-->
  <section id="product_area" class="product_area pt-100">
    <div class="container">
      <div class="row">

        <div class="col-12 mb-3 text-center wow fadeInUp" data-wow-delay="0.2s">
          <h2 class="product_section_title"><span>Barkbutler boxes</span></h2>
        </div>

        <div class="col-12">

          <div class="owl-carousel owl-theme special-product-carousel">

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/special_product-01.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>The Toy Box</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>549 <span class="off">(Save 10%)</span></div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/special_product-02.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>The Toy & Treat Box</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>1699 <span class="off">(Save 20%)</span></div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <div class="product">
                <div class="product_thumbnail text-center">
                  <a href="#">
                    <img src="images/product/special_product-03.jpg" alt="" />
                  </a>
                </div>
                <div class="product_content text-center">
                  <a href="#" class="product_title"><h3>The Treat Box</h3></a>
                  <div class="price"><i class="fas fa-rupee-sign"></i>950 <span class="off">(Save 5%)</span></div>
                </div>
                <div class="responsive_dropdown"><i class="fas fa-ellipsis-h"></i></div>
                <div class="view_cart_block text-center">
                  <ul class="list-unstyled m-0">
                    <li><a href="#" data-toggle="modal" data-target="#viewProduct_modal" class="quick_view_btn btn">Quick View</a></li>
                    <li><a href="#" class="add_cart_btn btn">Add to Cart</a></li>
                  </ul>
                </div>
              </div>
            </div><!-- item -->

          </div><!-- product-carousel -->

        </div>

      </div>
    </div>
  </section>


  <!--==========================
    Subscribe Section
  ============================-->
  <section id="subscribe" class="subscribe_area bg-theme mt-100  wow fadeInUp" data-wow-delay="0.2s" style="background-image: url(images/subscribe-bg-theme-01.jpg);">
    <div class="container">
      <div class="row">

        <div class="col-12 m-auto w-500 text-center wow fadeInUp" data-wow-delay="0.2s">

          <div class="subscribe body_content">
            <h2 class="title text-white">Oh! Don’t Miss it!</h2>
            <p class="text-white">Subscribe to Get Exciting Offers</p>
          </div>

          <div class="subscribe_form_block pt-3">
            <form action="" method="post" role="form" class="subscribe_form">
              <div class="form-row">
                <div class="form-group col-md-12 m-0">
                  <input type="email" class="form-control" name="email" id="email" placeholder="Your Email" data-rule="email" data-msg="Please enter a valid email">
                  <button type="submit">Sign Up</button>
                </div>
              </div>
            </form>
          </div>

        </div>

      </div>
    </div>
  </section>


  <!--==========================
    Clients Section
  ============================-->
  <section id="clients" class="clients wow fadeInUp mt-5">
    <div class="container">
      <div class="row row-eq-height m-0">

        <div class="clients_item">
          <img src="images/clients/client-01.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-02.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-03.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-04.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-05.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-06.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-07.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-08.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-09.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-10.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-11.jpg" alt="" />
        </div>
        <div class="clients_item">
          <img src="images/clients/client-12.jpg" alt="" />
        </div>

      </div>

    </div>
  </section><!-- #clients -->


  <!--==========================
    Portfolio Section
  ============================-->
  <section id="portfolio" class="portfolio wow fadeInUp mt-100 pb-5">
    <div class="container">
      <div class="row">

        <div class="col-12">
          <div class="owl-carousel owl-theme portfolio-carousel">
            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <figure>
                <img src="images/portfolio-theme-01.jpg" alt="" />
              </figure>
            </div>
            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <figure>
                <img src="images/portfolio-theme-02.jpg" alt="" />
              </figure>
            </div>
            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <figure>
                <img src="images/portfolio-theme-03.jpg" alt="" />
              </figure>
            </div>
            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <figure>
                <img src="images/portfolio-theme-04.jpg" alt="" />
              </figure>
            </div>
            <div class="item wow fadeInUp" data-wow-delay="0.2s">
              <figure>
                <img src="images/portfolio-theme-05.jpg" alt="" />
              </figure>
            </div>
          </div>
        </div>

      </div>

    </div>
  </section><!-- #Portfolio -->


  <!--==========================
    Social Links Section
  ============================-->
  <section id="social_links_area" class="social_links_area wow fadeInUp mt-5">
    <div class="container">
      <div class="row">

        <div class="col-12 text-center">
          <div class="social-links">
            <ul class="list-unstyled m-0">
              <li>
                <a href="#"><i class="fab fa-facebook-f"></i></a>
              </li>
              <li>
                <a href="#"><i class="fab fa-twitter"></i></a>
              </li>
              <li>
                <a href="#"><i class="far fa-envelope"></i></a>
              </li>
              <li>
                <a href="#"><i class="fab fa-instagram"></i></a>
              </li>
              <li>
                <a href="#"><i class="fab fa-pinterest-p"></i></a>
              </li>
            </ul>
          </div>
        </div>

      </div>

    </div>
  </section><!-- #Social Links -->



</main>
@stop
