<?php

use App\Http\Controllers\Admin\AutoBotsController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\TestController;
use App\Http\Controllers\Admin\AdminLoginController;
use App\Http\Controllers\Admin\AdvertsimentsController;
use App\Http\Controllers\Admin\AnalyticsController;
use App\Http\Controllers\Admin\BonusController;
use App\Http\Controllers\Admin\ChallengesController;
use App\Http\Controllers\Admin\ContentsController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\EmailtemplateController;
use App\Http\Controllers\Admin\GraphController;
use App\Http\Controllers\Admin\LeaderboardController;
use App\Http\Controllers\Admin\League11UserController;
use App\Http\Controllers\Admin\LevelsController;
use App\Http\Controllers\Admin\MatchesController;
use App\Http\Controllers\Admin\Model_listController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PlayersController;
use App\Http\Controllers\Admin\ProfitLossManagerController;
use App\Http\Controllers\Admin\PromotorsController;
use App\Http\Controllers\Admin\RegisterusersController;
use App\Http\Controllers\Admin\SeriesController;
use App\Http\Controllers\Admin\SettingController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\Sub_admin_activityController;
use App\Http\Controllers\Admin\Sub_admin_modelController;
use App\Http\Controllers\Admin\Sub_adminController;
use App\Http\Controllers\Admin\TDSController;
use App\Http\Controllers\Admin\TeamsController;
use App\Http\Controllers\Admin\TenPlusAutoBotsController;
use App\Http\Controllers\Admin\ThirdPartyController;
use App\Http\Controllers\Admin\TransactionManagerController;
use App\Http\Controllers\Admin\YoububerController;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\Api\V1\HomeController;
use App\Http\Controllers\Api\V1\UserController;
use App\Http\Controllers\BaseController;
use App\Http\Middleware\GuestAdmin;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
// Route::get('/', function () {
//     return view('welcome');
// });
/*################################### Admin  Routes Start ###############################################*/
//print_r('expression');die;



// Route::get(,array('as'=>'BaseController.scratch_cards_giveaway','uses'=>'BaseController@scratchCardsGiveaway'));

Route::any("/open/payment-success", [WebhookController::class, 'callback']);
Route::any("/open/check-order-status", [WebhookController::class, 'checkOrderStatus']);

// Webhook Routes
Route::any('/webhook/kyc', [WebhookController::class, 'handleKyc']);
Route::any('/ndps-return-url', [WebhookController::class, 'ndps_return_url'])->name('Admin.ndps_return_url');
Route::any('/phonepe_cron', [WebhookController::class, 'phonepe_cron']);

// Test Routes
Route::get('/test/cont', [TestController::class, 'index']);

// Base Routes
Route::get('/base/uploder', [BaseController::class, 'uploder']);
Route::post('/base/uploder', [BaseController::class, 'uploder']);
Route::any('/dealer-discount-url', [BaseController::class, 'dealer_discount'])->name('dealer_discount_url');

// Ajax Routes
Route::any('get-campaign', [AjaxController::class, 'getDealerCampaign'])->name('getDealerCampaign');

// Matches Routes
Route::get('/contest-pdf-generate-custom/{challenge_id}', [MatchesController::class, 'contestPdfGenerateCustom'])->name('contestPdfGenerateCustom');
Route::get('/testsendnotification', [MatchesController::class, 'testsendnotification']);
Route::any('/custom_update_leaderboard/{id}', [MatchesController::class, 'custom_update_leaderboard']);
Route::any('/get_wrong_winners_list', [MatchesController::class, 'get_wrong_winners_list']);
Route::get('/sendMatchAlerts', [MatchesController::class, 'sendMatchAlerts']);
Route::get('/cancelContestByids', [MatchesController::class, 'cancelContestByids']);
Route::get('/winningrevert/{matchkey}', [MatchesController::class, 'winningRevert']);

// AutoBots Routes
Route::get('/autoBotsGenerater/{criteria}', [AutoBotsController::class, 'autoBotsGenerater']);
Route::get('/createBots/{addbotuser?}', [AutoBotsController::class, 'createBots']);
Route::get('/botsInsertScheduler', [AutoBotsController::class, 'botsInsertScheduler']);
Route::any('/fillBotsTeamByChallengeId', [AutoBotsController::class, 'fillBotsTeamByChallengeId'])->name('AutoBotsController.fillBotsTeamByChallengeId');
Route::get('/generateBotsForMatches', [AutoBotsController::class, 'generateBotsForMatches']);
Route::get('/generateBotsForMatchesTenPlus', [TenPlusAutoBotsController::class, 'generateBotsForMatchesTenPlus']);
Route::get('/addBotsByMatches', [AutoBotsController::class, 'addBotsByMatches']);
Route::get('/addBotsAuto', [AutoBotsController::class, 'addBotsAuto']);

// League11 Routes
Route::get('/league11/transferLeagueBalance', [League11UserController::class, 'transferLeagueBalance']);

// Register Users Routes
Route::get('/update_is_royal_exists', [RegisterusersController::class, 'update_is_royal_exists']);
Route::get('/ultimate_to_royal_newuser', [RegisterusersController::class, 'ultimate_to_royal_newuser']);
Route::get('/ultimate_to_royal_existuser', [RegisterusersController::class, 'ultimate_to_royal_existuser']);


Route::group(array('prefix' => 'admin', 'namespace' => 'Admin'), function () {
    Route::get("/update_ScoreCard_of_matches", "Admin\MatchesController@update_ScoreCard_of_matches");

    //Route::group(array('middleware' => 'App\Http\Middleware\GuestAdmin'), function() {
    Route::middleware('throttle:12,1')->group(function () {
        Route::any('/', [AdminLoginController::class, 'login'])->name('Admin.login');

        // Refer Bonus Keyval
        Route::any('/refer_bonus_new/{matchkey?}/{sports_type?}', [MatchesController::class, 'refer_bonus_new'])->name('Admin.refer_bonus_new');
        Route::get('generate-gst-by-cron/{m?}', [AnalyticsController::class, 'generateGstByCron'])->name('Analytics.generateGstByCron');
        Route::any('getMatchForReferCommissionAndTds/{matchkey?}/{sports_type?}', [MatchesController::class, 'getMatchForReferCommissionAndTds'])->name('Admin.getMatchForReferCommissionAndTds');
        Route::any('/update_results_of_matches', [MatchesController::class, 'update_results_of_matches'])->name('Admin.update');
        Route::any('/update_winnerdeclear_of_matches', [MatchesController::class, 'update_winnerdeclear_of_matches'])->name('Admin.update_winnerdeclear_of_matches');
        Route::any('/userpoints/{matchkey}', [MatchesController::class, 'userpoints'])->name('Admin.update');
        Route::any('/getscoresupdates/{matchkey?}/{sport_type?}', [MatchesController::class, 'getscoresupdates'])->name('Admin.player_point');
        Route::any('/update_results_of_leaderboard', [MatchesController::class, 'update_results_of_leaderboard'])->name('Admin.update');
        Route::any('/update_promoter_match_leaderboard/{matchkey}/', [MatchesController::class, 'update_promoter_match_leaderboard'])->name('Admin.update');
        Route::any('/update_result_basketball', [MatchesController::class, 'update_result_basketball'])->name('Admin.update');
        Route::any('/update_lineup_of_matches', [MatchesController::class, 'update_lineup_of_matches'])->name('Admin.update');
        Route::any('match_lineup/{matchkey}/', [MatchesController::class, 'get_playing_11_new'])->name('Admin.match_lineup');
        Route::any('/match-challanges-pdf-generate', [MatchesController::class, 'matchChallengePdfGenerate'])->name('Admin.matchChallengePdfGenerate');
        Route::any('/get_playing_11/{matchkey}', [MatchesController::class, 'get_playing_11']);
        Route::any('/set_flexy_league', [MatchesController::class, 'set_flexy_league']);
        Route::any('/users_balance_detail_cron', [RegisterusersController::class, 'users_balance_detail_cron'])->name('Registerusers.users_balance_detail_cron');
        Route::any('/useractivityreport', [RegisterusersController::class, 'useractivityreport'])->name('Registerusers.useractivityreport');
        Route::any('/update_transaction', [MatchesController::class, 'update_transaction']);
        Route::any('/reverse', [MatchesController::class, 'reverse'])->name('Admin.reverse');
        Route::any('/uploadExcel', [RegisterusersController::class, 'uploadExcel']);
        Route::any('/phonepay-notify', [RegisterusersController::class, 'phonepay_notify']);
        Route::any('/bonus-expire', [RegisterusersController::class, 'bonus_expire'])->name('Admin.bonus');
        Route::any('/razorpay_payouts_cron', [RegisterusersController::class, 'razorpay_payouts_cron'])->name('Registerusers.razorpay_payouts_cron');
        Route::any('/razorpayinstantProcessed', [RegisterusersController::class, 'razorpayinstantProcessed'])->name('Registerusers.razorpayinstantProcessed');
        Route::get('/checkRazorpayStatus/{orderId}', [RegisterusersController::class, 'checkRazorpayStatus']);
        Route::any('/updateplayerpoints/{playerkey?}', [MatchesController::class, 'updateplayerpoints'])->name('Admin.updateplayerpoints');
        Route::any('/cashfree_notify_test', [RegisterusersController::class, 'cashfree_notify_test'])->name('Admin.cashfree_notify_test');
        Route::any('/icici-payout-notify', [RegisterusersController::class, 'icici_payout_callback']);
        Route::any('/icici', [RegisterusersController::class, 'icici'])->name('Admin.icici');
        Route::any('/refundAmountIcici', [RegisterusersController::class, 'refundAmountIcici'])->name('Admin.refundAmountIcici');
        Route::any('/checkIciciTransStatus', [RegisterusersController::class, 'checkIciciTransStatus'])->name('Admin.checkIciciTransStatus');
        Route::any('/paytm_withdraw_cron', [RegisterusersController::class, 'paytm_withdraw_cron']);
        Route::any('/paytm_wallet_withdraw_cron', [RegisterusersController::class, 'paytm_wallet_withdraw_cron']);
        Route::any('/paytm_withdraw_cron_bank', [RegisterusersController::class, 'paytm_withdraw_cron_bank'])->name('Registerusers.paytm_withdraw_cron_bank');
        Route::any('/paytm_check_withdraw', [RegisterusersController::class, 'paytm_check_withdraw']);
        Route::any('/checkAddCashPaymentStatusByOrderId/{orderid}', [RegisterusersController::class, 'checkAddCashPaymentStatusByOrderId'])->name('Admin.checkAddCashPaymentStatusByOrderId');
        Route::any('/player_list_cron', [MatchesController::class, 'player_list_cron'])->name('Admin.playerListCron');
        Route::any('/bank_withdraw_cron', [RegisterusersController::class, 'bank_withdraw_cron'])->name('Admin.bank_withdraw_cron');
        Route::any('/wrongrefundrevert', [RegisterusersController::class, 'wrongrefundrevert'])->name('Admin.wrongrefundrevert');
        Route::any('/wrongrefundrevertwinning', [RegisterusersController::class, 'wrongrefundrevertwinning'])->name('Admin.wrongrefundrevertwinning');
        Route::any('/contestclashrefund/{matchkey}', [RegisterusersController::class, 'contestclashrefund'])->name('Admin.contestclashrefund');
        Route::any('/wrongrefundrevertwinningwinner', [RegisterusersController::class, 'wrongrefundrevertwinningwinner'])->name('Admin.wrongrefundrevertwinningwinner');
        Route::any('/live-scores-cron', [MatchesController::class, 'liveScoresCron'])->name('Admin.LiveScoresCron');
        Route::any('/testUpdateSessionTable', [RegisterusersController::class, 'testUpdateSessionTable'])->name('Admin.testUpdateSessionTable');
        Route::any('/logout', [AdminLoginController::class, 'logout'])->name('Admin.logout');
        Route::get('forgot-password', [AdminLoginController::class, 'forgetPassword'])->name('admin.forgotPassword');
        Route::post('send-password', [AdminLoginController::class, 'sendPassword'])->name('admin.sendPassword');
        Route::get('/reset-password/{validstring}', [AdminLoginController::class, 'resetPassword'])->name('Admin.reset_password');
        Route::post('/save-password', [AdminLoginController::class, 'resetPasswordSave'])->name('Admin.save_password');
        Route::any('users/send-credential/{id}', [UserController::class, 'sendCredential'])->name('Admin.send_credential');
        Route::get('updatedashboard', [DashboardController::class, 'updatedashboarddata'])->name('admin_updatedashboard');
    });
    Route::group(array('middleware' => 'App\Http\Middleware\AuthAdmin'), function () {
        Route::group(array('middleware' => 'App\Http\Middleware\AuthMain'), function () {
            /*################  Dashboard routing #######################*/
            Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name("admin_dashboard");

            Route::get('get-userdata-month-wise', [DashboardController::class, 'get_userdata_month_wise'])->name('get_userdata_month_wise');

            Route::get('my-profile', [DashboardController::class, 'myprofile'])->name('myprofile');

            Route::post('my-profile-update', [DashboardController::class, 'updateMyProfile'])->name('myprofile.update');

            Route::get('change-password', [DashboardController::class, 'changePassword'])->name('myprofile.change_password');

            Route::post('profile-change-password', [DashboardController::class, 'change_passwordProfile'])->name('myprofile.profile_change_password');

            /*#############  Dashboard routing ####################*/

            /*############################# setting manager  Routing #####################################*/
            // Route::any('/settings', 'Admin\SettingsController@listSetting')->name("Setting.index");
            // Route::get('/settings/add-setting',array('as'=>'Setting.add','uses'=>'SettingsController@addSetting'));
            // Route::post('/settings/add-setting',array('as'=>'Setting.save','uses'=>'SettingsController@saveSetting'));
            // Route::get('/settings/edit-setting/{id}',array('as'=>'Setting.edit','uses'=>'SettingsController@editSetting'));
            // Route::post('/settings/edit-setting/{id}',array('as'=>'Setting.update','uses'=>'SettingsController@updateSetting'));
            // Route::get('/settings/prefix/{slug}',array('as'=>'Setting.prefix_index','uses'=>'SettingsController@prefix'));
            // Route::post('/settings/prefix/{slug}',array('as'=>'Setting.prefix_update','uses'=>'SettingsController@updatePrefix'));
            // Route::any('/settings/delete-setting/{id}',array('as'=>'Setting.delete','uses'=>'SettingsController@deleteSetting'));
            ############################# End setting manager  Routing #####################################*/

            /*############################# graph manager  Routing #####################################*/
            Route::any('/graph/viewDepositWithdraw', [GraphController::class, 'viewDepositWithdraw'])->name('Graph.viewDepositWithdraw');

            Route::any('/graph/activeUsersdaywiseGraph', [GraphController::class, 'activeUsersdaywiseGraph'])->name('Graph.activeUsersdaywiseGraph');

            Route::any('/graph/activeUsersdaywiseGraphdownload', [GraphController::class, 'activeUsersdaywiseGraphdownload'])->name('Graph.activeUsersdaywiseGraphdownload');

            Route::any('/graph/perdayperformreport', [GraphController::class, 'perdayperformreport'])->name('Graph.perdayperformreport');

            Route::any('activeuserreport', [GraphController::class, 'activeuserreport'])->name('Graph.activeuserreport');

            Route::any('activeuserreportdownload', [GraphController::class, 'reportmonthdownload'])->name('Graph.activeuserreportdownload');

            Route::any('/graph/investment', [GraphController::class, 'investmentGraph'])->name('Graph.investment');

            ############################# End setting manager  Routing #####################################*/

            /*############################# transaction manager Routing #####################################*/

            Route::any('/transaction-manager/user_tds_details/{userid?}', [TransactionManagerController::class, 'userTdsDetail'])->name('TransactionManager.user_tds_details');

            Route::any('/transaction-manager/tds_report_new', [TransactionManagerController::class, 'tds_report_new'])->name('TransactionManager.tds_report_new');

            Route::any('/transaction-manager/investedamount', [TransactionManagerController::class, 'investedamount'])->name('TransactionManager.investedamount');

            Route::any('/transaction-manager/promotor_tds_report_new', [TransactionManagerController::class, 'promotor_tds_report_new'])->name('TransactionManager.promotor_tds_report_new');

            Route::any('/transaction-manager/tds_report_promoter', [TransactionManagerController::class, 'tds_report_promoter'])->name('TransactionManager.tds_report_promoter');

            Route::any('/transaction-manager/promotor_tds_details/{userid?}', [TransactionManagerController::class, 'promotorTdsDetail'])->name('TransactionManager.promotor_tds_details');

            // Winning to cash deposit
            Route::any('/transaction-manager/winning_to_cash', [TransactionManagerController::class, 'winning_to_cash'])->name('TransactionManager.winning_to_cash');

            Route::any('/transaction-manager/winning_to_cash_details/{userid?}', [TransactionManagerController::class, 'winning_to_cash_details'])->name('TransactionManager.winning_to_cash_details');


            ############################# End setting manager  Routing #####################################*/

            /*############################# transaction manager Routing #####################################*/
            Route::any('/profitloss-manager/view_profit_loss_new', [ProfitLossManagerController::class, 'view_profit_loss_new'])->name('ProfitLossManager.view_profit_loss_new');

            Route::any('/profitloss-manager/view_profit_report', [ProfitLossManagerController::class, 'view_profit_report'])->name('ProfitLossManager.view_profit_report');

            Route::any('/profitloss-manager/profitlossdownload', [ProfitLossManagerController::class, 'profitlossdownload'])->name('ProfitLossManager.profitlossdownload');

            Route::any('/tds-details', [TDSController::class, 'viewDetails'])->name('userTdsDetails');

            Route::any('/tds-details-download', [TDSController::class, 'TDSDetailsDowmload'])->name('TDSDetails.download');

            ################## Email Logs routing #############################*/
            Route::prefix('email')->group(function () {
                Route::any('/view', [EmailtemplateController::class, 'index'])->name('EmailTemplate.index');
                Route::any('/add', [EmailtemplateController::class, 'Emailadd'])->name('EmailTemplate.add');
                Route::any('/edit/{id}', [EmailtemplateController::class, 'Emailedit'])->name('EmailTemplate.edit');
                Route::any('/delete/{id}', [EmailtemplateController::class, 'Emaildelete'])->name('EmailTemplate.delete');
            });

            /*################################### Email Logs routing #############################*/

            /*################################### series Play routing #############################*/
            Route::prefix('series')->group(function () {
                Route::any('/add-new-series', [SeriesController::class, 'addseries'])->name('Series.add');
                Route::any('/update-series/{id}', [SeriesController::class, 'editseries'])->name('Series.update');
                Route::any('/updateseries-status/{id}/{status}', [SeriesController::class, 'updateseriesstatus'])->name('Series.updateseries');
                Route::any('/deleteseries-series/{id}', [SeriesController::class, 'deleteseries'])->name('Series.deleteseries');
                Route::any('/view-all-series', [SeriesController::class, 'viewseries'])->name('Series.view_all');
            });

            /*################################### End series Play routing #############################*/

            /*##################################Levels play routing ###############################*/

            Route::prefix('levels')->group(function () {
                Route::any('/add-new-levels', [LevelsController::class, 'addlevels'])->name('Levels.add');
                Route::any('/update-levels/{id}', [LevelsController::class, 'editlevels'])->name('Levels.update');
                Route::any('/delete-levels/{id}', [LevelsController::class, 'deletelevels'])->name('Levels.deletelevels');
                Route::any('/view-all-levels', [LevelsController::class, 'viewlevels'])->name('Levels.view_all');
            });

            /*################################### End Levels routing #############################*/
            /*################################### series Play routing #############################*/
            Route::prefix('matches')->group(function () {
                Route::any('/distribute_winning_amount/{matchkey?}/{format?}/{sport_type?}', [MatchesController::class, 'distribute_winning_amount'])->name('Matches.distribute_winning_amount');
                Route::any('/match-mapping/{sport?}', [MatchesController::class, 'matchmapping'])->name('Matches.matchmapping');
                Route::any('/refund-amount', [MatchesController::class, 'refund_amount'])->name('Matches.refound');
                Route::any('/refund_amount_manul{matchkey}/{sport?}', [MatchesController::class, 'refund_amount_manul'])->name('Matches.refund_amount_manul');
                Route::any('/set_flexy_league_manual/{matchkey?}/{challenges_id?}/{flexi_type?}', [MatchesController::class, 'set_flexy_league_auto'])->name('Matches.set_flexy_league_manual');
                Route::any('/update_lineup_of_matches', [MatchesController::class, 'update_lineup_of_matches'])->name('Lineup.update');
                Route::any('/live-match', [MatchesController::class, 'livematch'])->name('Matches.live');
                Route::any('/delete-player-new/{id?}', [MatchesController::class, 'deleteplayernew'])->name('Matches.delete_player_new');
                Route::any('/live-matches/{sport?}', [MatchesController::class, 'liveMatches'])->name('Matches.liveMatches');
                Route::any('/teams-score-update', [MatchesController::class, 'teamsscoreupdate'])->name('Matches.teams_score_update');
                Route::any('/selectleaguesforlaunch/{match_id}/{sport_type}', [MatchesController::class, 'selectleaguesforlaunch']);
                Route::any('/editleaguesformatch/{match_id}/{sport_type?}', [MatchesController::class, 'editleaguesformatch'])->name('Matches.editleaguesformatch');
                Route::any('/view-challenges', [MatchesController::class, 'viewchallenges'])->name('Matches.view_challenges');
                Route::any('/submitleaguesforlaunch', [MatchesController::class, 'submitleaguesforlaunch'])->name('Matches.submitleaguesforlaunch');
                Route::any('/view-edit-challenges', [MatchesController::class, 'view_edit_challenges'])->name('Matches.view_edit_challenges');
                Route::any('/view-matches/{matchkey}', [MatchesController::class, 'live_details'])->name('Matches.viewdata');
                Route::any('/update_match_leaderboard_test/{matchkey}', [MatchesController::class, 'update_match_leaderboard'])->name('Matches.update_match_leaderboard');
                Route::any('/add_matches_Promoters_leaderboard/{matchkey?}/{sport_type?}', [MatchesController::class, 'add_matches_Promoters_leaderboard'])->name('Admin.add_matches_Promoters_leaderboard');
                Route::any('/view-winners/{matchkey}', [MatchesController::class, 'viewwinners'])->name('Matches.view_winners');
                Route::any('/import-live-score-cards/{matchkey}/{compid}', [MatchesController::class, 'update_live_score_cards'])->name('Matches.LiveScore');
                Route::any('/marathon-result', [MatchesController::class, 'marathon_result'])->name('Matches.marathonresult');
                Route::any('/marathon-winner-declared/{id}', [MatchesController::class, 'marathon_winner_declared'])->name('Matches.winner_declared');
                Route::any('/import-schedule-data-from-api', [MatchesController::class, 'importscheduledatafromapi'])->name('Matches.import_schedule_data');
                Route::any('get_matches/{sport_type}', [MatchesController::class, 'get_matches'])->name('Matches.get_matches');
                Route::any('update_bots_lineup_outs_teams/{match_key}', [MatchesController::class, 'update_bots_lineup_outs_teams'])->name('Matches.update_bots_lineup_outs_teams');
                Route::any('/fiveplusone/{id}/{sport_type?}', [MatchesController::class, 'fiveplusone'])->name('Matches.fiveplusone');
                Route::any('/tenplusone/{id}/{sport_type?}', [MatchesController::class, 'tenplusone'])->name('Matches.tenplusone');
                Route::any('/importsquad/{id}/{sport_type?}', [MatchesController::class, 'importsquad'])->name('Matches.importsquad');
                Route::any('/release/{id}', [MatchesController::class, 'release'])->name('Matches.release');
                Route::any('/add-match', [MatchesController::class, 'add_match'])->name('Matches.add_match');
                Route::any('/update-match-status/{matchkey}/{status1}/{status2}', [MatchesController::class, 'updateMatchStatus'])->name('Matches.updateMatchStatus');
                Route::any('/addlinup/{id}', [MatchesController::class, 'addlinup'])->name('Matches.addlinup');
                Route::any('/contest_refund_amount/{id?}/{sport_type?}', [MatchesController::class, 'contest_refund_amount'])->name('Matches.contest_refund_amount');
                Route::any('/refund_amount_manul/{matchkey?}/{sport?}', [MatchesController::class, 'refund_amount_manul'])->name('Matches.refund_amount_manul');
                Route::any('/addAssumptionPlayers/{id}/{sporttype}', [MatchesController::class, 'addAssumptionPlayers'])->name('Matches.addAssumptionPlayers');
                Route::any('/updatenonplayingbots/{id}', [MatchesController::class, 'updatenonplayingbots'])->name('Matches.updatenonplayingbots');
                Route::any('/viewEditPoints/{id}/{sport_type?}', [MatchesController::class, 'viewEditPoints'])->name('Matches.viewEditPoints');
                Route::any('/updateAllPoints/{id}', [MatchesController::class, 'updateAllPoints'])->name('Matches.updateAllPoints');
                Route::any('/edit-match/{matchkey}', [MatchesController::class, 'edit_match'])->name('Matches.edit_match');
                Route::any('/get-team-players', [MatchesController::class, 'getTeamPlayers'])->name('Matches.getTeamPlayers');
                Route::any('/editmatch/{id}/{sport_type?}', [MatchesController::class, 'editmatch'])->name('Matches.editmatch');
                Route::any('/viewmat-chdetails/{id}/{sport_type?}', [MatchesController::class, 'viewmatchdetails'])->name('Matches.viewmatchdetails');
                Route::any('/match-detail/{id}', [MatchesController::class, 'match_detail'])->name('Matches.match_detail');
                Route::any('/winner-list/{id}/{sport_type?}', [MatchesController::class, 'winner_list'])->name('Matches.winner_list');
                Route::any('/match-points/{id}/{sport_type}', [MatchesController::class, 'match_points'])->name('Matches.match_points');
                Route::any('/join-users-details/{id?}', [MatchesController::class, 'join_users_details'])->name('Matches.join_users_details');
                Route::any('/join-users-details/{id?}/edit', [MatchesController::class, 'join_users_details_edit'])->name('Matches.join_users_details.edit');
                Route::any('/join-users/{id}/{sport_type?}', [MatchesController::class, 'join_users'])->name('Matches.join_users');
                Route::any('/join-users-download-sheet/{id}/{sport_type?}', [MatchesController::class, 'downloadjoinusercontest'])->name('Matches.join_users_download_sheet');
                Route::any('/join-users-detail-download/{challenge_id}', [MatchesController::class, 'downloadjoinuserdetail'])->name('Matches.join_users_detail_download');
                Route::any('/contest-cancel/{id}/{sport_type?}', [MatchesController::class, 'contestCancellist'])->name('Matches.contest_cancel');
                Route::any('/refund_list/{challangesid}/{matchkey?}', [MatchesController::class, 'ContestRefundList'])->name('Matches.refund_list');
                Route::any('/bot-join-users/{id}', [MatchesController::class, 'bot_join_users'])->name('Matches.bot_join_users');
                Route::any('/join-bot-details/{id?}', [MatchesController::class, 'join_bot_details'])->name('Matches.join_bot_details');
                Route::any('/join-bot-details/{id?}/edit', [MatchesController::class, 'join_bot_details_edit'])->name('Matches.join_bot_details.edit');
                Route::any('/view-team-model/{id?}', [MatchesController::class, 'view_team_model'])->name('Matches.view_team_model');
                Route::any('/cancel-contest/{id}', [MatchesController::class, 'cancel_contest'])->name('Matches.cancel_contest');
                Route::any('/update-manually', [MatchesController::class, 'updatemanually'])->name('Matches.update_manually');
                Route::any('/update-match-final-status/{id}/{sport_type?}/{status}', [MatchesController::class, 'updatematchfinalstatus'])->name('Matches.update_match_final_status');
                Route::any('/refund_allamount/{id}/{sport_type?}/{status}', [MatchesController::class, 'refund_allamount'])->name('Matches.refund_allamount');
                Route::any('/update-scores/{id}/{sport_type}', [MatchesController::class, 'updatescores'])->name('Matches.update_scores');
                Route::any('/bat-stats/{id}', [MatchesController::class, 'pointstats'])->name('Matches.pointstats');
                Route::any('/update-points', [MatchesController::class, 'updatepoints'])->name('Matches.update_points');
                Route::any('/player-points/{id}/{pid}', [MatchesController::class, 'player_points'])->name('Matches.player_points');
                Route::any('/view-winners/{id}', [MatchesController::class, 'viewwinners'])->name('Matches.viewwinners');
                Route::any('/launchmatch/{id}/{sport_type?}', [MatchesController::class, 'launchmatch'])->name('Matches.launchmatch');
                Route::any('/launchmatch/orderclear/{id}/{sport_type?}/{team}', [MatchesController::class, 'launchmatchOrderClear'])->name('Matches.launchmatch.orderclear');
                Route::post('/launchmatch/showlineup/{id}/{sport_type?}', [MatchesController::class, 'launchmatchshowlineup'])->name('Matches.launchmatch.showlineup');
                Route::any('/updatelogo/{id}', [MatchesController::class, 'updatelogo'])->name('Matches.updatelogo');
                Route::any('/playerroles/{id}/{sport_type?}', [MatchesController::class, 'playerroles'])->name('Matches.playerroles');
                Route::any('/playercredit/{id}', [MatchesController::class, 'playercredit'])->name('Matches.playercredit');
                Route::any('/launch/{id}/{sport_type?}', [MatchesController::class, 'launch'])->name('Matches.launch');
                Route::any('/match-result', [MatchesController::class, 'series_list'])->name('Matches.matchresult');
                Route::any('/update_match_investment_leaderboard_test/{matchkey}/{sport_type?}', [MatchesController::class, 'update_match_investment_leaderboard'])->name('Matches.update_match_investment_leaderboard');
                  Route::any('/fetchSeries', [MatchesController::class, 'fetchSeries'])->name('Matches.fetchSeries');

            });

            /*################################### End series Play routing #############################*/
            /*################################### leaderboard Play routing #############################*/
            Route::prefix('leaderboard')->group(function () {
                Route::any('/promotor-series-list', [LeaderboardController::class, 'promoterSeriesList'])->name("Leaderboard.promoterSeriesList");
                Route::any('/series-promotor-leaderboard/{series_id}', [LeaderboardController::class, 'seriesPromotorLeaderboard'])->name("Leaderboard.seriesPromotorLeaderboard");
                Route::any('/series-prmotor-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'seriesPromotorLeaderboardPricecards'])->name("Leaderboard.seriesPromotorLeaderboardPricecards");
                Route::any('/add-series-leaderboard-promotor-pricecards', [LeaderboardController::class, 'addSeriesPromotorLeaderboardPricecard'])->name("Leaderboard.addSeriesPromotorLeaderboardPricecard");
                Route::any('/delete-promoter-series-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'deletepromoterSeriesLeaderboardPricecard'])->name("Leaderboard.deletePromootrSeriesLeaderboardPricecard");
                Route::any('/series-promoter-leaderboard-winning-distribute/{series_id}', [LeaderboardController::class, 'seriesPromoterLeaderboardWinningDistribute'])->name("Leaderboard.seriesPromoterLeaderboardWinningDistribute");
                Route::any('/series-list', [LeaderboardController::class, 'seriesList'])->name("Leaderboard.seriesList");
                Route::any('/series-leaderboard/{series_id}', [LeaderboardController::class, 'seriesLeaderboard'])->name("Leaderboard.seriesLeaderboard");
                Route::any('/series-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'seriesLeaderboardPricecards'])->name("Leaderboard.seriesLeaderboardPricecards");
                Route::any('/add-series-leaderboard-pricecards', [LeaderboardController::class, 'addSeriesLeaderboardPricecard'])->name("Leaderboard.addSeriesLeaderboardPricecard");
                Route::any('/delete-series-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'deleteSeriesLeaderboardPricecard'])->name("Leaderboard.deleteSeriesLeaderboardPricecard");
                Route::any('/series-leaderboard-winning-distribute/{series_id}', [LeaderboardController::class, 'seriesLeaderboardWinningDistribute'])->name("Leaderboard.seriesLeaderboardWinningDistribute");
                Route::any('/series-leaderboard-winning-update/{series_id}', [LeaderboardController::class, 'seriesLeaderboardWinningUpdate'])->name("Leaderboard.seriesLeaderboardWinningUpdate");

                // Investment Leaderboard
                Route::any('/investment-series-list', [LeaderboardController::class, 'InvestMentseriesList'])->name('Leaderboard.InvestMentseriesList');
                Route::any('/investment-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'investmentLeaderboardPricecards'])->name("Leaderboard.investmentLeaderboardPricecards");
                Route::any('/delete-investment-leaderboard-pricecards/{series_id}', [LeaderboardController::class, 'deleteInvestmentLeaderboardPricecard'])->name("Leaderboard.deleteInvestmentLeaderboardPricecard");
                Route::any('/investment-leaderboard/{series_id}', [LeaderboardController::class, 'investmentLeaderboard'])->name("Leaderboard.investmentLeaderboard");
                Route::any('/investment-leaderboard-winning-distribute/{series_id}', [LeaderboardController::class, 'investmentsLeaderboardWinningDistribute'])->name("Leaderboard.investmentLeaderboardWinningDistribute");
                Route::any('/add-investment-leaderboard-pricecards', [LeaderboardController::class, 'addInvestmentLeaderboardPricecard'])->name("Leaderboard.addInvestmentLeaderboardLeaderboardPricecard");
                Route::any('/investment-leaderboard-winning-update/{series_id}', [LeaderboardController::class, 'investmentLeaderboardWinningUpdate'])->name("Leaderboard.investmentLeaderboardWinningUpdate");
                Route::any('/investment-leaderboard-user-add/{series_id}', [LeaderboardController::class, 'investmentLeaderboardUseAdd'])->name("Leaderboard.investmentLeaderboardUseAdd");
                Route::any('/edit_user/{series_id}/{investment_id}', [LeaderboardController::class, 'investmentEditUser'])->name("Leaderboard.edit_user");
                Route::any('/delete_user/{investment_id}', [LeaderboardController::class, 'investmentDeleteUser'])->name("Leaderboard.delete_user");

                // Deposit Invested leaderboard
                Route::any('/deposit-investment-list', [LeaderboardController::class, 'DepositInvestMentList'])->name("Leaderboard.DepositInvestMentList");
                Route::any('/deposit-investment-leaderboard-pricecards/{id}', [LeaderboardController::class, 'depositInvestmentLeaderboardPricecards'])->name("Leaderboard.depositInvestmentLeaderboardPricecards");
                Route::any('/delete-depositinvestment-leaderboard-pricecards/{id}', [LeaderboardController::class, 'deleteDepositInvestmentLeaderboardPricecard'])->name("Leaderboard.deleteDepositInvestmentLeaderboardPricecard");
                Route::any('/deposit-investment-leaderboard/{series_id}', [LeaderboardController::class, 'depositInvestmentLeaderboard'])->name("Leaderboard.depositInvestmentLeaderboard");
                Route::any('/deposit-investment-leaderboard-winning-distribute/{series_id}', [LeaderboardController::class, 'depositInvestmentsLeaderboardWinningDistribute'])->name("Leaderboard.depositInvestmentLeaderboardWinningDistribute");
                Route::any('/add-depositinvestment-leaderboard-pricecards', [LeaderboardController::class, 'addDepositInvestmentLeaderboardPricecard'])->name("Leaderboard.addDepositInvestmentLeaderboardLeaderboardPricecard");
                Route::any('/add-depositinvestment', [LeaderboardController::class, 'addDepositInvestmentName'])->name("Leaderboard.addDepositInvestmentName");
                Route::any('/deposit-investment-leaderboard-user-add/{series_id}', [LeaderboardController::class, 'depositInvestmentLeaderboardUseAdd'])->name("Leaderboard.depositInvestmentLeaderboardUseAdd");
            });

            /*################################### End leaderboard Play routing #############################*/

            /*################################### Advertisments #############################*/
            Route::prefix('advertisments')->group(function () {
                Route::any('/all-Advertisments', [AdvertsimentsController::class, 'viewAdvertisments'])->name("Advertisments.view");
                Route::any('/add-Advertisment', [AdvertsimentsController::class, 'addAdvertisment'])->name("Advertisments.add");
                Route::any('/edit-Advertisment/{id}', [AdvertsimentsController::class, 'editAdvertisment'])->name("Advertisments.edit");
                Route::any('/delete-Advertisment/{id}', [AdvertsimentsController::class, 'deleteAdvertisment'])->name("Advertisments.delete");

                Route::any('main-admin/view-offers', [AdvertsimentsController::class, 'viewOffers'])->name("Advertisments.viewOffers");
                Route::any('main-admin/upload-offer-csv/{id}', [AdvertsimentsController::class, 'upload_offer_csv'])->name("Advertisments.upload_offer_csv");
                Route::any('main-admin/get-upload-offer-csv', [AdvertsimentsController::class, 'get_upload_offer_csv'])->name("Advertisments.get_upload_offer_csv");

                Route::any('main-admin/add-new-Offers', [AdvertsimentsController::class, 'addNewOffers'])->name("Advertisments.addNewOffers");

                Route::any('main-admin/bonus-list', [AdvertsimentsController::class, 'bonuslist'])->name("Advertisments.bonuslist");
                Route::any('main-admin/edit-Bonus/{id}', [AdvertsimentsController::class, 'editBonus'])->name("Advertisments.editBonus");
                Route::any('main-admin/delete-Bonus/{id}', [AdvertsimentsController::class, 'deleteBonus'])->name("Advertisments.deleteBonus");
                Route::any('main-admin/add-Bonus', [AdvertsimentsController::class, 'addBonus'])->name("Advertisments.addBonus");

                Route::any('main-admin/edit-offers/{id}', [AdvertsimentsController::class, 'editOffers'])->name("Advertisments.editOffers");
                Route::any('main-admin/add-offers', [AdvertsimentsController::class, 'addOffers'])->name("Advertisments.addOffers");
                Route::any('main-admin/delete-offers/{id}', [AdvertsimentsController::class, 'deleteoffers'])->name("Advertisments.deleteoffers");

                Route::any('main-admin/scratch-manage', [AdvertsimentsController::class, 'scratchManage'])->name("Advertisments.scratchManage");
                Route::any('main-admin/scratch-manage-update-status', [AdvertsimentsController::class, 'scratchUpdateStatus'])->name("Advertisments.scratchUpdateStatus");
                Route::any('main-admin/scratch-manage-range-update', [AdvertsimentsController::class, 'scratchRangeUpdate'])->name("Advertisments.scratchRangeUpdate");
                Route::any('main-admin/scratch-cards-give-away', [AdvertsimentsController::class, 'scratchCardsGiveaway'])->name("Advertisments.scratchCardsGiveaway");
            });

            /*################################### End Advertisments #############################*/

            /*################################### Contrents #############################*/
            Route::prefix('contrents')->group(function () {
                Route::any('/terms-conditions-refer', [ContentsController::class, 'terms_conditions_refer'])->name("Contrents.terms");
                Route::any('/add-pages', [ContentsController::class, 'add_pages'])->name('Contrents.add_pages');
                Route::any('/update-pages/{id}', [ContentsController::class, 'update_pages'])->name('Contrents.update_pages');
                Route::any('/view-pages', [ContentsController::class, 'view_pages'])->name('Contrents.view_pages');
                Route::any('/delete-page/{id}', [ContentsController::class, 'delete_page'])->name('Contrents.delete_page');
            });

            /*################################### End Contrents #############################*/

            /*################################### Players #############################*/
            Route::prefix('players')->group(function () {
                Route::any('/all-players', [PlayersController::class, 'viewplayers'])->name('Players.view');
                Route::any('/add-players', [PlayersController::class, 'add_player'])->name('Players.add');
                Route::any('/edit-players/{id}/{sport_type?}', [PlayersController::class, 'editplayer'])->name('Players.edit');
                Route::any('/save-player-roles', [PlayersController::class, 'saveplayerroles'])->name('Players.save_player_roles');
                Route::any('/add-player', [PlayersController::class, 'addplayermanually'])->name('Players.addplayermanually');
                Route::any('/delete-player/{id}', [PlayersController::class, 'deleteplayer'])->name('Players.delete');
            });

            /*################################### End Players #############################*/


            Route::prefix('promotors')->group(function () {
                Route::any('/all-promotors', [PromotorsController::class, 'viewpromotors'])->name('Promotors.view');
                Route::any('/promotors-channel-detail/{user_id}', [PromotorsController::class, 'promotorschanneldetail'])->name('Promotors.channeldetail');
            });



            /*###################################  Team #############################*/
            Route::prefix('team')->group(function () {
                Route::any('/view-all-team', [TeamsController::class, 'viewteams'])->name('Team.view');
                Route::any('/update-team/{id}', [TeamsController::class, 'editteams'])->name('Team.edit');
                Route::any('/add-team', [TeamsController::class, 'add_team'])->name('Team.add');
            });

            /*################################### End Team #############################*/


            /*###################################  Team #############################*/
            Route::prefix('setting')->group(function () {
                Route::any('/view-all-setting', [SettingController::class, 'view'])->name('Setting.view');
                Route::any('/update-setting/{id}', [SettingController::class, 'edit'])->name('Setting.edit');
                Route::any('/add-setting', [SettingController::class, 'add'])->name('Setting.add');
                Route::any('/delete-setting/{id}', [SettingController::class, 'delete'])->name('Setting.delete');

                // Sport type
                Route::any('/view-all-sport', [SettingController::class, 'sportview'])->name('Setting.sport');
                Route::any('/states', [SettingController::class, 'states'])->name('Setting.states');
                Route::any('/update-state', [SettingController::class, 'update_state'])->name('Setting.update_state');
                Route::any('/update-sporttype/{id}', [SettingController::class, 'sportTypeEdit'])->name('Setting.sporttypeedit');
            });

            /*################################### End Team #############################*/

            /*###################################  Legauges #############################*/
            Route::prefix('challenges')->group(function () {
                Route::any('/challenges-category', [ChallengesController::class, 'challenges_category'])->name('Challenges.category');
                Route::any('/edit-challenge-category/{id}', [ChallengesController::class, 'edit_challenge_category'])->name('Challenges.category_edit');
                Route::any('/add-new-challenge-category', [ChallengesController::class, 'add_challenges_category'])->name('Challenges.category_add');

                Route::any('/add-new-global-challenge', [ChallengesController::class, 'addglobalchallenge'])->name('Challenges.global_challenge');
                Route::any('/view-challenges', [ChallengesController::class, 'viewchallenges'])->name('Challenges.view_challenges');
                Route::any('/setflaxibleleague/{match_id}/{sport_type?}', [MatchesController::class, 'setflaxibleleague'])->name('Matches.setflaxibleleague');
                Route::any('/add-price-card/{id}', [ChallengesController::class, 'addpricecard'])->name('Challenges.add_pricecard');
                Route::any('/edit-global-challenge/{id}', [ChallengesController::class, 'editglobalchallenge'])->name('Challenges.edit_global_challenge');
                Route::any('/delete-global-challenge/{id}', [ChallengesController::class, 'deleteglobalchallenge'])->name('Challenges.delete_global_challenge');
                Route::any('/delete-price-card/{id}', [ChallengesController::class, 'deletepricecard'])->name('Challenges.delete_price_card');
                Route::any('/delete-match-price-card/{id}', [ChallengesController::class, 'deletematchpricecard'])->name('Challenges.delete_match_price_card');
                Route::any('/getChallangesBySportType', [ChallengesController::class, 'getChallangesBySportType'])->name('Challenges.getChallangesBySportType');

                // GST Category use
                Route::any('/getChallangesByGSTType', [ChallengesController::class, 'getChallangesByGSTType'])->name('Challenges.getChallangesByGSTType');
                Route::any('/create-challenge', [ChallengesController::class, 'createchallenge'])->name('Challenges.create_challenge');
                Route::get('/create-challenges', [ChallengesController::class, 'createchallenge'])->name('Challenges.create_challenges');

                Route::any('/add-match-pricecard/{id}', [ChallengesController::class, 'addmatchpricecard'])->name('Challenges.add_match_pricecard');
                Route::any('/edit-match-challenge/{id}', [ChallengesController::class, 'editmatchchallenge'])->name('Challenges.edit_match_challenge');
                Route::any('/del-match-challenge/{id}', [ChallengesController::class, 'delmatchchallenge'])->name('Challenges.del_match_challenge');
                Route::any('/addmatchBots/{id?}', [ChallengesController::class, 'addmatchBots'])->name('Challenges.addmatchBots');
                Route::any('/addBotsInChallenges/{id?}', [ChallengesController::class, 'addBotsInChallenges'])->name('Challenges.addBotsInChallenges');
                Route::any('/generateBotsApi/{matchkey}', [AutoBotsController::class, 'generateBotsApi'])->name('AutoBots.generateBotsApi');

                // TENPLUSONE botsTeam
                Route::any('/generateBotsApiTenPlus/{matchkey}', [TenPlusAutoBotsController::class, 'generateBotsApiTenPlus'])->name('AutoBots.generateBotsApiTenPlus');

                Route::any('/addBotsInChallengeAPI', [AutoBotsController::class, 'addBotsInChallengeAPI'])->name('AutoBots.addBotsInChallengeAPI');
                Route::any('/edit_bots_data/{id}', [ChallengesController::class, 'edit_bots_data'])->name('Challenges.edit_bots_data');

                Route::any('/add-match-challenge/{id?}', [ChallengesController::class, 'addmatchchallenge'])->name('Challenges.add_match_challenge');
                Route::any('/add_private_contest', [ChallengesController::class, 'add_private_contest'])->name('Challenges.add_private_contest');
                Route::any('/fetchContestData', [ChallengesController::class, 'fetchContestData'])->name('Challenges.fetchContestData');
                Route::any('/updateContestInviteCode', [ChallengesController::class, 'updateContestInviteCode'])->name('Challenges.updateContestInviteCode');

                Route::any('/update-category-status/{id}/{status}', [ChallengesController::class, 'update_status_category'])->name('Challenges.update_status_category');

                Route::any('/import-match-data/{id}/{sport_type?}', [ChallengesController::class, 'importdata'])->name('Challenges.import_match_data');
            });

            /*################################### End Team #############################*/

            /* ####### Admin Activity #######*/

            Route::prefix('UserActivity')->group(function () {
                Route::any('/sub_admin_action', [Sub_admin_activityController::class, 'sub_adminAction'])->name('AdminActivityLog.sub_admin_action');
                Route::any('/view_admin_activity', [Sub_admin_activityController::class, 'viewAdminActivity'])->name('AdminActivityLog.view_admin_activity');
            });

            Route::any('/view-admin-all-activity', [Sub_admin_activityController::class, 'viewAdminActivity'])->name('AdminActivityLog.view_admin_all_activity');
            Route::any('/view-transaction-model', [Sub_admin_activityController::class, 'viewtransactionmodel'])->name('AdminActivityLog.view_transaction_model');


            /* ###### Admin Activity #######*/



            /*################################### Youtuber #############################*/

            Route::prefix('Youtuber')->group(function () {
                Route::any('/all-Youtuber', [YoububerController::class, 'view'])->name('Yoububer.view');
                Route::any('/report', [YoububerController::class, 'promoter_reporting'])->name('Yoububer.report');
                Route::any('/edit-Youtuber/{id}', [YoububerController::class, 'edit'])->name('Yoububer.edit');
                Route::any('/add-Youtuber', [YoububerController::class, 'add'])->name('Yoububer.add');
                Route::any('/update-Youtuber-status/{id}/{status}', [RegisterusersController::class, 'updateuserstatus'])->name('Yoububer.update_status');
                Route::any('/download-promoters', [YoububerController::class, 'downloadPromoters'])->name('Yoububer.downloadPromoters');

                // User Commission Report
                Route::any('/userreport', [YoububerController::class, 'allusercommission'])->name('Yoububer.userreport');
                Route::any('/userreportdownload', [YoububerController::class, 'allusercommissionreportdownload'])->name('Yoububer.userreportdownload');

                Route::any('/Youtuber-winning-create', [YoububerController::class, 'promoterwinningcreate'])->name('Yoububer.winningcreate');
                Route::any('/deletedata/{matchkey}', [YoububerController::class, 'promoterdelete'])->name('Yoububer.deletedata');
                Route::any('/Youtuber-winning-store', [YoububerController::class, 'promoterwinningstore'])->name('Yoububer.winningsstore');
                Route::any('/getuser', [YoububerController::class, 'getteamUser'])->name('Yoububer.getuser');
                Route::any('/youtuber-delete/{id}', [YoububerController::class, 'youtuberDelete'])->name('Yoububer.delete');
                Route::any('/youtuber-winning-edit/{id}', [YoububerController::class, 'youtuberEdit'])->name('Yoububer.winningedit');
                Route::any('/Youtuber-winning-screenshot', [YoububerController::class, 'promoterwinningscreenshot'])->name('Yoububer.winnigscreenshot');
            });


            /*################################### End Youtuber #############################*/
            /*###################### Third Party Config  #############################*/

            Route::prefix('ThirdParty')->group(function () {
                // Payment Management
                Route::any('/payment-view', [ThirdPartyController::class, 'paymentview'])->name('ThirdParty.view');
                Route::any('/payment-add', [ThirdPartyController::class, 'add_payment'])->name('ThirdParty.addpayment');
                Route::any('/payment-status/{id}/{status}', [ThirdPartyController::class, 'updatesubadminstatus'])->name('ThirdParty.paymentstatus');
                Route::any('/delete-payment/{id}', [ThirdPartyController::class, 'deletepayment'])->name('ThirdParty.deletepayment');
                Route::any('/edit-payment/{id}/{sport_type?}', [ThirdPartyController::class, 'editpayment'])->name('ThirdParty.editpayment');
                Route::any('/update-payment/{id}', [ThirdPartyController::class, 'updatepayment'])->name('ThirdParty.updatepayment');

                // Payout Management
                Route::any('/payout-view', [ThirdPartyController::class, 'payoutview'])->name('ThirdParty.viewpayout');
                Route::any('/payout-add', [ThirdPartyController::class, 'add_payout'])->name('ThirdParty.addpayout');
                Route::any('/payout-status/{id}/{status}', [ThirdPartyController::class, 'updatepayoutstatus'])->name('ThirdParty.payoutstatus');
                Route::any('/delete-payout/{id}', [ThirdPartyController::class, 'deletepayout'])->name('ThirdParty.deletepayout');
                Route::any('/edit-payout/{id}/{sport_type?}', [ThirdPartyController::class, 'editpayout'])->name('ThirdParty.editpayout');
                Route::any('/update-payout/{id}', [ThirdPartyController::class, 'updatepayout'])->name('ThirdParty.updatepayout');

                // AWS S3 Management
                Route::any('/all-aws', [ThirdPartyController::class, 'viewaws'])->name('ThirdParty.viewaws');
                Route::any('/add-aws', [ThirdPartyController::class, 'add_aws'])->name('ThirdParty.add_aws');
                Route::any('/aws-status/{id}/{status}', [ThirdPartyController::class, 'updateawsstatus'])->name('ThirdParty.awsstatus');
                Route::any('/edit-aws/{id}/{sport_type?}', [ThirdPartyController::class, 'edit_aws'])->name('ThirdParty.edit_aws');
                Route::any('/update-aws/{id}', [ThirdPartyController::class, 'update_aws'])->name('ThirdParty.update_aws');
                Route::any('/delete-aws/{id}', [ThirdPartyController::class, 'delete_aws'])->name('ThirdParty.delete_aws');

                // Fantasy Sports API Management
                Route::any('/all-api', [ThirdPartyController::class, 'viewapi'])->name('ThirdParty.viewapi');
                Route::any('/add-api', [ThirdPartyController::class, 'add_api'])->name('ThirdParty.add_api');
                Route::any('/api-status/{id}/{status}', [ThirdPartyController::class, 'updatesubadminstatus'])->name('ThirdParty.apistatus');
                Route::any('/edit-api/{id}/{sport_type?}', [ThirdPartyController::class, 'edit_api'])->name('ThirdParty.edit_api');
                Route::any('/update-api/{id}', [ThirdPartyController::class, 'update_api'])->name('ThirdParty.update_api');
                Route::any('/delete-api/{id}', [ThirdPartyController::class, 'delete_api'])->name('ThirdParty.delete_api');

                // SMS Management
                Route::any('/all-sms', [ThirdPartyController::class, 'viewsms'])->name('ThirdParty.viewsms');
                Route::any('/add-sms', [ThirdPartyController::class, 'add_sms'])->name('ThirdParty.add');
                Route::any('/delete-sms/{id}', [ThirdPartyController::class, 'deletesms'])->name('ThirdParty.delete');
                Route::any('/edit-sms/{id}/{sport_type?}', [ThirdPartyController::class, 'editsms'])->name('ThirdParty.edit');
                Route::any('/update-sms-status/{id}/{status}', [ThirdPartyController::class, 'updatesmsstatus'])->name('ThirdParty.update_sms_status');
                Route::any('/update-sms/{id}', [ThirdPartyController::class, 'updatesms'])->name('ThirdParty.update');

                // Email Management
                Route::any('/all-email', [ThirdPartyController::class, 'viewemail'])->name('ThirdParty.viewemail');
                Route::any('/add-email', [ThirdPartyController::class, 'add_email'])->name('ThirdParty.addemail');
                Route::any('/delete-email/{id}', [ThirdPartyController::class, 'deleteemail'])->name('ThirdParty.deleteemail');
                Route::any('/edit-email/{id}/{sport_type?}', [ThirdPartyController::class, 'editemail'])->name('ThirdParty.editemail');
                Route::any('/update-email-status/{id}/{status}', [ThirdPartyController::class, 'updateemailstatus'])->name('ThirdParty.update_email_status');
                Route::any('/update-email/{id}', [ThirdPartyController::class, 'updateemail'])->name('ThirdParty.updateemail');

                // DLT Management
                Route::any('/all-dlt', [ThirdPartyController::class, 'view_dlt'])->name('ThirdParty.viewdlt');
                Route::any('/add-dlt', [ThirdPartyController::class, 'add_dlt'])->name('ThirdParty.adddlt');
                Route::any('/delete-dlt/{id}', [ThirdPartyController::class, 'deletedlt'])->name('ThirdParty.deletedlt');
                Route::any('/edit-dlt/{id}/{sport_type?}', [ThirdPartyController::class, 'edit_dlt'])->name('ThirdParty.editdlt');
                Route::any('/update-dlt-status/{id}/{status}', [ThirdPartyController::class, 'updatedltstatus'])->name('ThirdParty.update_dlt_status');
                Route::any('/update-dlt/{id}', [ThirdPartyController::class, 'updatedlt'])->name('ThirdParty.updatedlt');

                // Firebase Management
                Route::any('/all-firebase', [ThirdPartyController::class, 'view_firebase'])->name('ThirdParty.viewfirebase');
                Route::any('/add-firebase', [ThirdPartyController::class, 'add_firebase'])->name('ThirdParty.addfirebase');
                Route::any('/edit-firebase/{id}/{sport_type?}', [ThirdPartyController::class, 'edit_firebase'])->name('ThirdParty.editfirebase');
                Route::any('/update-firebase/{id}', [ThirdPartyController::class, 'update_firebase'])->name('ThirdParty.updatefirebase');
                Route::any('/update-firebase-status/{id}/{status}', [ThirdPartyController::class, 'updatefirebasestatus'])->name('ThirdParty.update_firebase_status');
                Route::any('/delete-firebase/{id}', [ThirdPartyController::class, 'deletefirebase'])->name('ThirdParty.deletefirebase');
            });


            // new code



            /*########################## end notifications  ############################## */
            /*################################### bonus #############################*/

            Route::prefix('bonus')->group(function () {
                // Bonus Management
                Route::any('/all-bonus', [BonusController::class, 'viewbonus'])->name('Bonus.view');
                Route::any('/add-bonus', [BonusController::class, 'add_bonus'])->name('Bonus.add');
                Route::any('/edit-bonus/{id}/{sport_type?}', [BonusController::class, 'editbonus'])->name('Bonus.edit');
                Route::any('/update-bonus/{id}', [BonusController::class, 'updatebonus'])->name('Bonus.update');
                Route::any('/update_subadmin_status/{id}/{status}', [BonusController::class, 'updatesubadminstatus'])->name('Bonus.update_subadmin_status');

                // Payment Status
                Route::any('/updatePendingPhonepayStatus', [BonusController::class, 'updatePendingPhonepayStatus'])->name('Bonus.updatePendingPhonepayStatus');
                Route::any('/checkPaymentStatus/{transaction_id}/{internal}', [BonusController::class, 'checkPaymentStatus'])->name('Bonus.checkPaymentStatus');

                // Promo Code Management
                Route::any('/use_promocode', [BonusController::class, 'usepromocode'])->name('Bonus.use_promocode');
                Route::any('/use_promocode_download', [BonusController::class, 'usepromocodedownload'])->name('Bonus.use_promocode_download');

                // User Bonus Usage
                Route::any('/use-bonus-list/{promo_code}', [BonusController::class, 'userusebonuslist'])->name('Bonus.bonususe');
                Route::any('/use-bonus-list-download/{promo_code}', [BonusController::class, 'userusebonuslistDownload'])->name('Bonus.bonususe_download');

                // User Report
                Route::any('/user_report', [BonusController::class, 'userwisereport'])->name('Bonus.user_report');
                Route::any('/user_wise_report/{id}', [BonusController::class, 'userwisereportdata'])->name('Bonus.user_wise_report');
                Route::any('/user_report_download', [BonusController::class, 'userreportDownload'])->name('Bonus.user_report_download');

                // Profit and Loss Report
                Route::any('/user_profit_loss', [BonusController::class, 'profitlossreport'])->name('Bonus.profilt_loss_report');
                Route::any('/user_profit_loss_download', [BonusController::class, 'profitlossreportDownload'])->name('Bonus.profilt_loss_report_download');

                // Balance Issues
                Route::any('/wrongbalance', [BonusController::class, 'wrongbalance'])->name('Bonus.wrongbalance');

                // Player Management
                Route::any('/save-player-roles', [BonusController::class, 'saveplayerroles'])->name('Bonus.save_player_roles');
                Route::any('/add-player', [BonusController::class, 'addplayermanually'])->name('Bonus.addplayermanually');
                Route::any('/delete-player/{id}', [BonusController::class, 'deleteplayer'])->name('Bonus.delete');
            });




            /*################################### End bonus #############################*/
            /*#################### Sub Admin Model #############################*/
            /*Route::group(array('prefix' => 'Sub_admin'), function() {
          Route::any('/',array('as'=>'Sub_admin.view','uses'=>'Sub_adminController@view'));
          Route::any('/edit/{id}',array('as'=>'Sub_admin.edit','uses'=>'Sub_adminController@edit'));
          Route::any('/add',array('as'=>'Sub_admin.add','uses'=>'Sub_adminController@add'));
          Route::any('/update_subadmin_status/{id}/{status}',array('as'=>'Sub_admin.update_subadmin_status','uses'=>'Sub_adminController@updatesubadminstatus'));
          Route::any('/delete_subadmin/{id}',array('as'=>'Sub_admin.delete_subadmin','uses'=>'Sub_adminController@delete_subadmin'));

          Route::any('/get-model-action', array('as'=>'Sub_admin.get_model_action','uses'=>'Sub_adminController@get_model_action'));

      });*/
            /*################### End Sub Admin Model ##########################*/

            /*#################### Sub Admin Model #############################*/
            // Sub Admin Routes
            Route::prefix('Sub_admin')->group(function () {
                Route::any('/', [Sub_adminController::class, 'view'])->name('Sub_admin.view');
                Route::any('/edit/{id}', [Sub_adminController::class, 'edit'])->name('Sub_admin.edit');
                Route::any('/add', [Sub_adminController::class, 'add'])->name('Sub_admin.add');
                Route::any('/update_subadmin_status/{id}/{status}', [Sub_adminController::class, 'updatesubadminstatus'])->name('Sub_admin.update_subadmin_status');
                Route::any('/delete_subadmin/{id}', [Sub_adminController::class, 'delete_subadmin'])->name('Sub_admin.delete_subadmin');
                Route::any('/get-model-action', [Sub_adminController::class, 'get_model_action'])->name('Sub_admin.get_model_action');
            });

            // Sub Admin Model Routes
            Route::prefix('Sub_admin_model')->group(function () {
                Route::any('/', [Sub_admin_modelController::class, 'view'])->name('Sub_admin_model.view');
                Route::any('/edit/{id}', [Sub_admin_modelController::class, 'edit'])->name('Sub_admin_model.edit');
                Route::any('/delete/{id}', [Sub_admin_modelController::class, 'deletesubadminmodel'])->name('Sub_admin_model.delete_sub_admin_model');
                Route::any('/add', [Sub_admin_modelController::class, 'add'])->name('Sub_admin_model.add');
            });

            // Model List Routes
            Route::prefix('Model_list')->group(function () {
                Route::any('/', [Model_listController::class, 'view'])->name('Model_list.view');
                Route::any('/edit/{id}', [Model_listController::class, 'edit'])->name('Model_list.edit');
                Route::any('/add', [Model_listController::class, 'add'])->name('Model_list.add');
            });

            // Youtuber Analytics and Dashboard Routes
            Route::get('youtober-dashboard', [DashboardController::class, 'dashboard'])->name('youtober_dashboard');

            // Youtuber User Routes
            Route::prefix('youtober-user')->group(function () {
                Route::any('/users', [YoububerController::class, 'users'])->name('Yoububer.user');
                Route::any('/matches', [YoububerController::class, 'matches'])->name('Yoububer.matches');
                Route::any('/user-chalange-detail/{id}', [YoububerController::class, 'user_chalange'])->name('Yoububer.user_chalange');
            });


            /*################################### Registerusers #############################*/

            Route::group(array('prefix' => 'registerusers'), function () {

                Route::any('/promoter-leaderboard-users', [RegisterusersController::class, 'promoter_leaderboard_users'])->name('Registerusers.view_leaderboard_users');
                Route::any('/add_leaderboard_users', [RegisterusersController::class, 'add_leaderboard_users'])->name('Registerusers.add_leaderboard_users');
                Route::post('/Registerusers/fetchUser', [RegisterusersController::class, 'fetchUser'])->name('Registerusers.fetchUser');
                Route::any('action-promoter-leaderboard-user/{id}', [RegisterusersController::class, 'action_promoter_leaderboard_user'])->name('Registerusers.action-promoter-leaderboard-user');

                // Financial Year
                Route::any('/financialyear', [RegisterusersController::class, 'financialyear'])->name('Registerusers.financialyear');

                // Register Users and Reports
                Route::any('/all-registerusers', [RegisterusersController::class, 'viewregisterusers'])->name('Registerusers.view');
                Route::any('/registerusersReport', [RegisterusersController::class, 'registerusersReport'])->name('Registerusers.viewreport');

                // Deactivate and Block User
                Route::any('/all-deactivateusers', [RegisterusersController::class, 'viewdeactivateusers'])->name('Registerusers.deactivate');
                Route::post('deactivateusers', [RegisterusersController::class, 'deactivateusers'])->name('Registerusers.activate');
                Route::any('/all-blockusers', [RegisterusersController::class, 'viewblockusers'])->name('Registerusers.block');
                Route::post('blockusers', [RegisterusersController::class, 'unblockusers'])->name('Registerusers.unblock');
                Route::any('/block-user-status', [RegisterusersController::class, 'block_user_status'])->name('Registerusers.block_user_status');
                Route::any('/block-updateuser-status/{id}/{status}', [RegisterusersController::class, 'updateblocuserstatus'])->name('Registerusers.block_updateuser_status');

                // Freeze Account
                Route::any('/freez-user-status', [RegisterusersController::class, 'freez_user_status'])->name('Registerusers.freez_user_status');
                Route::any('/freezaccount-updateuser-status/{id}/{status}', [RegisterusersController::class, 'updatefreezuserstatus'])->name('Registerusers.freezaccount_updateuser_status');

                // OTP Limit Management
                Route::any('/manage-otp-limit', [RegisterusersController::class, 'manage_otp_limit'])->name('Registerusers.manage_otp_limit');
                Route::any('/remove_otp_limit', [RegisterusersController::class, 'remove_otp_limit'])->name('Registerusers.remove_otp_limit');

                // Add Fund
                Route::any('/add-fund-list', [RegisterusersController::class, 'add_fund_list'])->name('Registerusers.add_fund_list');
                Route::any('/add-fund-list/download', [RegisterusersController::class, 'add_fund_list_download'])->name('Registerusers.add_fund_list_download');
                Route::any('/all-add-fund', [RegisterusersController::class, 'viewaddfund'])->name('Registerusers.viewaddfund');

                // Downloads and Transactions
                Route::any('/download-users', [RegisterusersController::class, 'downloadusers'])->name('Registerusers.downloadusers');
                Route::any('/view-transactions/{id}', [RegisterusersController::class, 'viewtransactions'])->name('Registerusers.transactions');
                Route::any('/download_user_walllet/{id}', [RegisterusersController::class, 'downloadWalletHistory'])->name('Registerusers.download');

                // User Updates
                Route::any('/update-referjoin/{id}/{status}', [RegisterusersController::class, 'updatereferjoin'])->name('Registerusers.update_refer_join');
                Route::any('/update-user-status/{id}/{status}', [RegisterusersController::class, 'updateuserstatus'])->name('Registerusers.update_user_status');
                Route::any('/deactivate-user-status', [RegisterusersController::class, 'deactivate_user_status'])->name('Registerusers.deactivate_user_status');
                Route::any('/update-percentage', [RegisterusersController::class, 'updatepercentage'])->name('Registerusers.update_percentage');

                // User Views
                Route::any('/view-refered-users', [RegisterusersController::class, 'viewreferedusers'])->name('Registerusers.view_refered_users');
                Route::any('/view-active-users', [RegisterusersController::class, 'viewactiveusers'])->name('Registerusers.view_active_users');
                Route::any('/view-deactived-users', [RegisterusersController::class, 'viewdeactivedusers'])->name('Registerusers.view_deactived_users');

                // Details
                Route::any('/details/{id}', [RegisterusersController::class, 'details'])->name('Registerusers.details');
                Route::any('/edit-details', [RegisterusersController::class, 'edit_details'])->name('Registerusers.edit_details');

                Route::any('/users-wallet', [RegisterusersController::class, 'userswallet'])->name('Registerusers.users_wallet');
                Route::any('/users-promo', [RegisterusersController::class, 'userspromo'])->name('Registerusers.userspromo');
                Route::any('/users-balance-detail', [RegisterusersController::class, 'users_balance_detail'])->name('Registerusers.users_balance_detail');
                Route::any('/users-balance-history/{userid}', [RegisterusersController::class, 'users_balance_history'])->name('Registerusers.users_balance_history');
                Route::any('/users-delete-permanent/{userid}', [RegisterusersController::class, 'users_delete_permanent'])->name('Registerusers.users_delete_permanent');

                Route::any('/view-bank-details/{id}', [RegisterusersController::class, 'viewbankdetails'])->name('Registerusers.view_bank_details');
                Route::any('/update-bank-status', [RegisterusersController::class, 'updatebankstatus'])->name('Registerusers.update_bank_status');
                Route::any('/edit-bank-details/{id}', [RegisterusersController::class, 'editbankdetails'])->name('Registerusers.edit_bank_details');
                Route::any('/verify-bank-account', [RegisterusersController::class, 'verifybankaccount'])->name('Registerusers.verify_bank_account');

                Route::any('/view-pan-details/{id}', [RegisterusersController::class, 'viewpandetails'])->name('Registerusers.view_pan_details');
                Route::any('/update-pan-status', [RegisterusersController::class, 'updatepanstatus'])->name('Registerusers.update_pan_status');
                Route::any('/edit-pan-details/{id}', [RegisterusersController::class, 'editpandetails'])->name('Registerusers.edit_pan_details');
                Route::any('/verify-pan', [RegisterusersController::class, 'verifypan'])->name('Registerusers.verify_pan');

                Route::any('/verify-upi', [RegisterusersController::class, 'verifyupi'])->name('Registerusers.verify_upi');
                Route::any('/view-upi-details/{id}', [RegisterusersController::class, 'viewupidetails'])->name('Registerusers.view_upi_details');
                Route::any('/update-upi-status', [RegisterusersController::class, 'updateupistatus'])->name('Registerusers.update_upi_status');
                Route::any('/edit-upi-details/{id}', [RegisterusersController::class, 'editupidetails'])->name('Registerusers.edit_upi_details');

                Route::any('/verify-address', [RegisterusersController::class, 'verifyaddress'])->name('Registerusers.verify_address');
                Route::any('/view-address-details/{id}', [RegisterusersController::class, 'viewaddressdetails'])->name('Registerusers.view_address_details');
                Route::any('/verifyaddress_status', [RegisterusersController::class, 'verifyaddress_status'])->name('Registerusers.verifyaddress_status');
                Route::any('/edit-address-details/{id}', [RegisterusersController::class, 'editaddressdetails'])->name('Registerusers.edit_address_details');

                Route::any('/verify-adhar', [RegisterusersController::class, 'verifyadhar'])->name('Registerusers.verify_adhar');
                Route::any('/view-adhar-details/{id}', [RegisterusersController::class, 'viewadhardetails'])->name('Registerusers.view_adhar_details');
                Route::any('/update-adhar-status', [RegisterusersController::class, 'updateadharstatus'])->name('Registerusers.update_adhar_status');
                Route::any('/edit-adhar-details/{id}', [RegisterusersController::class, 'editadhardetails'])->name('Registerusers.edit_adhar_details');

                Route::any('/withdraw-amount', [RegisterusersController::class, 'withdraw_amount'])->name('Registerusers.withdraw_amount');
                Route::any('/withdraw-amount-instant', [RegisterusersController::class, 'withdraw_amount_instant'])->name('Registerusers.withdraw_amount_instant');
                Route::any('/update_withdraw_req_id', [RegisterusersController::class, 'update_withdraw_req_id'])->name('Registerusers.update_withdraw_req_id');
                Route::any('/upload-withdrawl-excel', [RegisterusersController::class, 'uploadwithdrawlexcel'])->name('Registerusers.upload_withdrawl_excel');

                Route::any('/approve-paytm-manual', [RegisterusersController::class, 'approve_paytm_manual'])->name('Registerusers.approve_paytm_manual');
                Route::any('/approve', [RegisterusersController::class, 'approve'])->name('Registerusers.approve');
                Route::any('/add-paytm-ben/{id}', [RegisterusersController::class, 'addPaytmBen'])->name('Registerusers.addPaytmBen');
                Route::any('/add-bank-bane-id/{id}', [RegisterusersController::class, 'addBankBaneId'])->name('Registerusers.addBankBaneId');
                Route::any('/remove-user-bane-id/{id}', [RegisterusersController::class, 'removeUserBaneId'])->name('Registerusers.removeUserBaneId');
                Route::any('/check-cashfree-transfer-status/{id}', [RegisterusersController::class, 'checkCashfreeTransaferStatus'])->name('Registerusers.checkCashfreeTransaferStatus');
                Route::any('/reject', [RegisterusersController::class, 'reject'])->name('Registerusers.reject');


                Route::any('/admin-comment-paytm-withdraw', [RegisterusersController::class, 'admin_comment_paytm_withdraw'])->name('Registerusers.admin_comment_paytm_withdraw');
                Route::any('/admin-comment-bank-withdraw', [RegisterusersController::class, 'admin_comment_bank_withdraw'])->name('Registerusers.admin_comment_bank_withdraw');
                Route::any('/withdraw-amount-bank', [RegisterusersController::class, 'withdraw_amount_bank'])->name('Registerusers.withdraw_amount_bank');
                Route::any('/download-all-transaction', [RegisterusersController::class, 'download_all_transaction'])->name('Registerusers.download_all_transaction');
                Route::any('/admin-comment-bank-withdraw-multi', [RegisterusersController::class, 'admin_comment_bank_withdraw_multi'])->name('Registerusers.admin_comment_bank_withdraw_multi');
                Route::any('/manual-withdraw-amount-bank', [RegisterusersController::class, 'manual_withdraw_amount_bank'])->name('Registerusers.manual_withdraw_amount_bank');
                Route::any('/bank-old-withdraw/{id}', [RegisterusersController::class, 'bank_old_withdraw'])->name('Registerusers.bank_old_withdraw');
                Route::any('/approve-bank-manual', [RegisterusersController::class, 'approve_bank_manual'])->name('Registerusers.approve_bank_manual');
                Route::any('/approve-bank', [RegisterusersController::class, 'approve_bank'])->name('Registerusers.approve_bank');
                Route::any('/admin-wallet-info', [RegisterusersController::class, 'adminwalletinfo'])->name('Registerusers.admin_wallet_info');
                Route::any('/admin-wallet-action', [RegisterusersController::class, 'adminwalletaction'])->name('Registerusers.admin_wallet_action');
                Route::any('/user-avatars', [RegisterusersController::class, 'user_avatars'])->name('Registerusers.user_avatars');
                Route::any('/edit-user-avatars/{id}', [RegisterusersController::class, 'edit_user_avatars'])->name('Registerusers.edit_user_avatars');
                Route::any('/edit_users_amount/{id}', [RegisterusersController::class, 'edit_users_amount'])->name('Registerusers.edit_users_amount');
                Route::any('/deduct_users_amount/{id}', [RegisterusersController::class, 'deduct_users_amount'])->name('Registerusers.deduct_users_amount');
                Route::any('/add-user-avatars', [RegisterusersController::class, 'add_user_avatars'])->name('Registerusers.add_user_avatars');
                Route::any('/add-moneyin-wallet/{id}', [RegisterusersController::class, 'addmoneyinwallet'])->name('Registerusers.add_moneyin_wallet');
                Route::any('/user-balances-detail', [RegisterusersController::class, 'userbalancesdetail'])->name('Registerusers.user_balances_detail');
                Route::any('/add-user', [RegisterusersController::class, 'adduser'])->name('Registerusers.add_user');
                Route::any('/view-user/{id}', [RegisterusersController::class, 'viewuser'])->name('Registerusers.view_user');
                Route::any('/edit-user/{id}', [RegisterusersController::class, 'edituser'])->name('Registerusers.edit_user');
                Route::any('/refer-detail/{id}', [RegisterusersController::class, 'referdetail'])->name('Registerusers.refer_detail');
                Route::any('/withdraw-detail/{id}', [RegisterusersController::class, 'withdrawdetail'])->name('Registerusers.withdraw_detail');
                Route::any('/add-cash-list/{id}', [RegisterusersController::class, 'addcashlist'])->name('Registerusers.add_cash_list');
                Route::any('/join-leauges/{id}', [RegisterusersController::class, 'joinleauges'])->name('Registerusers.join_leauges');
                Route::any('/match-detail/{id}/{matchkey}', [RegisterusersController::class, 'matchdetail'])->name('Registerusers.match_detail');
                Route::any('/user-team/{id}', [RegisterusersController::class, 'userteam'])->name('Registerusers.user_team');
                Route::any('/edit-team/{id}', [RegisterusersController::class, 'editteam'])->name('Registerusers.edit_team');
                Route::any('/update-team/{id}', [RegisterusersController::class, 'update_team'])->name('Registerusers.update_team');
                Route::any('/wallet-data', [RegisterusersController::class, 'downloadwallet'])->name('Registerusers.walletdata');
                Route::any('/bulk-add-cash', [RegisterusersController::class, 'bulk_add_cash'])->name('Registerusers.bulk_add_cash');
                Route::any('/get-bulk-add-cash', [RegisterusersController::class, 'get_bulk_add_cash'])->name('Registerusers.get_bulk_add_cash');
            });


            Route::group(['prefix' => 'Promotors'], function () {
                Route::any('/all-Promotors', [PromotorsController::class, 'viewpromotors'])->name("Promotors.view");
                Route::any('/Promotors-channel-detail/{user_id}', [PromotorsController::class, 'promotorschanneldetail'])->name("Promotors.channeldetail");
                Route::any('/promotors-details', [PromotorsController::class, 'promotordetails'])->name("Promotors.details");
                Route::any('/promotors-download', [PromotorsController::class, 'promotorDetailsDownload'])->name("Promotors.download");

                Route::any('/add-leaderboard', [PromotorsController::class, 'addleaderboards'])->name("Promotors.addleader");
                Route::any('/all-leaderboards', [PromotorsController::class, 'viewleaderboards'])->name("Promotors.viewleader");
                Route::any('/update-leaderboard/{id}', [PromotorsController::class, 'editleaderboards'])->name("Promotors.edit");
                Route::any('/delete-leaderboard/{id}', [PromotorsController::class, 'deleteleaderboards'])->name("Promotors.delete");
                Route::any('/get-leaderboard_users', [PromotorsController::class, 'getleaderboard_users'])->name("Promotors.getleaderboard_users");
            });

            /*################################### End Team #############################*/

            /*################################### Analytics Report #############################*/
            Route::group(['prefix' => 'analytics'], function () {
                Route::any('/gst_report_cron', [AnalyticsController::class, 'gstreportcron'])->name("Analytics.gst_report_cron");
                Route::any('/gst_report_deposit', [AnalyticsController::class, 'gstreportdeposit'])->name("Analytics.gst_report_deposit");
                Route::any('/gst-report', [AnalyticsController::class, 'gstreport'])->name("Analytics.gst_report");

                // New GST Calculation
                Route::any('/gst_report_new_deposit', [AnalyticsController::class, 'gstreportnewdeposit'])->name("Analytics.gst_report_new_deposit");
                Route::any('/gst_report_total_add', [AnalyticsController::class, 'gstReportTotalAddCash'])->name("Analytics.gst_report_total_add");
                Route::any('/gst-report2', [AnalyticsController::class, 'gstreport'])->name("Analytics.gst_report2");

                Route::any('/download-gst-report', [AnalyticsController::class, 'downloadgstreport'])->name("Analytics.download_gst_report");
                Route::any('/profit-loss', [AnalyticsController::class, 'profitloss'])->name("Analytics.profit_loss");
                Route::any('/get-all-series-matches', [AnalyticsController::class, 'getAllSeriesMatches'])->name("Analytics.getAllSeriesMatches");
                Route::any('/total-profit-loss', [AnalyticsController::class, 'totalProfitLoss'])->name("Analytics.totalProfitLoss");
                Route::any('/user-transactions-reconcilation', [AnalyticsController::class, 'userTransactionsReconcilation'])->name("Analytics.user_transactions_reconcilation");
            });
            /*################################### End Team #############################*/


            /*##########################  notifications  ############################## */

            Route::group(['prefix' => 'notification'], function () {
                Route::any('/pushnotifications', [NotificationController::class, 'pushnotifications'])->name("Notification.pushnotifications");
                Route::any('/pushnotificationsCustom', [NotificationController::class, 'pushnotificationsCustom'])->name("Notification.pushnotificationsCustom");
                Route::any('/smsnotifications', [NotificationController::class, 'smsnotifications'])->name("Notification.smsnotifications");
                Route::any('/emailnotifications', [NotificationController::class, 'emailnotifications'])->name("Notification.emailnotifications");
                Route::any('/notifications-history/{type}', [NotificationController::class, 'notifications_history'])->name("Notification.notifications_history");
                Route::any('/notifications-history-custom/{type}', [NotificationController::class, 'notifications_history_custom'])->name("Notification.notifications_history_custom");
                Route::any('/emailnotifications_queue', [NotificationController::class, 'emailnotifications_queue'])->name("Notification.emailnotifications_queue");
            });




            /*########################## end notifications  ############################## */
        });
    });
});

/*################################### Admin  Routes End ###############################################*/

/*################################### Front  Routes Start ###############################################*/

//Route::get('/home','HomeController@home')->name('home');
//Route::group(['middleware' => 'throttle:3,1'], function () {


Route::group(['middleware' => GuestAdmin::class], function () {
    // Home routes
    Route::post('forgot', [HomeController::class, 'forgot_password'])->name("home.forgot");
    Route::any('email-verification/{validateStr}', [HomeController::class, 'user_verification'])->name("email_verify");
    Route::get('send_verifylink_again/{verification_link}', [HomeController::class, 'send_verifylink_again'])->name("home.sendverifylinkagain");
    Route::get('resetpassword/{verification_link}', [HomeController::class, 'resetpassword'])->name("home.resetpassword");
    Route::post('save_password', [HomeController::class, 'resetPasswordSave'])->name("home.save_password");
    Route::any('newsletter-subscribe', [HomeController::class, 'subscriber'])->name("newsletter.subscribe");
    Route::any('newsletter-unsubscribe/{enc_id}', [HomeController::class, 'unsubscribe_newsletter'])->name("newsletter.unsubscribe");

    Route::get('/', [HomeController::class, 'index'])->name("home");
    Route::get('login', [HomeController::class, 'login'])->name("login");

    /*#### User Routing starts ####*/
    Route::any('/register', [UserController::class, 'register'])->name("User.register");
    Route::get('/sign-up', [UserController::class, 'signup'])->name("signup");
    Route::post('/sign-up-save', [UserController::class, 'saveSignUp'])->name("saveSignUp");
    Route::post('get-login', [UserController::class, 'login'])->name("get_login");
    Route::get('forgot-password', [UserController::class, 'forgot_password'])->name("User.forgot_password");
    Route::post('send-password', [UserController::class, 'sendPassword'])->name("User.sendPassword");
    Route::get('reset-password/{validate_string}', [UserController::class, 'reset_password'])->name("User.reset_password");
    Route::post('reset-password-save/{validate_string}', [UserController::class, 'resetPasswordSave'])->name("User.resetPasswordSave");
    /*#### User Routing end ####*/
});


/*################################### Front  Routes End ###############################################*/
